package ext.chart.series.sprite {
[Native("Ext.chart.series.sprite.Bar", require)]
/**
 * Draws a sprite used in the bar series.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Bar.html Original Ext JS documentation of 'Ext.chart.series.sprite.Bar'
 */
public class BarSeriesSprite extends StackedCartesianSeriesSprite {
  /**
   * @inheritDoc
   */
  public function BarSeriesSprite(config:BarSeriesSprite = null) {
    super();
  }

  [ExtConfig]
  /**
   * The gap between grouped bars.
   * @default 3
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Bar.html#cfg-inGroupGapWidth Original Ext JS documentation of 'inGroupGapWidth'
   */
  public native function get inGroupGapWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set inGroupGapWidth(value:Number):void;

  [ExtConfig]
  /**
   * The maximum bar width.
   * @default 100
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Bar.html#cfg-maxBarWidth Original Ext JS documentation of 'maxBarWidth'
   */
  public native function get maxBarWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maxBarWidth(value:Number):void;

  [ExtConfig]
  /**
   * The minimum bar width.
   * @default 2
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Bar.html#cfg-minBarWidth Original Ext JS documentation of 'minBarWidth'
   */
  public native function get minBarWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set minBarWidth(value:Number):void;

  [ExtConfig]
  /**
   * The minimum gap between bars.
   * @default 5
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Bar.html#cfg-minGapWidth Original Ext JS documentation of 'minGapWidth'
   */
  public native function get minGapWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set minGapWidth(value:Number):void;

  [ExtConfig]
  /**
   * The degree of rounding for rounded bars.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Bar.html#cfg-radius Original Ext JS documentation of 'radius'
   */
  public native function get radius():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set radius(value:Number):void;
}
}