package ext.chart.series.sprite {
[Native("Ext.chart.series.sprite.BoxPlot", require)]
/**
 * BoxPlot series sprite that manages →<code>ext.chart.sprite.BoxPlotSprite</code> instances.
 * @see ext.chart.sprite.BoxPlotSprite
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.BoxPlot.html Original Ext JS documentation of 'Ext.chart.series.sprite.BoxPlot'
 */
public class BoxPlotSeriesSprite extends CartesianSeriesSprite {
  /**
   * @inheritDoc
   */
  public function BoxPlotSeriesSprite(config:BoxPlotSeriesSprite = null) {
    super();
  }

  [ArrayElementType("Number")]
  [ExtConfig]
  /**
   * Array of coordinated maximum values.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.BoxPlot.html#cfg-dataHigh Original Ext JS documentation of 'dataHigh'
   */
  public native function get dataHigh():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dataHigh(value:Array):void;

  [ArrayElementType("Number")]
  [ExtConfig]
  /**
   * Array of coordinated minimum values.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.BoxPlot.html#cfg-dataLow Original Ext JS documentation of 'dataLow'
   */
  public native function get dataLow():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dataLow(value:Array):void;

  [ArrayElementType("Number")]
  [ExtConfig]
  /**
   * The <code>→dataMedian</code> attribute can be used to set the value of
   * the <code>→dataY</code> attribute. E.g.:
   * <pre>
   * sprite.setAttributes({
   *     dataMedian: [...]
   * });
   * </pre>
   * <p>To fetch the value of the attribute one has to use</p>
   * <pre>
   * sprite.attr.dataY // array of coordinated median values
   * </pre>
   * <p>and not</p>
   * <pre>
   * sprite.attr.dataMedian // WRONG!
   * </pre>
   * <p><code>→dataY</code> attribute is defined by the <code>→ext.chart.series.sprite.SeriesSprite</code>.</p>
   * <p>Array of coordinated median values.</p>
   * @see #dataMedian
   * @see #dataY
   * @see ext.chart.series.sprite.SeriesSprite
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.BoxPlot.html#cfg-dataMedian Original Ext JS documentation of 'dataMedian'
   */
  public native function get dataMedian():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dataMedian(value:Array):void;

  [ArrayElementType("Number")]
  [ExtConfig]
  /**
   * Array of coordinated 1-st quartile values.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.BoxPlot.html#cfg-dataQ1 Original Ext JS documentation of 'dataQ1'
   */
  public native function get dataQ1():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dataQ1(value:Array):void;

  [ArrayElementType("Number")]
  [ExtConfig]
  /**
   * Array of coordinated 3-rd quartile values.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.BoxPlot.html#cfg-dataQ3 Original Ext JS documentation of 'dataQ3'
   */
  public native function get dataQ3():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dataQ3(value:Array):void;

  [ExtConfig]
  /**
   * The maximum box width.
   * @default 20
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.BoxPlot.html#cfg-maxBoxWidth Original Ext JS documentation of 'maxBoxWidth'
   */
  public native function get maxBoxWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maxBoxWidth(value:Number):void;

  [ExtConfig]
  /**
   * The minimum box width.
   * @default 2
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.BoxPlot.html#cfg-minBoxWidth Original Ext JS documentation of 'minBoxWidth'
   */
  public native function get minBoxWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set minBoxWidth(value:Number):void;

  [ExtConfig]
  /**
   * The minimum gap between boxes.
   * @default 5
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.BoxPlot.html#cfg-minGapWidth Original Ext JS documentation of 'minGapWidth'
   */
  public native function get minGapWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set minGapWidth(value:Number):void;
}
}