package ext.chart.series.sprite {
[Native("Ext.chart.series.sprite.CandleStick", require)]
/**
 * CandleStick series sprite.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.CandleStick.html Original Ext JS documentation of 'Ext.chart.series.sprite.CandleStick'
 */
public class CandleStickSeriesSprite extends AggregativeSeriesSprite {
  /**
   * @inheritDoc
   */
  public function CandleStickSeriesSprite(config:CandleStickSeriesSprite = null) {
    super();
  }

  [ExtConfig]
  /**
   * The bar width of the candles.
   * @default 15
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.CandleStick.html#cfg-barWidth Original Ext JS documentation of 'barWidth'
   */
  public native function get barWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set barWidth(value:Number):void;

  [ExtConfig]
  /**
   * Determines whether candlestick
   * or ohlc is used.
   * @default 'candlestick'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.CandleStick.html#cfg-ohlcType Original Ext JS documentation of 'ohlcType'
   */
  public native function get ohlcType():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ohlcType(value:String):void;

  [ExtConfig]
  /**
   * The amount of padding between candles.
   * @default 3
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.CandleStick.html#cfg-padding Original Ext JS documentation of 'padding'
   */
  public native function get padding():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set padding(value:Number):void;
}
}