package ext.chart.series.sprite {
import ext.draw.Surface;

[Native("Ext.chart.series.sprite.Cartesian", require)]
/**
 * Cartesian sprite.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Cartesian.html Original Ext JS documentation of 'Ext.chart.series.sprite.Cartesian'
 */
public class CartesianSeriesSprite extends SeriesSprite {
  /**
   * @inheritDoc
   */
  public function CartesianSeriesSprite(config:CartesianSeriesSprite = null) {
    super();
  }

  [ExtConfig]
  /**
   * If flipXY is 'true', the series is flipped.
   * @default 'bool'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Cartesian.html#cfg-flipXY Original Ext JS documentation of 'flipXY'
   */
  public native function get flipXY():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set flipXY(value:Boolean):void;

  [ExtConfig]
  /**
   * The distance from the event position to the sprite's data points to trigger
   * interactions (used for 'iteminfo', etc).
   * @default 20
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Cartesian.html#cfg-selectionTolerance Original Ext JS documentation of 'selectionTolerance'
   */
  public native function get selectionTolerance():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set selectionTolerance(value:Number):void;

  /**
   * Does a binary search of the data on the x-axis using the given key.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Cartesian.html#method-binarySearch Original Ext JS documentation of 'binarySearch'
   */
  public native function binarySearch(key:String):*;

  [Deprecated(replacement="getNearestDataPoint", since="6.5.2")]
  /**
   * Get the nearest item index from point (x, y). -1 as not found.
   * @return The index
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Cartesian.html#method-getIndexNearPoint Original Ext JS documentation of 'getIndexNearPoint'
   */
  public native function getIndexNearPoint(x:Number, y:Number):Number;

  /**
   * Given a point in 'series' surface element coordinates, returns the <code>index</code> of the
   * sprite's data point that is nearest to that point, along with the <code>distance</code>
   * between points.
   * If the <code>→selectionTolerance</code> attribute of the sprite is not zero, only the data points
   * that are within that pixel distance from the given point will be checked.
   * In the event no such data points exist or the data is empty, <code>null</code> is returned.
   * <p>Notes:</p>
   * <ol>
   * <li>given a mouse/pointer event object, the surface coordinates of the event can be
   * obtained with the <code>getEventXY</code> method of the chart;</li>
   * <li>using <code>→selectionTolerance</code> of zero is useful for series with no visible markers,
   * such as the Area series, where this attribute becomes meaningless.</li>
   * </ol>
   * @see #selectionTolerance
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Cartesian.html#method-getNearestDataPoint Original Ext JS documentation of 'getNearestDataPoint'
   */
  public native function getNearestDataPoint(x:Number, y:Number):Object;

  /**
   * Render the given visible clip range.
   * @param surface A draw container surface.
   * @param ctx A context object that is API compatible with the native
   * <a href="https://developer.mozilla.org/en/docs/Web/API/CanvasRenderingContext2D">CanvasRenderingContext2D</a>.
   * @param dataClipRect The clip rect in data coordinates, roughly equivalent to
   * [attr.dataMinX, attr.dataMinY, attr.dataMaxX, attr.dataMaxY] for an untranslated/unscaled
   * surface/sprite.
   * @param surfaceClipRect The clip rect in surface coordinates:
   * [left, top, width, height].
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Cartesian.html#method-renderClipped Original Ext JS documentation of 'renderClipped'
   */
  public native function renderClipped(surface:Surface, ctx:Object, dataClipRect:Array, surfaceClipRect:Array):void;
}
}