package ext.chart.series.sprite {
import ext.chart.ChartMarkers;
import ext.chart.IChartMarkerHolder;
import ext.draw.sprite.PathSprite;

[Native("Ext.chart.series.sprite.Pie3DPart", require)]
/**
 * Pie3D series sprite.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Pie3DPart.html Original Ext JS documentation of 'Ext.chart.series.sprite.Pie3DPart'
 */
public class Pie3DPartSprite extends PathSprite implements IChartMarkerHolder {
  /**
   * @inheritDoc
   */
  public function Pie3DPartSprite(config:Pie3DPartSprite = null) {
    super();
  }

  [ExtConfig]
  /**
   * The color of the 3D pie part before adding the 3D effect.
   * @default 'white'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Pie3DPart.html#cfg-baseColor Original Ext JS documentation of 'baseColor'
   */
  public native function get baseColor():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set baseColor(value:Object):void;

  [ExtConfig]
  /**
   * The starting rotation of the polar series.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Pie3DPart.html#cfg-baseRotation Original Ext JS documentation of 'baseRotation'
   */
  public native function get baseRotation():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set baseRotation(value:Number):void;

  [ExtConfig]
  /**
   * The size of the 3D pie bevel.
   * @default 5
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Pie3DPart.html#cfg-bevelWidth Original Ext JS documentation of 'bevelWidth'
   */
  public native function get bevelWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set bevelWidth(value:Number):void;

  [ExtConfig]
  /**
   * The central point of the series on the x-axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Pie3DPart.html#cfg-centerX Original Ext JS documentation of 'centerX'
   */
  public native function get centerX():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set centerX(value:Number):void;

  [ExtConfig]
  /**
   * The central point of the series on the x-axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Pie3DPart.html#cfg-centerY Original Ext JS documentation of 'centerY'
   */
  public native function get centerY():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set centerY(value:Number):void;

  [ExtConfig]
  /**
   * An attribute used to control how flat the gradient of the sprite looks.
   * A value of 0 essentially means no gradient (flat color).
   * @default 0.7
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Pie3DPart.html#cfg-colorSpread Original Ext JS documentation of 'colorSpread'
   */
  public native function get colorSpread():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set colorSpread(value:Number):void;

  [ExtConfig]
  /**
   * The distortion of the 3D pie part.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Pie3DPart.html#cfg-distortion Original Ext JS documentation of 'distortion'
   */
  public native function get distortion():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set distortion(value:Number):void;

  [ExtConfig]
  /**
   * The ending angle of the polar series.
   * @default Math.PI
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Pie3DPart.html#cfg-endAngle Original Ext JS documentation of 'endAngle'
   */
  public native function get endAngle():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set endAngle(value:Number):void;

  [ExtConfig]
  /**
   * The ending radius of the polar series.
   * @default 150
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Pie3DPart.html#cfg-endRho Original Ext JS documentation of 'endRho'
   */
  public native function get endRho():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set endRho(value:Number):void;

  [ExtConfig]
  /**
   * The label associated with the 'top' part of the sprite.
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Pie3DPart.html#cfg-label Original Ext JS documentation of 'label'
   */
  public native function get label():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set label(value:String):void;

  [ExtConfig]
  /**
   * Margin from the center of the pie. Used for donut.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Pie3DPart.html#cfg-margin Original Ext JS documentation of 'margin'
   */
  public native function get margin():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set margin(value:Number):void;

  [ExtConfig]
  /**
   * The part of the 3D Pie represented by the sprite.
   * @default 'top'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Pie3DPart.html#cfg-part Original Ext JS documentation of 'part'
   */
  public native function get part():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set part(value:String):void;

  [ExtConfig]
  /**
   * The starting angle of the polar series.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Pie3DPart.html#cfg-startAngle Original Ext JS documentation of 'startAngle'
   */
  public native function get startAngle():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set startAngle(value:Number):void;

  [ExtConfig]
  /**
   * The starting radius of the polar series.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Pie3DPart.html#cfg-startRho Original Ext JS documentation of 'startRho'
   */
  public native function get startRho():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set startRho(value:Number):void;

  [ExtConfig]
  /**
   * The thickness of the 3D pie part.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Pie3DPart.html#cfg-thickness Original Ext JS documentation of 'thickness'
   */
  public native function get thickness():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set thickness(value:Number):void;

  /**
   * @inheritDoc
   */
  public native function bindMarker(name:String, marker:ChartMarkers):void;

  /**
   * @inheritDoc
   */
  public native function getBoundMarker(name:String):Array;

  /**
   * @inheritDoc
   */
  public native function getMarker(name:String):ChartMarkers;

  /**
   * @inheritDoc
   */
  public native function releaseMarker(marker:*):ChartMarkers;
}
}