package ext.chart.series.sprite {
import ext.chart.ChartMarkers;
import ext.chart.IChartMarkerHolder;
import ext.draw.sprite.PathSprite;
import ext.draw.sprite.SectorSprite;

[Native("Ext.chart.series.sprite.PieSlice", require)]
/**
 * Pie slice sprite.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.PieSlice.html Original Ext JS documentation of 'Ext.chart.series.sprite.PieSlice'
 */
public class PieSliceSprite extends SectorSprite implements IChartMarkerHolder {
  /**
   * @inheritDoc
   */
  public function PieSliceSprite(config:PieSliceSprite = null) {
    super();
  }

  [ExtConfig]
  /**
   * 'true' if the pie series uses label callouts.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.PieSlice.html#cfg-doCallout Original Ext JS documentation of 'doCallout'
   */
  public native function get doCallout():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set doCallout(value:Boolean):void;

  [ExtConfig]
  /**
   * Label associated with the Pie sprite.
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.PieSlice.html#cfg-label Original Ext JS documentation of 'label'
   */
  public native function get label():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set label(value:String):void;

  [ExtConfig]
  /**
   * Padding around labels to determine overlap.
   * Any negative number allows the labels to overlap.
   * @default 10
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.PieSlice.html#cfg-labelOverflowPadding Original Ext JS documentation of 'labelOverflowPadding'
   */
  public native function get labelOverflowPadding():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelOverflowPadding(value:Number):void;

  /**
   * @inheritDoc
   */
  public native function bindMarker(name:String, marker:ChartMarkers):void;

  /**
   * @inheritDoc
   */
  public native function getBoundMarker(name:String):Array;

  /**
   * @inheritDoc
   */
  public native function getMarker(name:String):ChartMarkers;

  /**
   * @inheritDoc
   */
  public native function releaseMarker(marker:*):ChartMarkers;
}
}