package ext.chart.series.sprite {
[Native("Ext.chart.series.sprite.Polar", require)]
/**
 * Polar sprite.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Polar.html Original Ext JS documentation of 'Ext.chart.series.sprite.Polar'
 */
public class PolarSeriesSprite extends SeriesSprite {
  /**
   * @inheritDoc
   */
  public function PolarSeriesSprite(config:PolarSeriesSprite = null) {
    super();
  }

  [ExtConfig]
  /**
   * The starting rotation of the polar series.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Polar.html#cfg-baseRotation Original Ext JS documentation of 'baseRotation'
   */
  public native function get baseRotation():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set baseRotation(value:Number):void;

  [ExtConfig]
  /**
   * The central point of the series on the x-axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Polar.html#cfg-centerX Original Ext JS documentation of 'centerX'
   */
  public native function get centerX():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set centerX(value:Number):void;

  [ExtConfig]
  /**
   * The central point of the series on the y-axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Polar.html#cfg-centerY Original Ext JS documentation of 'centerY'
   */
  public native function get centerY():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set centerY(value:Number):void;

  [ExtConfig]
  /**
   * The ending angle of the polar series.
   * @default Math.PI
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Polar.html#cfg-endAngle Original Ext JS documentation of 'endAngle'
   */
  public native function get endAngle():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set endAngle(value:Number):void;

  [ExtConfig]
  /**
   * The ending radius of the polar series.
   * @default 150
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Polar.html#cfg-endRho Original Ext JS documentation of 'endRho'
   */
  public native function get endRho():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set endRho(value:Number):void;

  [ExtConfig]
  /**
   * The starting angle of the polar series.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Polar.html#cfg-startAngle Original Ext JS documentation of 'startAngle'
   */
  public native function get startAngle():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set startAngle(value:Number):void;

  [ExtConfig]
  /**
   * The starting radius of the polar series.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Polar.html#cfg-startRho Original Ext JS documentation of 'startRho'
   */
  public native function get startRho():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set startRho(value:Number):void;
}
}