package ext.chart.series.sprite {
import ext.chart.ChartMarkers;
import ext.chart.IChartMarkerHolder;
import ext.draw.sprite.Sprite;
import ext.mixin.Observable;

[Native("Ext.chart.series.sprite.Series", require)]
/**
 * Base class for all series sprites.
 * Defines attributes common to all series sprites, like data in x/y directions and its
 * min/max values, and configs, like the →<code>ext.chart.series.Series</code> instance that manages
 * the sprite.
 * @see ext.chart.series.Series
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Series.html Original Ext JS documentation of 'Ext.chart.series.sprite.Series'
 */
public class SeriesSprite extends Sprite implements IChartMarkerHolder {
  /**
   * @inheritDoc
   */
  public function SeriesSprite(config:SeriesSprite = null) {
    super();
  }

  [ExtConfig]
  /**
   * Data maximum on the x-axis.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Series.html#cfg-dataMaxX Original Ext JS documentation of 'dataMaxX'
   */
  public native function get dataMaxX():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dataMaxX(value:Number):void;

  [ExtConfig]
  /**
   * Data maximum on the y-axis.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Series.html#cfg-dataMaxY Original Ext JS documentation of 'dataMaxY'
   */
  public native function get dataMaxY():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dataMaxY(value:Number):void;

  [ExtConfig]
  /**
   * Data minimum on the x-axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Series.html#cfg-dataMinX Original Ext JS documentation of 'dataMinX'
   */
  public native function get dataMinX():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dataMinX(value:Number):void;

  [ExtConfig]
  /**
   * Data minimum on the y-axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Series.html#cfg-dataMinY Original Ext JS documentation of 'dataMinY'
   */
  public native function get dataMinY():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dataMinY(value:Number):void;

  [ExtConfig]
  /**
   * Data items on the x-axis.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Series.html#cfg-dataX Original Ext JS documentation of 'dataX'
   */
  public native function get dataX():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dataX(value:Object):void;

  [ExtConfig]
  /**
   * Data items on the y-axis.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Series.html#cfg-dataY Original Ext JS documentation of 'dataY'
   */
  public native function get dataY():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dataY(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The store field used by the series.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Series.html#cfg-field Original Ext JS documentation of 'field'
   * @see #getField()
   * @see #setField()
   */
  public native function get field():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set field(value:String):void;

  [ExtConfig]
  /**
   * Padding around labels to determine
   * overlap.
   * @default 10
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Series.html#cfg-labelOverflowPadding Original Ext JS documentation of 'labelOverflowPadding'
   */
  public native function get labelOverflowPadding():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelOverflowPadding(value:Number):void;

  [ExtConfig]
  /**
   * Labels used in the series.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Series.html#cfg-labels Original Ext JS documentation of 'labels'
   */
  public native function get labels():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labels(value:Object):void;

  [ExtConfig]
  /**
   * Data range derived from all the series bound
   * to the x-axis.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Series.html#cfg-rangeX Original Ext JS documentation of 'rangeX'
   */
  public native function get rangeX():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set rangeX(value:Array):void;

  [ExtConfig]
  /**
   * Data range derived from all the series bound
   * to the y-axis.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.series.sprite.Series.html#cfg-rangeY Original Ext JS documentation of 'rangeY'
   */
  public native function get rangeY():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set rangeY(value:Array):void;

  /**
   * @inheritDoc
   */
  public native function bindMarker(name:String, marker:ChartMarkers):void;

  /**
   * @inheritDoc
   */
  public native function getBoundMarker(name:String):Array;

  /**
   * Returns the value of <code>field</code>.
   * @see #field
   */
  public native function getField():String;

  /**
   * @inheritDoc
   */
  public native function getMarker(name:String):ChartMarkers;

  /**
   * @inheritDoc
   */
  public native function releaseMarker(marker:*):ChartMarkers;

  /**
   * Sets the value of <code>field</code>.
   * @param field The new value.
   * @see #field
   */
  public native function setField(field:String):void;
}
}