package ext.chart.sprite {
import ext.draw.sprite.Sprite;
import ext.mixin.Observable;

[Native("Ext.chart.sprite.Bar3D", require)]
/**
 * A sprite that represents a 3D bar or column.
 * Used as an item template by the →<code>ext.chart.series.sprite.Bar3DSeriesSprite</code> marker holder.
 * @see ext.chart.series.sprite.Bar3DSeriesSprite
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.Bar3D.html Original Ext JS documentation of 'Ext.chart.sprite.Bar3D'
 */
public class Bar3DSprite extends Sprite {
  /**
   * @inheritDoc
   */
  public function Bar3DSprite(config:Bar3DSprite = null) {
    super(config);
  }

  [ExtConfig]
  /**
   * The factor applied to the brightness of the box.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.Bar3D.html#cfg-brightnessFactor Original Ext JS documentation of 'brightnessFactor'
   */
  public native function get brightnessFactor():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set brightnessFactor(value:Number):void;

  [ExtConfig]
  /**
   * An attribute used to control how flat the bar gradient looks.
   * A value of 0 essentially means no gradient (flat color).
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.Bar3D.html#cfg-colorSpread Original Ext JS documentation of 'colorSpread'
   */
  public native function get colorSpread():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set colorSpread(value:Number):void;

  [ExtConfig]
  /**
   * The depth of the box.
   * @default 8
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.Bar3D.html#cfg-depth Original Ext JS documentation of 'depth'
   */
  public native function get depth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set depth(value:Number):void;

  [ExtConfig]
  /**
   * The height of the box.
   * @default 8
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.Bar3D.html#cfg-height Original Ext JS documentation of 'height'
   */
  public native function get height():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set height(value:Number):void;

  [ExtConfig]
  /**
   * The orientation of the box.
   * @default 'vertical'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.Bar3D.html#cfg-orientation Original Ext JS documentation of 'orientation'
   */
  public native function get orientation():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set orientation(value:String):void;

  [ExtConfig]
  /**
   * The factor applied to the saturation of the box.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.Bar3D.html#cfg-saturationFactor Original Ext JS documentation of 'saturationFactor'
   */
  public native function get saturationFactor():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set saturationFactor(value:Number):void;

  [ExtConfig]
  /**
   * Whether to render the stroke or not.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.Bar3D.html#cfg-showStroke Original Ext JS documentation of 'showStroke'
   */
  public native function get showStroke():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set showStroke(value:Boolean):void;

  [ExtConfig]
  /**
   * The width of the box.
   * @default 8
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.Bar3D.html#cfg-width Original Ext JS documentation of 'width'
   */
  public native function get width():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set width(value:Number):void;

  [ExtConfig]
  /**
   * The position of the sprite on the x-axis.
   * Corresponds to the center of the front face of the box.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.Bar3D.html#cfg-x Original Ext JS documentation of 'x'
   */
  public native function get x():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set x(value:Number):void;

  [ExtConfig]
  /**
   * The position of the sprite on the y-axis.
   * Corresponds to the top of the front face of the box.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.Bar3D.html#cfg-y Original Ext JS documentation of 'y'
   */
  public native function get y():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set y(value:Number):void;
}
}