package ext.chart.sprite {
import ext.draw.sprite.Sprite;
import ext.mixin.Observable;

[Native("Ext.chart.sprite.BoxPlot", require)]
/**
 * A sprite that represents an individual box with whiskers.
 * This sprite is meant to be managed by the →<code>ext.chart.series.sprite.BoxPlotSeriesSprite</code>
 * →<code>ext.chart.ChartMarkerHolder</code>, but can also be used independently:
 * <p><b>Example:</b></p>
 * <pre>
 * new Ext.draw.Container({
 *     width: 100,
 *     height: 100,
 *     renderTo: Ext.getBody(),
 *     sprites: [{
 *         type: 'boxplot',
 *         translationX: 50,
 *         translationY: 50
 *     }]
 * });
 * </pre>
 * <p>IMPORTANT: the attributes that represent y-coordinates are in screen coordinates,
 * just like with any other sprite. For this particular sprite this means that, if 'low'
 * and 'high' attributes are 10 and 90, then the minimium whisker is rendered at the top
 * of a draw container <i>surface</i> (→<code>ext.draw.Surface</code>) at y = 10, and the maximum whisker
 * is rendered at the bottom at y = 90. But because the series surface is flipped vertically
 * in cartesian charts, this means that there minimum is rendered at the bottom and maximum
 * at the top, just as one would expect.</p>
 * @see ext.chart.series.sprite.BoxPlotSeriesSprite
 * @see ext.chart.ChartMarkerHolder
 * @see ext.draw.Surface
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.BoxPlot.html Original Ext JS documentation of 'Ext.chart.sprite.BoxPlot'
 */
public class BoxPlotSprite extends Sprite {
  /**
   * @inheritDoc
   */
  public function BoxPlotSprite(config:BoxPlotSprite = null) {
    super(config);
  }

  [ExtConfig]
  /**
   * The width of the box in pixels.
   * @default 12
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.BoxPlot.html#cfg-boxWidth Original Ext JS documentation of 'boxWidth'
   */
  public native function get boxWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set boxWidth(value:Number):void;

  [ExtConfig]
  /**
   * Whether to snap the rendered lines to the pixel grid
   * of not. Generally, it's best to have this set to <code>true</code> (which is the default)
   * for pixel perfect results (especially on non-HiDPI displays), but for boxplots
   * with small <code>→boxWidth</code> visible artifacts caused by pixel grid snapping may become
   * noticeable, and setting this to <code>false</code> can be a remedy at the expense
   * of clarity.
   * @default true
   * @see #boxWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.BoxPlot.html#cfg-crisp Original Ext JS documentation of 'crisp'
   */
  public native function get crisp():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set crisp(value:Boolean):void;

  [ExtConfig]
  /**
   * The y-coordinate of the whisker that represents
   * the maximum.
   * @default 20
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.BoxPlot.html#cfg-high Original Ext JS documentation of 'high'
   */
  public native function get high():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set high(value:Number):void;

  [ExtConfig]
  /**
   * The y-coordinate of the whisker that represents
   * the minimum.
   * @default -20
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.BoxPlot.html#cfg-low Original Ext JS documentation of 'low'
   */
  public native function get low():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set low(value:Number):void;

  [ExtConfig]
  /**
   * The y-coordinate of the line that represents the median.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.BoxPlot.html#cfg-median Original Ext JS documentation of 'median'
   */
  public native function get median():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set median(value:Number):void;

  [ExtConfig]
  /**
   * The y-coordinate of the box edge that represents
   * the 1-st quartile.
   * @default -10
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.BoxPlot.html#cfg-q1 Original Ext JS documentation of 'q1'
   */
  public native function get q1():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set q1(value:Number):void;

  [ExtConfig]
  /**
   * The y-coordinate of the box edge that represents
   * the 3-rd quartile.
   * @default 10
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.BoxPlot.html#cfg-q3 Original Ext JS documentation of 'q3'
   */
  public native function get q3():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set q3(value:Number):void;

  [ExtConfig]
  /**
   * The length of the lines at the ends
   * of the whiskers, as a ratio of <code>→boxWidth</code>.
   * @default 0.5
   * @see #boxWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.BoxPlot.html#cfg-whiskerWidth Original Ext JS documentation of 'whiskerWidth'
   */
  public native function get whiskerWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set whiskerWidth(value:Number):void;

  [ExtConfig]
  /**
   * The coordinate of the horizontal center of a boxplot.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.BoxPlot.html#cfg-x Original Ext JS documentation of 'x'
   */
  public native function get x():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set x(value:Number):void;
}
}