package ext.chart.sprite {
import ext.draw.sprite.TextSprite;
import ext.mixin.Observable;

[Native("Ext.chart.sprite.Label", require)]
/**
 * Sprite used to represent labels in series.
 * <p>Important: the actual default values are determined by the theme used.
 * Please see the <code>label</code> config of the →<code>ext.chart.theme.ChartTheme.axis</code>.</p>
 * @see ext.chart.theme.ChartTheme#axis
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.Label.html Original Ext JS documentation of 'Ext.chart.sprite.Label'
 */
public class LabelSprite extends TextSprite {
  /**
   * @inheritDoc
   */
  public function LabelSprite(config:LabelSprite = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * True to draw a line between the label and the chart with the default settings,
   * or an Object that defines the 'color', 'width' and 'length' properties of the line.
   * This config is only applicable when the label is displayed outside the chart.
   * <p>Default value: false.</p>
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.Label.html#cfg-calloutLine Original Ext JS documentation of 'calloutLine'
   * @see #getCalloutLine()
   * @see #setCalloutLine()
   */
  public native function get calloutLine():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set calloutLine(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The store record field used by the label sprite.
   * <p>Note: the label sprite is typically used indirectly (by a Ext.chart.MarkerHolder
   * series sprite, via a Ext.chart.Markers sprite, where the latter is passed to the
   * label renderer), so to get to the label field one has to do:</p>
   * <pre>
   * renderer: function (text, sprite, config, data, index) {
   *     var field = sprite.getTemplate().getField();
   * }
   * </pre>
   * <p>To get the actual label sprite instance one can use:</p>
   * <pre>
   * sprite.get(index)
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.Label.html#cfg-field Original Ext JS documentation of 'field'
   * @see #getField()
   * @see #setField()
   */
  public native function get field():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set field(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Animation configuration.
   * @default {
   *     customDurations: {
   *         callout: 200
   *     }
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.Label.html#cfg-fx Original Ext JS documentation of 'fx'
   * @see #getFx()
   * @see #setFx()
   */
  public native function get fx():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set fx(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Hides labels for pie slices with segment length less than this value (in pixels).
   * @default 20
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.sprite.Label.html#cfg-hideLessThan Original Ext JS documentation of 'hideLessThan'
   * @see #getHideLessThan()
   * @see #setHideLessThan()
   */
  public native function get hideLessThan():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set hideLessThan(value:Number):void;

  /**
   * Returns the value of <code>calloutLine</code>.
   * @see #calloutLine
   */
  public native function getCalloutLine():*;

  /**
   * Returns the value of <code>field</code>.
   * @see #field
   */
  public native function getField():String;

  /**
   * Returns the value of <code>fx</code>.
   * @see #fx
   */
  public native function getFx():Object;

  /**
   * Returns the value of <code>hideLessThan</code>.
   * @see #hideLessThan
   */
  public native function getHideLessThan():Number;

  /**
   * Sets the value of <code>calloutLine</code>.
   * @param calloutLine The new value.
   * @see #calloutLine
   */
  public native function setCalloutLine(calloutLine:*):void;

  /**
   * Sets the value of <code>field</code>.
   * @param field The new value.
   * @see #field
   */
  public native function setField(field:String):void;

  /**
   * Sets the value of <code>fx</code>.
   * @param fx The new value.
   * @see #fx
   */
  public native function setFx(fx:Object):void;

  /**
   * Sets the value of <code>hideLessThan</code>.
   * @param hideLessThan The new value.
   * @see #hideLessThan
   */
  public native function setHideLessThan(hideLessThan:Number):void;
}
}