package ext.chart.theme {
import ext.mixin.IFactoryable;

[Native("Ext.chart.theme.Base", require)]
/**
 * Abstract class that provides default styles for non-specified things.
 * Should be sub-classed when creating new themes.
 * For example:
 * <pre>
 * Ext.define('Ext.chart.theme.Custom', {
 *     extend: 'Ext.chart.theme.Base',
 *     singleton: true,
 *     alias: 'chart.theme.custom',
 *     config: {
 *         baseColor: '#ff9f00'
 *     }
 * });
 * </pre>
 * <p>Theme provided values will not override the values provided in an instance config.
 * However, if a theme provided value is an object, it will be merged with the value
 * from the instance config, unless the theme provided object has a '$default' key
 * set to 'true'.</p>
 * <p>Certain chart theme configs (e.g. 'fontSize') may use the 'default' value to indicate
 * that they should inherit a value from the corresponding CSS style provided by
 * a framework theme. Additionally, one can use basic binary operators like multiplication,
 * addition and subtraction to derive from the default value, e.g. fontSize: 'default&#42;1.3'.</p>
 * <p>Important: the theme should not use the 'font' shorthand to specify the font of labels
 * and other text elements of a chart. Instead, individual font properties should be used:
 * 'fontStyle', 'fontVariant', 'fontWeight', 'fontSize' and 'fontFamily'.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.Base.html Original Ext JS documentation of 'Ext.chart.theme.Base'
 */
public class ChartTheme extends BaseChartTheme implements IFactoryable {

  public function ChartTheme(config:ChartTheme = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * Theme defaults for the axes.
   * Can apply to all axes or only axes with a specific position.
   * For example:
   * <pre>
   * axis: {
   *   defaults: {
   *     style: {strokeStyle: 'red'}
   *   },
   *   left: {
   *     title: {fillStyle: 'green'}
   *   }
   * }
   * </pre>
   * <p>The values from the axis.defaults and axis.<i>position</i> configs (where <i>position</i>
   * is a valid axis →<code>ext.chart.axis.Axis.position</code>, e.g. 'bottom') will be
   * applied to corresponding <i>axis</i> (→<code>ext.chart.axis.Axis</code>) configs.
   * E.g., the axis.defaults.label config will apply to the →<code>ext.chart.axis.Axis.label</code>
   * config of all axes, where the axis.left.titleMargin config will only apply to the
   * →<code>ext.chart.axis.Axis.titleMargin</code> config of all axes positioned to the left.</p>
   * @default {
   *     defaults: {
   *         label: {
   *             x: 0,
   *             y: 0,
   *             textBaseline: 'middle',
   *             textAlign: 'center',
   *             fontSize: 'default',
   *             fontFamily: 'default',
   *             fontWeight: 'default',
   *             fillStyle: 'black'
   *         },
   *         title: {
   *             fillStyle: 'black',
   *             fontSize: 'default&#42;1.23',
   *             fontFamily: 'default',
   *             fontWeight: 'default'
   *         },
   *         style: {
   *             strokeStyle: 'black'
   *         },
   *         grid: {
   *             strokeStyle: 'rgb(221, 221, 221)'
   *         }
   *     },
   *     top: {
   *         style: {
   *             textPadding: 5
   *         }
   *     },
   *     bottom: {
   *         style: {
   *             textPadding: 5
   *         }
   *     }
   * }
   * @see ext.chart.axis.Axis#position
   * @see ext.chart.axis.Axis
   * @see ext.chart.axis.Axis#label
   * @see ext.chart.axis.Axis#titleMargin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.Base.html#cfg-axis Original Ext JS documentation of 'axis'
   * @see #getAxis()
   * @see #setAxis()
   */
  public native function get axis():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set axis(value:Object):void;

  [Deprecated(replacement="background", since="5.0.1")]
  [ExtConfig]
  [Bindable]
  /**
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.Base.html#cfg-background Original Ext JS documentation of 'background'
   * @see #getBackground()
   * @see #setBackground()
   */
  public native function get background():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set background(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The base color used to generate the →<code>ext.chart.AbstractChart.colors</code> of the theme.
   * @default null
   * @see ext.chart.AbstractChart#colors
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.Base.html#cfg-baseColor Original Ext JS documentation of 'baseColor'
   * @see #getBaseColor()
   * @see #setBaseColor()
   */
  public native function get baseColor():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set baseColor(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Theme defaults for the chart.
   * Can apply to all charts or just a specific type of chart.
   * For example:
   * <pre>
   * chart: {
   *   defaults: {
   *     background: 'lightgray'
   *   },
   *   polar: {
   *     background: 'green'
   *   }
   * }
   * </pre>
   * <p>The values from the chart.defaults and chart.<i>type</i> configs (where <i>type</i> is a valid
   * chart xtype, e.g. '<i>cartesian</i> (→<code>ext.chart.CartesianChart</code>)' or
   * '<i>polar</i> (→<code>ext.chart.PolarChart</code>)') will be applied to corresponding chart configs.
   * E.g., the chart.defaults.background config will set the
   * →<code>ext.chart.AbstractChart.background</code> config of all charts, where the
   * chart.cartesian.flipXY config will only set the
   * →<code>ext.chart.CartesianChart.flipXY</code> config of all cartesian charts.</p>
   * @default {
   *     defaults: {
   *         captions: {
   *             title: {
   *                 docked: 'top',
   *                 padding: 5,
   *                 style: {
   *                     textAlign: 'center',
   *                     fontFamily: 'default',
   *                     fontWeight: '500',
   *                     fillStyle: 'black',
   *                     fontSize: 'default&#42;1.6'
   *                 }
   *             },
   *             subtitle: {
   *                 docked: 'top',
   *                 style: {
   *                     textAlign: 'center',
   *                     fontFamily: 'default',
   *                     fontWeight: 'normal',
   *                     fillStyle: 'black',
   *                     fontSize: 'default&#42;1.3'
   *                 }
   *             },
   *             credits: {
   *                 docked: 'bottom',
   *                 padding: 5,
   *                 style: {
   *                     textAlign: 'left',
   *                     fontFamily: 'default',
   *                     fontWeight: 'lighter',
   *                     fillStyle: 'black',
   *                     fontSize: 'default'
   *                 }
   *             }
   *         },
   *         background: 'white'
   *     }
   * }
   * @see ext.chart.CartesianChart
   * @see ext.chart.PolarChart
   * @see ext.chart.AbstractChart#background
   * @see ext.chart.CartesianChart#flipXY
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.Base.html#cfg-chart Original Ext JS documentation of 'chart'
   * @see #getChart()
   * @see #setChart()
   */
  public native function get chart():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set chart(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Array of colors/gradients to be used by the theme.
   * Defaults to →<code>colorDefaults</code>.
   * @default undefined
   * @see #colorDefaults
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.Base.html#cfg-colors Original Ext JS documentation of 'colors'
   * @see #getColors()
   * @see #setColors()
   */
  public native function get colors():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set colors(value:Array):void;

  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The gradient config to be used by series' sprites. E.g.:
   * <pre>
   * {
   *   type: 'linear',
   *   degrees: 90
   * }
   * </pre>
   * <p>Please refer to the documentation for the <i>linear</i> (→<code>ext.draw.gradient.LinearGradient</code>)
   * and <i>radial</i> (→<code>ext.draw.gradient.RadialGradient</code>) gradients for all possible options.
   * The color →<code>ext.draw.gradient.Gradient.stops</code> for the gradients
   * will be generated by the theme based on the →<code>colors</code> config.</p>
   * @see ext.draw.gradient.LinearGradient
   * @see ext.draw.gradient.RadialGradient
   * @see ext.draw.gradient.Gradient#stops
   * @see #colors
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.Base.html#cfg-gradients Original Ext JS documentation of 'gradients'
   * @see #getGradients()
   * @see #setGradients()
   */
  public native function get gradients():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set gradients(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Style information for the {Ext.chart.legend.SpriteLegend sprite legend}.
   * If the <i>DOM</i> (→<code>ext.chart.legend.Legend</code>) legend is used, this config is ignored.
   * For additional details see →<code>ext.chart.AbstractChart.legend</code>.
   * @default {
   *     label: {
   *         fontSize: 14,
   *         fontWeight: 'default',
   *         fontFamily: 'default',
   *         fillStyle: 'black'
   *     },
   *     border: {
   *         lineWidth: 1,
   *         radius: 4,
   *         fillStyle: 'none',
   *         strokeStyle: 'gray'
   *     },
   *     background: 'white'
   * }
   * <ul>
   * <li><code>item:ext.draw.sprite.CompositeSprite</code> (optional)</li>
   * <li><code>border:Object</code> (optional) —
   * See →<code>ext.chart.legend.SpriteLegend.border</code>.
   * </li>
   * </ul>
   * @see ext.chart.legend.Legend
   * @see ext.chart.AbstractChart#legend
   * @see ext.chart.legend.SpriteLegend#border
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.Base.html#cfg-legend Original Ext JS documentation of 'legend'
   * @see #getLegend()
   * @see #setLegend()
   */
  public native function get legend():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set legend(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Theme defaults for the series.
   * Can apply to all series or just a specific type of series.
   * For example:
   * <pre>
   * series: {
   *   defaults: {
   *     style: {
   *       lineWidth: 2
   *     }
   *   },
   *   bar: {
   *     animation: {
   *       easing: 'bounceOut',
   *       duration: 1000
   *     }
   *   }
   * }
   * </pre>
   * <p>The values from the series.defaults and series.<i>type</i> configs (where <i>type</i>
   * is a valid series →<code>ext.chart.series.Series.type</code>, e.g. 'line') will be
   * applied to corresponding series configs.
   * E.g., the series.defaults.label config will apply to the
   * →<code>ext.chart.series.Series.label</code> config of all series, where the series.line.step
   * config will only apply to the
   * →<code>ext.chart.series.LineSeries.step</code> config of <i>line</i> (→<code>ext.chart.series.LineSeries</code>) series.</p>
   * @default {
   *     defaults: {
   *         label: {
   *             fillStyle: 'black',
   *             strokeStyle: 'none',
   *             fontFamily: 'default',
   *             fontWeight: 'default',
   *             fontSize: 'default&#42;1.077',
   *             textBaseline: 'middle',
   *             textAlign: 'center'
   *         },
   *         labelOverflowPadding: 5
   *     }
   * }
   * @see ext.chart.series.Series#type
   * @see ext.chart.series.Series#label
   * @see ext.chart.series.LineSeries#step
   * @see ext.chart.series.LineSeries
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.Base.html#cfg-series Original Ext JS documentation of 'series'
   * @see #getSeries()
   * @see #setSeries()
   */
  public native function get series():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set series(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Default style for the custom chart sprites by type.
   * For example:
   * <pre>
   * sprites: {
   *   text: {
   *     fontWeight: 300
   *   }
   * }
   * </pre>
   * <p>These sprite attribute overrides will apply to custom sprites of all charts
   * specified using the →<code>ext.draw.DrawContainer.sprites</code> config.
   * The overrides are specified by sprite type, e.g. sprites.text config
   * tells to apply given attributes to all <i>text</i> (→<code>ext.draw.sprite.TextSprite</code>) sprites.</p>
   * @default {
   *     text: {
   *         fontSize: 'default',
   *         fontWeight: 'default',
   *         fontFamily: 'default',
   *         fillStyle: 'black'
   *     }
   * }
   * @see ext.draw.DrawContainer#sprites
   * @see ext.draw.sprite.TextSprite
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.Base.html#cfg-sprites Original Ext JS documentation of 'sprites'
   * @see #getSprites()
   * @see #setSprites()
   */
  public native function get sprites():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set sprites(value:Object):void;

  [Deprecated(replacement="gradients", since="5.0.1")]
  [ExtConfig]
  [Bindable]
  /**
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.Base.html#cfg-useGradients Original Ext JS documentation of 'useGradients'
   * @see #getUseGradients()
   * @see #setUseGradients()
   */
  public native function get useGradients():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set useGradients(value:*):void;

  /**
   * Returns the value of <code>axis</code>.
   * @see #axis
   */
  public native function getAxis():Object;

  [Deprecated(replacement="background", since="5.0.1")]
  /**
   * Returns the value of <code>background</code>.
   * @see #background
   */
  public native function getBackground():*;

  /**
   * Returns the value of <code>baseColor</code>.
   * @see #baseColor
   */
  public native function getBaseColor():*;

  /**
   * Returns the value of <code>chart</code>.
   * @see #chart
   */
  public native function getChart():Object;

  /**
   * Returns the value of <code>colors</code>.
   * @see #colors
   */
  public native function getColors():Array;

  /**
   * Returns the value of <code>gradients</code>.
   * @see #gradients
   */
  public native function getGradients():Object;

  /**
   * Returns the value of <code>legend</code>.
   * @see #legend
   */
  public native function getLegend():Object;

  /**
   * Returns the value of <code>series</code>.
   * @see #series
   */
  public native function getSeries():Object;

  /**
   * Returns the value of <code>sprites</code>.
   * @see #sprites
   */
  public native function getSprites():Object;

  [Deprecated(replacement="gradients", since="5.0.1")]
  /**
   * Returns the value of <code>useGradients</code>.
   * @see #useGradients
   */
  public native function getUseGradients():*;

  /**
   * Sets the value of <code>axis</code>.
   * @param axis The new value.
   * @see #axis
   */
  public native function setAxis(axis:Object):void;

  [Deprecated(replacement="background", since="5.0.1")]
  /**
   * Sets the value of <code>background</code>.
   * @param background The new value.
   * @see #background
   */
  public native function setBackground(background:*):void;

  /**
   * Sets the value of <code>baseColor</code>.
   * @param baseColor The new value.
   * @see #baseColor
   */
  public native function setBaseColor(baseColor:*):void;

  /**
   * Sets the value of <code>chart</code>.
   * @param chart The new value.
   * @see #chart
   */
  public native function setChart(chart:Object):void;

  /**
   * Sets the value of <code>colors</code>.
   * @param colors The new value.
   * @see #colors
   */
  public native function setColors(colors:Array):void;

  /**
   * Sets the value of <code>gradients</code>.
   * @param gradients The new value.
   * @see #gradients
   */
  public native function setGradients(gradients:Object):void;

  /**
   * Sets the value of <code>legend</code>.
   * @param legend The new value.
   * @see #legend
   */
  public native function setLegend(legend:Object):void;

  /**
   * Sets the value of <code>series</code>.
   * @param series The new value.
   * @see #series
   */
  public native function setSeries(series:Object):void;

  /**
   * Sets the value of <code>sprites</code>.
   * @param sprites The new value.
   * @see #sprites
   */
  public native function setSprites(sprites:Object):void;

  [Deprecated(replacement="gradients", since="5.0.1")]
  /**
   * Sets the value of <code>useGradients</code>.
   * @param useGradients The new value.
   * @see #useGradients
   */
  public native function setUseGradients(useGradients:*):void;
}
}