package ext.chart.theme.series {

[Native("Ext.chart.theme.series.Area", require)]
/**
 * Describes style for an area series.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Area.html Original Ext JS documentation of 'Ext.chart.theme.series.Area'
 */
public class AreaSeriesTheme extends SeriesTheme {
  [ExtConfig]
  /**
   * 'true' if the area is represented with steps
   * instead of lines.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Area.html#cfg-step Original Ext JS documentation of 'step'
   */
  public native function get step():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set step(value:Boolean):void;
}
}