package ext.chart.theme.series {

[Native("Ext.chart.theme.series.Bar3D", require)]
/**
 * Describes style for a bar3d series.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Bar3D.html Original Ext JS documentation of 'Ext.chart.theme.series.Bar3D'
 */
public class Bar3DSeriesTheme extends SeriesTheme {
  [ExtConfig]
  /**
   * The factor applied to the brightness of the bars.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Bar3D.html#cfg-brightnessFactor Original Ext JS documentation of 'brightnessFactor'
   */
  public native function get brightnessFactor():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set brightnessFactor(value:Number):void;

  [ExtConfig]
  /**
   * An attribute used to control how flat the bar gradient looks.
   * A value of 0 essentially means no gradient (flat color).
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Bar3D.html#cfg-colorSpread Original Ext JS documentation of 'colorSpread'
   */
  public native function get colorSpread():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set colorSpread(value:Number):void;

  [ExtConfig]
  /**
   * The factor applied to the saturation of the bars.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Bar3D.html#cfg-saturationFactor Original Ext JS documentation of 'saturationFactor'
   */
  public native function get saturationFactor():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set saturationFactor(value:Number):void;
}
}