package ext.chart.theme.series {

[Native("Ext.chart.theme.series.BoxPlot", require)]
/**
 * Describes style for a boxplot series.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.BoxPlot.html Original Ext JS documentation of 'Ext.chart.theme.series.BoxPlot'
 */
public class BoxPlotSeriesTheme extends SeriesTheme {
  [ExtConfig]
  /**
   * The maximum box width.
   * @default 20
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.BoxPlot.html#cfg-maxBoxWidth Original Ext JS documentation of 'maxBoxWidth'
   */
  public native function get maxBoxWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maxBoxWidth(value:Number):void;

  [ExtConfig]
  /**
   * The minimum box width.
   * @default 2
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.BoxPlot.html#cfg-minBoxWidth Original Ext JS documentation of 'minBoxWidth'
   */
  public native function get minBoxWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set minBoxWidth(value:Number):void;

  [ExtConfig]
  /**
   * The minimum gap between boxes.
   * @default 5
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.BoxPlot.html#cfg-minGapWidth Original Ext JS documentation of 'minGapWidth'
   */
  public native function get minGapWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set minGapWidth(value:Number):void;
}
}