package ext.chart.theme.series {

[Native("Ext.chart.theme.series.Line", require)]
/**
 * Describes style for a line series.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Line.html Original Ext JS documentation of 'Ext.chart.theme.series.Line'
 */
public class LineSeriesTheme extends SeriesTheme {
  [ExtConfig]
  /**
   * The type of curve that connects the data points.
   * <p>For example:</p>
   * <pre>
   * // The data points are connected by line segments.
   * // This is the default setting.
   * curve: {
   *     type: 'linear'
   * }
   *
   * // Cardinal spline interpolation is used to produce the curve
   * // that connects the data points. The `tension` parameter can
   * // be used to control the smoothness of the curve. A tension
   * // of 0 corresponds to infinite tension, which results in straight
   * // lines between data points. A tension of 1 corresponds to
   * // no tension, allowing the spline to take the path of least
   * // total bend. With tension values greater than 1, the curve
   * // behaves like a compressed spring, pushed to take a longer path.
   * // A cardinal spline with a tension of 0.5 is a special case.
   * // It is then called a Catmull-Rom spline. Catmull-Rom splines are
   * // thought to be esthetically pleasing and are quite common.
   * // Note: spline interpolation only works on gapless data.
   * curve: {
   *     type: 'cardinal,
   *     tension: 0.5
   * }
   *
   * // Produces a natural cubic spline with the second derivative
   * // of the spline set to zero at the endpoints.
   * curve: {
   *     type: 'natural'
   * }
   *
   * // The data points are connected by alternating horizontal and
   * // vertical lines. The y-value changes after the x-value.
   * curve: {
   *     type: 'step-after'
   * }
   * </pre>
   * @default {type: 'linear'}
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Line.html#cfg-curve Original Ext JS documentation of 'curve'
   */
  public native function get curve():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set curve(value:Object):void;

  [ExtConfig]
  /**
   * <code>true</code> if the sprite paints the area underneath the line.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Line.html#cfg-fillArea Original Ext JS documentation of 'fillArea'
   */
  public native function get fillArea():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fillArea(value:Boolean):void;

  [ExtConfig]
  /**
   * Possible values:
   * 'gap' - null points are rendered as gaps.
   * 'connect' - non-null points are connected across null points, so that
   * there is no gap, unless null points are at the beginning/end of the line.
   * Only the visible data points are connected - if a visible data point
   * is followed by a series of null points that go off screen and eventually
   * terminate with a non-null point, the connection won't be made.
   * 'origin' - null data points are rendered at the origin,
   * which is the y-coordinate of a point where the x and y axes meet.
   * This requires that at least the x-coordinate of a point is a valid value.
   * @default "gap"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Line.html#cfg-nullStyle Original Ext JS documentation of 'nullStyle'
   */
  public native function get nullStyle():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set nullStyle(value:String):void;
}
}