package ext.chart.theme.series {

[Native("Ext.chart.theme.series.Pie3D", require)]
/**
 * Describes style for a pie3d series.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Pie3D.html Original Ext JS documentation of 'Ext.chart.theme.series.Pie3D'
 */
public class Pie3DSeriesTheme extends SeriesTheme {
  [ExtConfig]
  /**
   * The color of the 3D pie part before adding the 3D effect.
   * @default 'white'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Pie3D.html#cfg-baseColor Original Ext JS documentation of 'baseColor'
   */
  public native function get baseColor():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set baseColor(value:Object):void;

  [ExtConfig]
  /**
   * The size of the 3D pie bevel.
   * @default 5
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Pie3D.html#cfg-bevelWidth Original Ext JS documentation of 'bevelWidth'
   */
  public native function get bevelWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set bevelWidth(value:Number):void;

  [ExtConfig]
  /**
   * An attribute used to control how flat the gradient of the sprite looks.
   * A value of 0 essentially means no gradient (flat color).
   * @default 0.7
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Pie3D.html#cfg-colorSpread Original Ext JS documentation of 'colorSpread'
   */
  public native function get colorSpread():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set colorSpread(value:Number):void;

  [ExtConfig]
  /**
   * The distortion of the 3D pie part.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Pie3D.html#cfg-distortion Original Ext JS documentation of 'distortion'
   */
  public native function get distortion():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set distortion(value:Number):void;

  [ExtConfig]
  /**
   * Margin from the center of the pie. Used for donut.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Pie3D.html#cfg-margin Original Ext JS documentation of 'margin'
   */
  public native function get margin():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set margin(value:Number):void;

  [ExtConfig]
  /**
   * The thickness of the 3D pie part.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Pie3D.html#cfg-thickness Original Ext JS documentation of 'thickness'
   */
  public native function get thickness():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set thickness(value:Number):void;
}
}