package ext.chart.theme.series {

[Native("Ext.chart.theme.series.Pie", require)]
/**
 * Describes style for a pie series.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Pie.html Original Ext JS documentation of 'Ext.chart.theme.series.Pie'
 */
public class PieSeriesTheme extends SeriesTheme {
  [ExtConfig]
  /**
   * Padding around labels to determine overlap.
   * Any negative number allows the labels to overlap.
   * @default 10
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Pie.html#cfg-labelOverflowPadding Original Ext JS documentation of 'labelOverflowPadding'
   */
  override public native function get labelOverflowPadding():Number;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set labelOverflowPadding(value:Number):void;
}
}