package ext.chart.theme.series {
import ext.Base;

[Native("Ext.chart.theme.series.Series", require)]
[ExtConfig]
/**
 * Describes style for a series.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Series.html Original Ext JS documentation of 'Ext.chart.theme.series.Series'
 */
public class SeriesTheme extends Base {
  [ExtConfig]
  /**
   * The opacity of the fill. Limited from 0 to 1.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Series.html#cfg-fillOpacity Original Ext JS documentation of 'fillOpacity'
   */
  public native function get fillOpacity():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fillOpacity(value:Number):void;

  [ExtConfig]
  /**
   * The color of the shape (a CSS color value).
   * @default "none"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Series.html#cfg-fillStyle Original Ext JS documentation of 'fillStyle'
   */
  public native function get fillStyle():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fillStyle(value:String):void;

  [ExtConfig]
  /**
   * The opacity of the sprite. Limited from 0 to 1.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Series.html#cfg-globalAlpha Original Ext JS documentation of 'globalAlpha'
   */
  public native function get globalAlpha():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set globalAlpha(value:Number):void;

  [ExtConfig]
  /**
   * Padding around labels to determine
   * overlap.
   * @default 10
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Series.html#cfg-labelOverflowPadding Original Ext JS documentation of 'labelOverflowPadding'
   */
  public native function get labelOverflowPadding():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelOverflowPadding(value:Number):void;

  [ExtConfig]
  /**
   * The style of the line caps.
   * @default "butt"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Series.html#cfg-lineCap Original Ext JS documentation of 'lineCap'
   */
  public native function get lineCap():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lineCap(value:String):void;

  [ExtConfig]
  /**
   * An even number of non-negative numbers specifying a dash/space sequence.
   * Note that while this is supported in IE8 (VML engine), the behavior is
   * different from Canvas and SVG. Please refer to this document for details:
   * http://msdn.microsoft.com/en-us/library/bb264085(v=vs.85).aspx
   * Although IE9 and IE10 have Canvas support, the 'lineDash'
   * attribute is not supported in those browsers.
   * @default []
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Series.html#cfg-lineDash Original Ext JS documentation of 'lineDash'
   */
  public native function get lineDash():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lineDash(value:Array):void;

  [ExtConfig]
  /**
   * A number specifying how far into the line dash sequence drawing commences.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Series.html#cfg-lineDashOffset Original Ext JS documentation of 'lineDashOffset'
   */
  public native function get lineDashOffset():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lineDashOffset(value:Number):void;

  [ExtConfig]
  /**
   * The style of the line join.
   * @default "miter"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Series.html#cfg-lineJoin Original Ext JS documentation of 'lineJoin'
   */
  public native function get lineJoin():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lineJoin(value:String):void;

  [ExtConfig]
  /**
   * The width of the line stroke.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Series.html#cfg-lineWidth Original Ext JS documentation of 'lineWidth'
   */
  public native function get lineWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lineWidth(value:Number):void;

  [ExtConfig]
  /**
   * Sets the distance between the inner corner and the outer corner
   * where two lines meet.
   * @default 10
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Series.html#cfg-miterLimit Original Ext JS documentation of 'miterLimit'
   */
  public native function get miterLimit():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set miterLimit(value:Number):void;

  [ExtConfig]
  /**
   * The amount blur used on the shadow.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Series.html#cfg-shadowBlur Original Ext JS documentation of 'shadowBlur'
   */
  public native function get shadowBlur():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set shadowBlur(value:Number):void;

  [ExtConfig]
  /**
   * The color of the shadow (a CSS color value).
   * @default "none"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Series.html#cfg-shadowColor Original Ext JS documentation of 'shadowColor'
   */
  public native function get shadowColor():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set shadowColor(value:String):void;

  [ExtConfig]
  /**
   * The offset of the sprite's shadow on the x-axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Series.html#cfg-shadowOffsetX Original Ext JS documentation of 'shadowOffsetX'
   */
  public native function get shadowOffsetX():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set shadowOffsetX(value:Number):void;

  [ExtConfig]
  /**
   * The opacity of the stroke. Limited from 0 to 1.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Series.html#cfg-strokeOpacity Original Ext JS documentation of 'strokeOpacity'
   */
  public native function get strokeOpacity():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set strokeOpacity(value:Number):void;

  [ExtConfig]
  /**
   * The color of the stroke (a CSS color value).
   * @default "none"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.theme.series.Series.html#cfg-strokeStyle Original Ext JS documentation of 'strokeStyle'
   */
  public native function get strokeStyle():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set strokeStyle(value:String):void;
}
}