package ext.container {
import ext.panel.Panel;

[Native("Ext.container.ButtonGroup", require)]
/**
 * Provides a container for arranging a group of related Buttons in a tabular manner.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.panel.Panel', {
 *     title: 'Panel with ButtonGroup',
 *     width: 300,
 *     height:200,
 *     renderTo: document.body,
 *     bodyPadding: 10,
 *     html: 'HTML Panel Content',
 *     tbar: [{
 *         xtype: 'buttongroup',
 *         columns: 3,
 *         title: 'Clipboard',
 *         items: [{
 *             text: 'Paste',
 *             scale: 'large',
 *             rowspan: 3,
 *             iconCls: 'add',
 *             iconAlign: 'top',
 *             cls: 'btn-as-arrow'
 *         },{
 *             xtype:'splitbutton',
 *             text: 'Menu Button',
 *             scale: 'large',
 *             rowspan: 3,
 *             iconCls: 'add',
 *             iconAlign: 'top',
 *             arrowAlign:'bottom',
 *             menu: [{ text: 'Menu Item 1' }]
 *         },{
 *             xtype:'splitbutton', text: 'Cut', iconCls: 'add16',
 *             menu: [{ text: 'Cut Menu Item' }]
 *         },{
 *             text: 'Copy', iconCls: 'add16'
 *         },{
 *             text: 'Format', iconCls: 'add16'
 *         }]
 *     }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.ButtonGroup.html Original Ext JS documentation of 'Ext.container.ButtonGroup'
 */
public class ButtonGroup extends Panel {
  /**
   * @param config @inheritDoc
   */
  public function ButtonGroup(config:ButtonGroup = null) {
    super();
  }

  [ExtConfig]
  /**
   * The base CSS class to apply to this component's element. This will also be prepended
   * to elements within this component like Panel's body will get a class <code>x-panel-body</code>.
   * This means that if you create a subclass of Panel, and you want it to get all the Panels
   * styling for the element and the body, you leave the <code>→baseCls</code> <code>x-panel</code> and use
   * <code>→componentCls</code> to add specific styling for this component.
   * @default Ext.baseCSSPrefix + 'btn-group'
   * @see #baseCls
   * @see #componentCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.ButtonGroup.html#cfg-baseCls Original Ext JS documentation of 'baseCls'
   */
  override public native function get baseCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set baseCls(value:String):void;

  [ExtConfig]
  /**
   * The <code>→columns</code> configuration property passed to the <i>configured layout manager</i> (→<code>layout</code>).
   * See →<code>ext.layout.container.TableLayout.columns</code>.
   * @see #columns
   * @see #layout
   * @see ext.layout.container.TableLayout#columns
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.ButtonGroup.html#cfg-columns Original Ext JS documentation of 'columns'
   */
  public native function get columns():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set columns(value:Number):void;

  [ExtConfig]
  /**
   * A default →<code>ext.Component.ui</code> to use for →<code>ext.button.Button</code> items
   * @see ext.Component#ui
   * @see ext.button.Button
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.ButtonGroup.html#cfg-defaultButtonUI Original Ext JS documentation of 'defaultButtonUI'
   */
  public native function get defaultButtonUI():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultButtonUI(value:String):void;

  [ExtConfig]
  /**
   * The default <i>xtype</i> (→<code>ext.Component</code>) of child Components to create in this Container when
   * a child item is specified as a raw configuration object, rather than as an instantiated
   * Component.
   * @default 'button'
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.ButtonGroup.html#cfg-defaultType Original Ext JS documentation of 'defaultType'
   */
  override public native function get defaultType():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set defaultType(value:String):void;

  [ExtConfig]
  /**
   * Enable or disable navigation
   * with arrow keys for this FocusableContainer. This option may be useful
   * with nested FocusableContainers, when only the root container should
   * handle keyboard events.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.ButtonGroup.html#cfg-focusableContainer Original Ext JS documentation of 'focusableContainer'
   */
  override public native function get focusableContainer():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set focusableContainer(value:Boolean):void;

  /**
   * The name of the element
   * that FocusableContainer should bind its keyboard handler to. Similar to →<code>ariaEl</code>,
   * this name is resolved to the →<code>ext.dom.Element</code> instance after rendering.
   * @default 'body'
   * @see #ariaEl
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.ButtonGroup.html#property-focusableContainerEl Original Ext JS documentation of 'focusableContainerEl'
   */
  override public native function get focusableContainerEl():*;

  /**
   * @private
   */
  override public native function set focusableContainerEl(value:*):void;

  [ExtConfig]
  /**
   * True to apply a frame to the panel.
   * <p><b>Note:</b> <code>frame: true</code> overrides <i>border:false</i> (→<code>border</code>)</p>
   * @default true
   * @see #border
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.ButtonGroup.html#cfg-frame Original Ext JS documentation of 'frame'
   */
  override public native function get frame():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set frame(value:Boolean):void;

  [ExtConfig]
  /**
   * True to apply a frame to the panel panels header (if 'frame' is true).
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.ButtonGroup.html#cfg-frameHeader Original Ext JS documentation of 'frameHeader'
   */
  override public native function get frameHeader():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set frameHeader(value:Boolean):void;

  [ExtConfig]
  /**
   * <b>Important</b>: In order for child items to be correctly sized and
   * positioned, typically a layout manager <b>must</b> be specified through
   * the <code>→layout</code> configuration option.
   * <p>The sizing and positioning of child →<code>items</code> is the responsibility of
   * the Container's layout manager which creates and manages the type of layout
   * you have in mind. For example:</p>
   * <p>If the layout configuration is not explicitly specified for
   * a general purpose container (e.g. Container or Panel) the
   * <i>default layout manager</i> (→<code>ext.layout.container.AutoLayout</code>) will be used
   * which does nothing but render child components sequentially into the
   * Container (no sizing or positioning will be performed in this situation).</p>
   * <p><b>layout</b> may be specified as either as an Object or as a String:</p>
   * <p><b><i>Specify as an Object</i></b></p>
   * <p>Example usage:</p>
   * <pre>
   * layout: {
   *     type: 'vbox',
   *     align: 'left'
   * }
   * </pre>
   * <ul>
   * <li>
   * <p><b>type</b></p>
   * <p>The layout type to be used for this container. If not specified,
   * a default →<code>ext.layout.container.AutoLayout</code> will be created and used.</p>
   * <p>Valid layout <code>type</code> values are listed in →<code>null</code>.</p>
   * </li>
   * <li>
   * <p>Layout specific configuration properties</p>
   * <p>Additional layout specific configuration properties may also be
   * specified. For complete details regarding the valid config options for
   * each layout type, see the layout class corresponding to the <code>type</code>
   * specified.</p>
   * </li>
   * </ul>
   * <p><b><i>Specify as a String</i></b></p>
   * <p>Example usage:</p>
   * <pre>
   * layout: 'vbox'
   * </pre>
   * <ul>
   * <li>
   * <p><b>layout</b></p>
   * <p>The layout <code>type</code> to be used for this container (see →<code>null</code>
   * for list of valid values).</p>
   * <p>Additional layout specific configuration properties. For complete
   * details regarding the valid config options for each layout type, see the
   * layout class corresponding to the <code>→layout</code> specified.</p>
   * </li>
   * </ul>
   * <p><b><i>Configuring the default layout type</i></b></p>
   * <p>If a certain Container class has a default layout (For example a
   * →<code>ext.toolbar.Toolbar</code> with a default <code>Box</code> layout), then to simply configure
   * the default layout, use an object, but without the <code>type</code> property:</p>
   * <pre>
   * xtype: 'toolbar',
   * layout: {
   *     pack: 'center'
   * }
   * </pre>
   * @default {
   *     type: 'table'
   * }
   * @see #layout
   * @see #items
   * @see ext.layout.container.AutoLayout
   * @see null
   * @see ext.toolbar.Toolbar
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.ButtonGroup.html#cfg-layout Original Ext JS documentation of 'layout'
   * @see #setLayout()
   */
  override public native function get layout():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set layout(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The alignment of the title text within the available space between the icon and the tools.
   * @default 'center'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.ButtonGroup.html#cfg-titleAlign Original Ext JS documentation of 'titleAlign'
   * @see #getTitleAlign()
   * @see #setTitleAlign()
   */
  override public native function get titleAlign():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set titleAlign(value:String):void;

  /**
   * Returns the value of <code>titleAlign</code>.
   * @see #titleAlign
   */
  override public native function getTitleAlign():String;

  /**
   * Sets the value of <code>titleAlign</code>.
   * @param titleAlign The new value.
   * @see #titleAlign
   */
  override public native function setTitleAlign(titleAlign:String):void;
}
}