package ext.container {
import ext.Action;
import ext.Component;
import ext.dom.Element;
import ext.layout.container.ContainerLayout;
import ext.mixin.IAdvancedFocusableContainerMixin;
import ext.mixin.IContainer;
import ext.mixin.IFocusableContainer;
import ext.mixin.IQueryable;
import ext.util.MixedCollection;

[Native("Ext.container.Container", require)]
/**
 * @see ext.container.events.Container_component_indexEvent.ADD
 * @eventType ext.container.events.Container_component_indexEvent.ADD
 */
[Event(name='onAdd', type='ext.container.events.Container_component_indexEvent')]
/**
 * @see ext.container.events.Container_layoutEvent.AFTER_LAYOUT
 * @eventType ext.container.events.Container_layoutEvent.AFTER_LAYOUT
 */
[Event(name='onAfterLayout', type='ext.container.events.Container_layoutEvent')]
/**
 * @see ext.container.events.Container_component_indexEvent.BEFORE_ADD
 * @eventType ext.container.events.Container_component_indexEvent.BEFORE_ADD
 */
[Event(name='onBeforeAdd', type='ext.container.events.Container_component_indexEvent')]
/**
 * @see ext.container.events.Container_componentEvent.BEFORE_REMOVE
 * @eventType ext.container.events.Container_componentEvent.BEFORE_REMOVE
 */
[Event(name='onBeforeRemove', type='ext.container.events.Container_componentEvent')]
/**
 * @see ext.container.events.Container_component_prevIndex_newIndexEvent.CHILD_MOVE
 * @eventType ext.container.events.Container_component_prevIndex_newIndexEvent.CHILD_MOVE
 */
[Event(name='onChildMove', type='ext.container.events.Container_component_prevIndex_newIndexEvent')]
/**
 * @see ext.container.events.Container_componentEvent.REMOVE
 * @eventType ext.container.events.Container_componentEvent.REMOVE
 */
[Event(name='onRemove', type='ext.container.events.Container_componentEvent')]
/**
 * Base class for any Ext.Component that may contain other Components. Containers handle the basic
 * behavior of containing items, namely adding, inserting and removing items.
 * <p>The most commonly used Container classes are Ext.panel.Panel, Ext.window.Window and
 * Ext.tab.Panel. If you do not need the capabilities offered by the aforementioned classes you can
 * create a lightweight Container to be encapsulated by an HTML element to your specifications
 * by using the →<code>ext.Component.autoEl</code> config option.</p>
 * <p>The code below illustrates how to explicitly create a Container:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * // Explicitly create a Container
 * Ext.create('Ext.container.Container', {
 *     layout: {
 *         type: 'hbox'
 *     },
 *     width: 400,
 *     renderTo: Ext.getBody(),
 *     border: 1,
 *     style: {borderColor:'#000000', borderStyle:'solid', borderWidth:'1px'},
 *     defaults: {
 *         labelWidth: 80,
 *         // implicitly create Container by specifying xtype
 *         xtype: 'datefield',
 *         flex: 1,
 *         style: {
 *             padding: '10px'
 *         }
 *     },
 *     items: [{
 *         xtype: 'datefield',
 *         name: 'startDate',
 *         fieldLabel: 'Start date'
 *     },{
 *         xtype: 'datefield',
 *         name: 'endDate',
 *         fieldLabel: 'End date'
 *     }]
 * });
 * </pre>
 * <p><b><i>Layout</i></b></p>
 * <p>Container classes delegate the rendering of child Components to a layout manager class which must
 * be configured into the Container using the <code>→layout</code> configuration property.</p>
 * <p>When either specifying child <code>→items</code> of a Container, or dynamically
 * <i>adding</i> (→<code>add()</code>) Components to a Container, remember to consider how you wish
 * the Container to arrange those child elements, and whether those child elements need to be sized
 * using one of Ext's built-in <code>→layout</code> schemes. By default, Containers use the
 * →<code>ext.layout.container.AutoLayout</code> scheme which only renders child components, appending them
 * one after the other inside the Container, and <b>does not apply any sizing</b> at all.</p>
 * <p>A common mistake is when a developer neglects to specify a <code>→layout</code> (e.g. GridPanels or
 * TreePanels are added to Containers for which no <code>→layout</code> has been specified).
 * If a Container is left to use the default →<code>ext.layout.container.AutoLayout</code> scheme,
 * none of its child components will be resized, or changed in any way when the Container
 * is resized.</p>
 * <p>Certain layout managers allow dynamic addition of child components. Those that do include
 * Ext.layout.container.Card, Ext.layout.container.Anchor, Ext.layout.container.VBox,
 * Ext.layout.container.HBox, and Ext.layout.container.Table. For example:</p>
 * <pre>
 * //  Create the GridPanel.
 * var myNewGrid = Ext.create('Ext.grid.Panel', {
 *     store: myStore,
 *     headers: myHeaders,
 *     title: 'Results', // the title becomes the title of the tab
 * });
 *
 * myTabPanel.add(myNewGrid); // Ext.tab.Panel implicitly uses Ext.layout.container.Card
 * myTabPanel.setActiveTab(myNewGrid);
 * </pre>
 * <p>The example above adds a newly created GridPanel to a TabPanel. Note that a TabPanel uses
 * →<code>ext.layout.container.CardLayout</code> as its layout manager which means all its child items are sized
 * to <i>fit</i> (→<code>ext.layout.container.FitLayout</code>) exactly into its client area.</p>
 * <p><b><i>Overnesting is a common problem</i></b>. An example of overnesting occurs when a GridPanel is added
 * to a TabPanel by wrapping the GridPanel <i>inside</i> a wrapping Panel (that has no <code>→layout</code>
 * specified) and then add that wrapping Panel to the TabPanel. The point to realize is that
 * a GridPanel <b>is</b> a Component which can be added directly to a Container. If the wrapping Panel
 * has no <code>→layout</code> configuration, then the overnested GridPanel will not be sized
 * as expected.</p>
 * <p><b><i>References (→<code>ext.Component.reference</code>) and Reference Holders (→<code>referenceHolder</code>)</i></b></p>
 * <p>Reference holders are used to keep references to child components inside a hierarchy.</p>
 * <p>This functionality allows the connection of encapsulated references between containers
 * and their child components declaratively. Simple usage:</p>
 * <pre>
 * Ext.define('Login', {
 *     extend: 'Ext.window.Window',
 *
 *     // This config is not compatible with the more common "controller" config
 *     // used to specify a ViewController for the view. When a ViewController is
 *     // specified it effectively acts as the "reference holder" for the view. In
 *     // this example we simply mark this container as the reference holder for
 *     // demonstration purposes.
 *     referenceHolder: true,
 *
 *     title: 'Login',
 *     items: [{
 *         xtype: 'form',
 *         items: [{
 *             xtype: 'textfield',
 *             reference: 'username', // A named reference to be held on the referenceHolder
 *             name: 'username',
 *             fieldLabel: 'Username'
 *         }, {
 *             xtype: 'textfield',
 *             reference: 'password', // A named reference to be held on the referenceHolder
 *             name: 'password',
 *             fieldLabel: 'Password'
 *         }]
 *     }]
 * });
 * var w = new Login();
 * console.log(w.lookupReference('password')); // The password field
 * </pre>
 * <p>Reference holders are also encapsulated, so a reference will only be put on the closest
 * reference holder above it in the component hierarchy:</p>
 * <pre>
 * var ct = new Ext.container.Container({
 *     referenceHolder: true,
 *     items: [{
 *         xtype: 'container',
 *         referenceHolder: true,
 *         reference: 'innerCt1',
 *         items: [{
 *             xtype: 'component',
 *             reference: 'a',
 *             id: 'a1'
 *         }, {
 *             xtype: 'component',
 *             reference: 'b',
 *             id: 'b1'
 *         }]
 *     }, {
 *         xtype: 'container',
 *         referenceHolder: true,
 *         reference: 'innerCt2',
 *         items: [{
 *             xtype: 'component',
 *             reference: 'a',
 *             id: 'a2'
 *         }, {
 *             xtype: 'component',
 *             reference: 'b',
 *             id: 'b2'
 *         }]
 *     }]
 * });
 * // The main container will not have references to a/b, each innerCt will
 * console.log(ct.lookupReference('a'), ct.lookupReference('b'));
 * var inner1 = ct.lookupReference('innerCt1');
 * var inner2 = ct.lookupReference('innerCt2');
 *
 * console.log(inner1.lookupReference('a').id, inner1.lookupReference('b').id);
 * console.log(inner2.lookupReference('a').id, inner2.lookupReference('b').id);
 * </pre>
 * <p>If the view has a controller attached, it will automatically become a →<code>referenceHolder</code>.
 * References will be available in both the view and the controller:</p>
 * <pre>
 * Ext.define('ProfileController', {
 *     extend: 'Ext.app.ViewController',
 *     alias: 'controller.profile',
 *
 *     init: function() {
 *         console.log(this.lookupReference('firstName'));
 *     }
 * });
 *
 * Ext.define('Profile', {
 *     extend: 'Ext.form.Panel',
 *     controller: 'profile',
 *     items: [{
 *         xtype: 'textfield',
 *         reference: 'firstName',
 *         fieldLabel: 'First Name'
 *     }]
 * });
 *
 * new Profile();
 * </pre>
 * <p><b><i>Events &amp; →<code>defaultListenerScope</code></i></b></p>
 * <p>Events can use the default listener scope to determine at runtime the appropriate place
 * to fire. This allows for declarative binding of events in a useful way:</p>
 * <pre>
 * Ext.define('MyView', {
 *     extend: 'Ext.container.Container',
 *     defaultListenerScope: true,
 *     referenceHolder: true,
 *     items: [{
 *         xtype: 'textfield',
 *         reference: 'myfield'
 *     }, {
 *         xtype: 'button',
 *         text: 'Set to A',
 *         listeners: {
 *             click: 'onButtonAClick'
 *         }
 *     }, {
 *         xtype: 'button',
 *         text: 'Set to B',
 *         listeners: {
 *             click: 'onButtonBClick'
 *         }
 *     }],
 *
 *     onButtonAClick: function() {
 *         this.lookupReference('myfield').setValue('A');
 *     },
 *
 *     onButtonBClick: function() {
 *         this.lookupReference('myfield').setValue('B');
 *     }
 * });
 * </pre>
 * <p>Like →<code>referenceHolder</code>, the →<code>defaultListenerScope</code> is encapsulated, the scope will
 * be resolved at the closest →<code>defaultListenerScope</code> above it in the component hierarchy:</p>
 * <pre>
 * var ct = new Ext.container.Container({
 *     defaultListenerScope: true,
 *     onCustomEvent: function() {
 *         console.log('Outer called'); // Will NOT be called
 *     },
 *     items: [{
 *         xtype: 'container',
 *         defaultListenerScope: true,
 *         onCustomEvent: function() {
 *             console.log('Inner called'); // Will be called
 *         },
 *         items: [{
 *             xtype: 'component',
 *             itemId: 'child',
 *             listeners: {
 *                 customevent: 'onCustomEvent'
 *             }
 *         }]
 *     }]
 * });
 * // The main container will not have references to a/b, each innerCt will
 * console.log(ct.lookupReference('a'), ct.lookupReference('b'));
 * var inner1 = ct.lookupReference('innerCt1');
 * var inner2 = ct.lookupReference('innerCt2');
 *
 * console.log(inner1.lookupReference('a').id, inner1.lookupReference('b').id);
 * console.log(inner2.lookupReference('a').id, inner2.lookupReference('b').id);
 * </pre>
 * <p>Similar to references, if a →<code>ext.app.ViewController</code> is attached to this view, it becomes
 * the →<code>defaultListenerScope</code>, which means un-scoped, late bound events will be directed
 * to the controller. This is powerful as it allows views to be totally declarative:</p>
 * <pre>
 * Ext.define('MyApp.controller.Login', {
 *     extend : 'Ext.app.ViewController',
 *     alias : 'controller.login',
 *
 *     init: function() {
 *         this.sendCount = 0;
 *     },
 *
 *     onLoginClick : function(btn) {
 *         this.login();
 *     },
 *
 *     onFieldSpecialKey : function(field, e) {
 *         if (e.getKey() === e.ENTER) {
 *            this.login();
 *         }
 *     },
 *
 *     login : function() {
 *        var form = this.lookupReference('form');
 *         this.lookupReference('error').hide();
 *         if (form.isValid()) {
 *             console.log('Do the login!');
 *             // Server responded...
 *             if (++this.sendCount % 2 === 0) {
 *                 this.onServerSuccess();
 *             } else {
 *                 this.onServerFailure();
 *             }
 *         }
 *     },
 *
 *     onServerSuccess: function() {
 *         // Proceed
 *         console.log('All good');
 *     },
 *
 *     onServerFailure: function() {
 *         var error = this.lookupReference('error');
 *         error.update('Invalid username/password');
 *         error.show();
 *     }
 * });
 *
 * Ext.define('MyApp.view.Login', {
 *     extend : 'Ext.window.Window',
 *     controller : 'login',
 *     referenceHolder: true,
 *
 *     title : 'Login',
 *     width : 400,
 *
 *     items : [{
 *         xtype : 'form',
 *         reference : 'form',
 *         border : false,
 *         bodyPadding : 10,
 *         defaultType : 'textfield',
 *         defaults : {
 *             anchor : '90%',
 *             allowBlank : false,
 *             enableKeyEvents : true
 *         },
 *         items : [{
 *             xtype: 'component',
 *             reference: 'error',
 *             hidden: true,
 *             margin: '0 0 10 0',
 *             style: 'color: red;'
 *         }, {
 *             name : 'username',
 *             fieldLabel : 'Username',
 *             reference : 'username',
 *             listeners : {
 *                 specialkey : 'onFieldSpecialKey'
 *             }
 *         }, {
 *             name : 'password',
 *             fieldLabel : 'Password',
 *             reference : 'password',
 *             inputType : 'password',
 *             listeners : {
 *                 specialkey : 'onFieldSpecialKey'
 *             }
 *         }]
 *     }],
 *     buttons : ['-&gt;', {
 *         text : 'Login',
 *         listeners : {
 *             click : 'onLoginClick'
 *         }
 *     }]
 * });
 * </pre>
 * <p><b><i>Adding via remote configuration</i></b></p>
 * <p>A server side script can be used to add Components which are generated dynamically on the server.
 * An example of adding a GridPanel to a TabPanel where the GridPanel is generated by the server
 * based on certain parameters:</p>
 * <pre>
 * // execute an Ajax request to invoke server side script:
 * Ext.Ajax.request({
 *     url: 'gen-invoice-grid.php',
 *     // send additional parameters to instruct server script
 *     params: {
 *         startDate: Ext.getCmp('start-date').getValue(),
 *         endDate: Ext.getCmp('end-date').getValue()
 *     },
 *     // process the response object to add it to the TabPanel:
 *     success: function(xhr) {
 *         var newComponent = eval(xhr.responseText); // see discussion below
 *         myTabPanel.add(newComponent); // add the component to the TabPanel
 *         myTabPanel.setActiveTab(newComponent);
 *     },
 *     failure: function() {
 *         Ext.Msg.alert("Grid create failed", "Server communication failure");
 *     }
 * });
 * </pre>
 * <p>The server script needs to return a JSON representation of a configuration object, which,
 * when decoded will return a config object with an →<code>ext.Component.xtype</code>. The server
 * might return the following JSON:</p>
 * <pre>
 * {
 *     "xtype": 'grid',
 *     "title": 'Invoice Report',
 *     "store": {
 *         "model": 'Invoice',
 *         "proxy": {
 *             "type": 'ajax',
 *             "url": 'get-invoice-data.php',
 *             "reader": {
 *                 "type": 'json'
 *                 "record": 'transaction',
 *                 "idProperty": 'id',
 *                 "totalRecords": 'total'
 *             })
 *         },
 *         "autoLoad": {
 *             "params": {
 *                 "startDate": '01/01/2008',
 *                 "endDate": '01/31/2008'
 *             }
 *         }
 *     },
 *     "headers": [
 *         {"header": "Customer", "width": 250, "dataIndex": 'customer', "sortable": true},
 *         {"header": "Invoice Number", "width": 120, "dataIndex": 'invNo', "sortable": true},
 *         {"header": "Invoice Date", "width": 100, "dataIndex": 'date',
 *          "renderer": Ext.util.Format.dateRenderer('M d, y'), "sortable": true},
 *         {"header": "Value", "width": 120, "dataIndex": 'value', "renderer": 'usMoney',
 *          "sortable": true}
 *     ]
 * }
 * </pre>
 * <p>When the above code fragment is passed through the <code>eval</code> function in the success handler
 * of the Ajax request, the result will be a config object which, when added to a Container,
 * will cause instantiation of a GridPanel. <b>Be sure that the Container is configured with a layout
 * which sizes and positions the child items to your requirements.</b></p>
 * <p><b>Note:</b> since the code above is <i>generated</i> by a server script, the <code>autoLoad</code> params
 * for the Store, the user's preferred date format, the metadata to allow generation of the Model
 * layout, and the ColumnModel can all be generated into the code since these are all known
 * on the server.</p>
 * @see ext.Component#autoEl
 * @see #layout
 * @see #items
 * @see #add()
 * @see ext.layout.container.AutoLayout
 * @see ext.layout.container.CardLayout
 * @see ext.layout.container.FitLayout
 * @see ext.Component#reference
 * @see #referenceHolder
 * @see #defaultListenerScope
 * @see ext.app.ViewController
 * @see ext.Component#xtype
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html Original Ext JS documentation of 'Ext.container.Container'
 */
public class Container extends Component implements IQueryable, IContainer, IFocusableContainer, IAdvancedFocusableContainerMixin {
  /**
   * @param config @inheritDoc
   */
  public function Container(config:Container = null) {
    super();
  }

  [Bindable]
  [ExtConfig(mode="append")]
  [ArrayElementType("ext.Action")]
  /**
   * An array of named →<code>ext.Action</code>s
   * for this container and any descendant components. All actions in this array must have an →<code>ext.Action.actionId</code>
   * that is used as the key when the array of actions is converted to the →<code>#actions</code> map.
   * <p>An Action encapsulates a shareable, reusable set of properties which define a
   * "clickable" UI component such as a →<code>ext.button.Button</code> or
   * →<code>ext.menu.Item</code>, or <i>panel header tool</i> (→<code>ext.panel.Panel.tools</code>),
   * or an →<code>ext.grid.column.ActionColumn</code></p>
   * <p>An Action, or more conveniently, the <i>name</i> of an action prefixed with <code>'&#64;'</code>
   * may be used as a config object for creating child components which use a <code>handler</code>
   * config property to reference a Controller method to invoke when the component is
   * clicked.</p>
   * <p>The property name is the action name, which may then be used as a child item
   * configuration in an →<code>ext.container.Container.items</code> configuration in
   * any descendant component such as a toolbar or a menu, or in a
   * →<code>ext.panel.Panel.tools</code> configuration of a Panel.</p>
   * <p>The property value is a configuration object for any clickable component.</p>
   * <p>See the →<code>ext.Action</code> class for an example of reusable Actions.</p>
   * @since 6.2.0
   * @see ext.Action
   * @see ext.Action#actionId
   * @see ext.button.Button
   * @see ext.menu.Item
   * @see ext.panel.Panel#tools
   * @see ext.grid.column.ActionColumn
   * @see ext.container.Container#items
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#cfg-actions Original Ext JS documentation of 'actions'
   * @see #getActions()
   * @see #setActions()
   */
  public native function get actionList():Array;

  [Bindable]
  [ExtConfig(mode="append")]
  [ArrayElementType("ext.Action")]
  /**
   * @private
   */
  public native function set actionList(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * An object containing properties which define named <i>actions</i> (→<code>ext.Action</code>)
   * for this container and any descendant components.
   * <p>An Action encapsulates a shareable, reusable set of properties which define a
   * "clickable" UI component such as a <i>button</i> (→<code>ext.button.Button</code>) or
   * <i>menu item</i> (→<code>ext.menu.Item</code>), or <i>panel header tool</i> (→<code>ext.panel.Panel.tools</code>),
   * or an <i>ActionColumn item</i> (→<code>ext.grid.column.ActionColumn</code>)</p>
   * <p>An Action, or more conveniently, the <i>name</i> of an action prefixed with <code>'&#64;'</code>
   * may be used as a config object for creating child components which use a <code>handler</code>
   * config property to reference a Controller method to invoke when the component is
   * clicked.</p>
   * <p>The property name is the action name, which may then be used as a child item
   * configuration in an →<code>ext.container.Container.items</code> configuration in
   * any descendant component such as a toolbar or a menu, or in a
   * →<code>ext.panel.Panel.tools</code> configuration of a Panel.</p>
   * <p>The property value is a configuration object for any clickable component.</p>
   * <p>See the →<code>ext.Action</code> class for an example of reusable Actions.</p>
   * @since 6.2.0
   * @see ext.Action
   * @see ext.button.Button
   * @see ext.menu.Item
   * @see ext.panel.Panel#tools
   * @see ext.grid.column.ActionColumn
   * @see ext.container.Container#items
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#cfg-actions Original Ext JS documentation of 'actions'
   * @see #getActions()
   * @see #setActions()
   */
  public native function get actions():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set actions(value:Object):void;

  [ExtConfig]
  /**
   * DOM tabIndex attribute to set on the
   * active Focusable child of this container when using the "Roaming tabindex"
   * technique.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html#cfg-activeChildTabIndex Original Ext JS documentation of 'activeChildTabIndex'
   */
  public native function get activeChildTabIndex():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set activeChildTabIndex(value:Number):void;

  [ExtConfig]
  /**
   * A string component id or the numeric index of the component that should be
   * initially activated within the container's layout on render. For example,
   * activeItem: 'item-1' or activeItem: 0 (index 0 = the first item in the
   * container's collection). activeItem only applies to layout styles that can
   * display items one at a time (like →<code>ext.layout.container.CardLayout</code> and
   * →<code>ext.layout.container.FitLayout</code>).
   * @since 2.3.0
   * @see ext.layout.container.CardLayout
   * @see ext.layout.container.FitLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#cfg-activeItem Original Ext JS documentation of 'activeItem'
   * @see #setActiveItem()
   */
  public native function get activeItem():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set activeItem(value:*):void;

  [ExtConfig]
  /**
   * Set this to <code>true</code>
   * to enable focusing disabled child items via keyboard.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html#cfg-allowFocusingDisabledChildren Original Ext JS documentation of 'allowFocusingDisabledChildren'
   */
  public native function get allowFocusingDisabledChildren():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allowFocusingDisabledChildren(value:Boolean):void;

  [ExtConfig]
  /**
   * Defines the anchoring size of container.
   * Either a number to define the width of the container or an object
   * with <code>→width</code> and <code>→height</code> fields.
   * @see #width
   * @see #height
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#cfg-anchorSize Original Ext JS documentation of 'anchorSize'
   */
  public native function get anchorSize():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set anchorSize(value:*):void;

  /**
   * ARIA role for this Component, defaults to no role.
   * With no role, no other ARIA attributes are set.
   * @default 'presentation'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#property-ariaRole Original Ext JS documentation of 'ariaRole'
   */
  override public native function get ariaRole():String;

  /**
   * @private
   */
  public native function set ariaRole(value:String):void;

  [ExtConfig]
  /**
   * If true the container will automatically destroy any contained component that is removed
   * from it, else destruction must be handled manually.
   * @default true
   * @since 2.3.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#cfg-autoDestroy Original Ext JS documentation of 'autoDestroy'
   */
  public native function get autoDestroy():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoDestroy(value:Boolean):void;

  [ExtConfig]
  /**
   * The base CSS class to apply to this component's element. This will also be prepended
   * to elements within this component like Panel's body will get a class <code>x-panel-body</code>.
   * This means that if you create a subclass of Panel, and you want it to get all the Panels
   * styling for the element and the body, you leave the <code>→baseCls</code> <code>x-panel</code> and use
   * <code>→componentCls</code> to add specific styling for this component.
   * @default Ext.baseCSSPrefix + 'container'
   * @see #baseCls
   * @see #componentCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#cfg-baseCls Original Ext JS documentation of 'baseCls'
   */
  override public native function get baseCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set baseCls(value:String):void;

  [ArrayElementType("String")]
  [ExtConfig]
  /**
   * An array of events that, when fired, should be bubbled to any parent container.
   * See →<code>ext.util.Observable.enableBubble()</code>.
   * @since 3.4.0
   * @see ext.util.Observable#enableBubble()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#cfg-bubbleEvents Original Ext JS documentation of 'bubbleEvents'
   */
  public native function get bubbleEvents():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set bubbleEvents(value:Array):void;

  [ExtConfig]
  /**
   * Specifies a child Component to receive focus when this Container's →<code>focus()</code>
   * method is called. Should be a valid <i>query</i> (→<code>ext.ComponentQuery</code>) selector.
   * @see #focus()
   * @see ext.#ComponentQuery ext.ComponentQuery
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#cfg-defaultFocus Original Ext JS documentation of 'defaultFocus'
   */
  public native function get defaultFocus():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultFocus(value:String):void;

  [ExtConfig]
  /**
   * The default <i>xtype</i> (→<code>ext.Component</code>) of child Components to create in this Container when
   * a child item is specified as a raw configuration object, rather than as an instantiated
   * Component.
   * @default 'panel'
   * @since 2.3.0
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#cfg-defaultType Original Ext JS documentation of 'defaultType'
   */
  public native function get defaultType():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultType(value:String):void;

  [ExtConfig]
  /**
   * This option is a means of applying default settings to all added items whether added
   * through the →<code>items</code> config or via the →<code>add()</code> or →<code>insert()</code>
   * methods.
   * <p>Defaults are applied to both config objects and instantiated components conditionally
   * so as not to override existing properties in the item (see →<code>ext.Ext.applyIf()</code>).</p>
   * <p>If the defaults option is specified as a function, then the function will be called
   * using this Container as the scope (<code>this</code> reference) and passing the added item as
   * the first parameter. Any resulting object from that call is then applied to the item
   * as default properties.</p>
   * <p>For example, to automatically apply padding to the body of each of a set of
   * contained →<code>ext.panel.Panel</code> items, you could pass:
   * <code>defaults: {bodyStyle:'padding:15px'}</code>.</p>
   * <p>Usage:</p>
   * <pre>
   * defaults: { // defaults are applied to items, not the container
   *     scrollable: true
   * },
   * items: [
   *     // default will not be applied here, panel1 will be scrollable: false
   *     {
   *         xtype: 'panel',
   *         id: 'panel1',
   *         scrollable: false
   *     },
   *     // this component will have scrollable: true
   *     new Ext.panel.Panel({
   *         id: 'panel2'
   *     })
   * ]
   * </pre>
   * @since 2.3.0
   * @see #items
   * @see #add()
   * @see #insert()
   * @see ext.SExt#applyIf() ext.Ext.applyIf()
   * @see ext.panel.Panel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#cfg-defaults Original Ext JS documentation of 'defaults'
   */
  public native function get defaults():*;

  [ExtConfig(extractXType="defaultType")]
  /**
   * @private
   */
  public native function set defaults(value:*):void;

  [ExtConfig]
  /**
   * True to move any component to the <i>detachedBody</i> (→<code>ext.Ext.getDetachedBody()</code>) when the component
   * is removed from this container. This option is only applicable when the component
   * is not destroyed while being removed, see →<code>autoDestroy</code> and →<code>remove()</code>.
   * If this option is set to false, the DOM of the component will remain in the current place
   * until it is explicitly moved.
   * @default true
   * @see ext.SExt#getDetachedBody() ext.Ext.getDetachedBody()
   * @see #autoDestroy
   * @see #remove()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#cfg-detachOnRemove Original Ext JS documentation of 'detachOnRemove'
   */
  public native function get detachOnRemove():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set detachOnRemove(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function get excludeInputFields():Boolean;

  /**
   * @private
   */
  public native function set excludeInputFields(exclude:Boolean):void;

  /**
   * The MixedCollection containing all the floating child items of this container.
   * Will be <code>undefined</code> if there are no floating child items.
   * @since 4.1.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#property-floatingItems Original Ext JS documentation of 'floatingItems'
   */
  public native function get floatingItems():MixedCollection;

  /**
   * @private
   */
  public native function set floatingItems(value:MixedCollection):void;

  [ExtConfig]
  /**
   * Enable or disable navigation
   * with arrow keys for this FocusableContainer. This option may be useful
   * with nested FocusableContainers, when only the root container should
   * handle keyboard events.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html#cfg-focusableContainer Original Ext JS documentation of 'focusableContainer'
   */
  public native function get focusableContainer():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set focusableContainer(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function get focusableContainerEl():*;

  /**
   * @inheritDoc
   */
  public native function set focusableContainerEl(value:*):void;

  /**
   * @inheritDoc
   */
  public native function get getFocusablesFn():Function;

  /**
   * @private
   */
  public native function set getFocusablesFn(fn:Function):void;

  /**
   * @inheritDoc
   */
  public native function get ignoreInputFields():Boolean;

  /**
   * @private
   */
  public native function set ignoreInputFields(ignore:Boolean):void;

  [ExtConfig]
  /**
   * DOM tabIndex attribute to set on
   * inactive Focusable children of this container when using the "Roaming tabindex"
   * technique. This value rarely needs to be changed from its default.
   * @default -1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html#cfg-inactiveChildTabIndex Original Ext JS documentation of 'inactiveChildTabIndex'
   */
  public native function get inactiveChildTabIndex():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set inactiveChildTabIndex(value:Number):void;

  /**
   * @inheritDoc
   */
  public native function get isContainer():Boolean;

  /**
   * @inheritDoc
   */
  public native function set isContainer(value:Boolean):void;

  /**
   * The Collection containing all the child items of this container.
   * Alias for <code>items</code> to avoid name-clash with the config option.
   * @default new Ext.util.ItemCollection()
   * @since 2.3.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#property-items Original Ext JS documentation of 'items'
   */
  [Native("items")]
  public native function get itemCollection():MixedCollection;

  [ExtConfig]
  [ArrayElementType("ext.Component")]
  /**
   * A single item, or an array of child Components to be added to this container.
   * <p><b>Unless configured with a →<code>layout</code>, a Container simply renders child
   * Components serially into its encapsulating element and performs no sizing or
   * positioning upon them.</b></p>
   * <p>Example:</p>
   * <pre>
   * // specifying a single item
   * items: {...},
   * layout: 'fit',    // The single items is sized to fit
   *
   * // specifying multiple items
   * items: [{...}, {...}],
   * layout: 'hbox', // The items are arranged horizontally
   * </pre>
   * <p>Each item may be:</p>
   * <ul>
   * <li>A →<code>ext.Component</code></li>
   * <li>A Component configuration object</li>
   * </ul>
   * <p>If a configuration object is specified, the actual type of Component to be
   * instantiated my be indicated by using the →<code>ext.Component.xtype</code> option.</p>
   * <p>Every Component class has its own →<code>ext.Component.xtype</code>.</p>
   * <p>If an →<code>ext.Component.xtype</code> is not explicitly specified, the
   * →<code>defaultType</code> for the Container is used, which by default is usually <code>panel</code>.</p>
   * <p><b>Notes:</b></p>
   * <p>Ext uses lazy rendering. Child Components will only be rendered
   * should it become necessary. Items are automatically laid out when they are first
   * shown (no sizing is done while hidden), or in response to a →<code>updateLayout()</code>
   * call.</p>
   * <p>Do not specify →<code>ext.panel.Panel.contentEl</code> or
   * →<code>ext.panel.Panel.html</code> with <code>items</code>.</p>
   * @since 2.3.0
   * @see #layout
   * @see ext.Component
   * @see ext.Component#xtype
   * @see #defaultType
   * @see #updateLayout()
   * @see ext.panel.Panel#contentEl
   * @see ext.panel.Panel#html
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#cfg-items Original Ext JS documentation of 'items'
   */
  public native function get items():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set items(value:Array):void;

  [ExtConfig]
  /**
   * <b>Important</b>: In order for child items to be correctly sized and
   * positioned, typically a layout manager <b>must</b> be specified through
   * the <code>→layout</code> configuration option.
   * <p>The sizing and positioning of child →<code>items</code> is the responsibility of
   * the Container's layout manager which creates and manages the type of layout
   * you have in mind. For example:</p>
   * <p>If the layout configuration is not explicitly specified for
   * a general purpose container (e.g. Container or Panel) the
   * <i>default layout manager</i> (→<code>ext.layout.container.AutoLayout</code>) will be used
   * which does nothing but render child components sequentially into the
   * Container (no sizing or positioning will be performed in this situation).</p>
   * <p><b>layout</b> may be specified as either as an Object or as a String:</p>
   * <p><b><i>Specify as an Object</i></b></p>
   * <p>Example usage:</p>
   * <pre>
   * layout: {
   *     type: 'vbox',
   *     align: 'left'
   * }
   * </pre>
   * <ul>
   * <li>
   * <p><b>type</b></p>
   * <p>The layout type to be used for this container. If not specified,
   * a default →<code>ext.layout.container.AutoLayout</code> will be created and used.</p>
   * <p>Valid layout <code>type</code> values are listed in →<code>null</code>.</p>
   * </li>
   * <li>
   * <p>Layout specific configuration properties</p>
   * <p>Additional layout specific configuration properties may also be
   * specified. For complete details regarding the valid config options for
   * each layout type, see the layout class corresponding to the <code>type</code>
   * specified.</p>
   * </li>
   * </ul>
   * <p><b><i>Specify as a String</i></b></p>
   * <p>Example usage:</p>
   * <pre>
   * layout: 'vbox'
   * </pre>
   * <ul>
   * <li>
   * <p><b>layout</b></p>
   * <p>The layout <code>type</code> to be used for this container (see →<code>null</code>
   * for list of valid values).</p>
   * <p>Additional layout specific configuration properties. For complete
   * details regarding the valid config options for each layout type, see the
   * layout class corresponding to the <code>→layout</code> specified.</p>
   * </li>
   * </ul>
   * <p><b><i>Configuring the default layout type</i></b></p>
   * <p>If a certain Container class has a default layout (For example a
   * →<code>ext.toolbar.Toolbar</code> with a default <code>Box</code> layout), then to simply configure
   * the default layout, use an object, but without the <code>type</code> property:</p>
   * <pre>
   * xtype: 'toolbar',
   * layout: {
   *     pack: 'center'
   * }
   * </pre>
   * @default 'auto'
   * @since 2.3.0
   * @see #layout
   * @see #items
   * @see ext.layout.container.AutoLayout
   * @see null
   * @see ext.toolbar.Toolbar
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#cfg-layout Original Ext JS documentation of 'layout'
   * @see #setLayout()
   */
  public native function get layout():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set layout(value:*):void;

  [ExtConfig]
  /**
   * When <code>true</code> child components are tracked by their <code>name</code> property and can be
   * retrieved using the <code>→lookupName()</code> method.
   * @default false
   * @see #lookupName()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Container.html#cfg-nameHolder Original Ext JS documentation of 'nameHolder'
   */
  public native function get nameHolder():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set nameHolder(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function get nestedFocusableItems():Boolean;

  /**
   * @private
   */
  public native function set nestedFocusableItems(nested:Boolean):void;

  [ExtConfig]
  /**
   * If <code>true</code>, this container will be marked as being a point in the hierarchy where
   * references to items with a specified <code>reference</code> config will be held. The container
   * will automatically become a referenceHolder if a →<code>controller</code> is specified.
   * <p>See the introductory docs for →<code>ext.container.Container</code> for more information
   * about references &amp; reference holders.</p>
   * @default false
   * @see #controller
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Container.html#cfg-referenceHolder Original Ext JS documentation of 'referenceHolder'
   */
  public native function get referenceHolder():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set referenceHolder(value:Boolean):void;

  [ExtConfig]
  /**
   * An →<code>ext.XTemplate</code> used to create the internal structure inside
   * this Component's encapsulating <i>Element</i> (→<code>getEl()</code>).
   * <p>You do not normally need to specify this. For the base classes →<code>ext.Component</code> and
   * →<code>ext.container.Container</code>, this defaults to <b><code>null</code></b> which means that they will be
   * initially rendered with no internal structure; they render their <i>Element</i> (→<code>getEl()</code>)
   * empty. The more specialized classes with complex DOM structures provide their own template
   * definitions.</p>
   * <p>This is intended to allow the developer to create application-specific utility Components
   * with customized internal structure.</p>
   * <p>Upon rendering, any created child elements may be automatically imported into object
   * properties using the →<code>renderSelectors</code> and →<code>childEls</code> options.</p>
   * @default '<tpl if="hasTabGuard">{% this.renderTabGuard(out, values, \'before\'); %}</tpl>' + '{% this.renderContainer(out,values) %}' + '<tpl if="hasTabGuard">{% this.renderTabGuard(out, values, \'after\'); %}</tpl>'
   * @see ext.XTemplate
   * @see #getEl()
   * @see ext.Component
   * @see ext.container.Container
   * @see #renderSelectors
   * @see #childEls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#cfg-renderTpl Original Ext JS documentation of 'renderTpl'
   */
  override public native function get renderTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set renderTpl(value:*):void;

  [ExtConfig]
  /**
   * When <code>true</code>, FocusableContainer
   * will reset last focused position whenever focus leaves the container.
   * Subsequent tabbing into the container will always focus the first eligible
   * child item.
   * <p>When <code>false</code>, subsequent tabbing into the container will focus the child
   * item that was last focused before.</p>
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html#cfg-resetFocusPosition Original Ext JS documentation of 'resetFocusPosition'
   */
  public native function get resetFocusPosition():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set resetFocusPosition(value:Boolean):void;

  [ExtConfig]
  /**
   * If true, suspend calls to updateLayout. Useful when batching multiple adds to a container
   * and not passing them as multiple arguments or an array.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#cfg-suspendLayout Original Ext JS documentation of 'suspendLayout'
   */
  public native function get suspendLayout():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set suspendLayout(value:Boolean):void;

  [ExtConfig]
  /**
   * When set to true, two elements are added to the container's element. These are the tabGuardBeforeEl and tabGuardAfterEl.
   */
  public native function get tabGuard():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set tabGuard(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function get tabNavigationMode():int;

  /**
   * @private
   */
  public native function set tabNavigationMode(mode:int):void;

  /**
   * Adds →<code>ext.Component</code>(s) to this Container.
   * <p><b><i>Description:</i></b></p>
   * <ul>
   * <li>Fires the →<code>event:onBeforeAdd</code> event before adding.</li>
   * <li>The Container's <i>default config values</i> (→<code>defaults</code>) will be applied
   * accordingly (see <code>→defaults</code> for details).</li>
   * <li>Fires the <code>→event:onAdd</code> event after the component has been added.</li>
   * </ul>
   * <p><b><i>Notes:</i></b></p>
   * <p>If the Container is <b>already rendered</b> when <code>add</code>
   * is called, it will render the newly added Component into its content area.</p>
   * <p><b>If</b> the Container was configured with a size-managing →<code>layout</code> manager,
   * the Container will recalculate its internal layout at this time too.</p>
   * <p>Note that the default layout manager simply renders child Components sequentially
   * into the content area and thereafter performs no sizing.</p>
   * <p>If adding multiple new child Components, pass them as an array to the <code>add</code> method,
   * so that only one layout recalculation is performed.</p>
   * <pre>
   * tb = new Ext.toolbar.Toolbar({
   *     renderTo: document.body
   * });  // toolbar is rendered
   * // add multiple items.
   * // default type for Toolbar is 'button')
   * tb.add([{text:'Button 1'}, {text:'Button 2'}]);
   * </pre>
   * <p>To inject components between existing ones, use the →<code>insert()</code> method.</p>
   * <p><b><i>Warning:</i></b></p>
   * <p>Components directly managed by the BorderLayout layout manager may not be removed
   * or added. See the Notes for →<code>ext.layout.container.BorderLayout</code> for
   * more details.</p>
   * @since 2.3.0
   * @param component Either one or more Components to add or an Array of Components to add.
   * See <code>→items</code> for additional information.
   * @return The Components that were added.
   * @see ext.Component
   * @see #event:onBeforeAdd
   * @see #defaults
   * @see #event:onAdd
   * @see #layout
   * @see #insert()
   * @see ext.layout.container.BorderLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-add Original Ext JS documentation of 'add'
   * @see #items
   */
  public native function add(...component):*;

  /**
   * Invoked after the Container has laid out (and rendered if necessary)
   * its child Components.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-afterLayout Original Ext JS documentation of 'afterLayout'
   */
  protected native function afterLayout(layout:ContainerLayout):void;

  /**
   * Cascades down the component/container heirarchy from this component (passed in
   * the first call), calling the specified function with each component. The scope
   * (this reference) of the function call will be the scope provided or the current
   * component. The arguments to the function will be the args provided or the current
   * component. If the function returns false at any point, the cascade is stopped on
   * that branch.
   * @since 2.3.0
   * @param fn The function to call
   * @param scope The scope of the function(defaults to current component)
   * @param origArgs The args to call the function with. The current component
   * always passed as the last argument.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-cascade Original Ext JS documentation of 'cascade'
   */
  public native function cascade(fn:Function, scope:Object = null, origArgs:Array = null):Container;

  /**
   * @inheritDoc
   */
  public native function child(selector:* = undefined):Component;

  /**
   * Determines whether the passed Component is either an immediate child of this Container,
   * or whether it is a descendant.
   * @param comp The Component to test.
   * @param deep Pass <code>true</code> to test for the Component being a descendant
   * at any level.
   * @default false
   * @return <code>true</code> if the passed Component is contained at the specified level.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-contains Original Ext JS documentation of 'contains'
   */
  public native function contains(comp:Component, deep:Boolean = false):Boolean;

  /**
   * Disables all child input fields and buttons.
   * @param silent Passing <code>true</code> will suppress the <code>disable</code> event
   * from being fired.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-disable Original Ext JS documentation of 'disable'
   */
  override public native function disable(silent:Boolean = false):void;

  /**
   * @inheritDoc
   */
  public native function down(selector:* = undefined):Component;

  /**
   * Enables all child input fields and buttons.
   * @param silent Passing <code>true</code> will suppress the <code>enable</code> event
   * from being fired.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-enable Original Ext JS documentation of 'enable'
   */
  override public native function enable(silent:Boolean = false):void;

  [Deprecated(message="Use <code>down(...)</code> or <code>query(...)</code> with selector <code>'[prop=value]'</code> instead.\n\n", since="6.0")]
  [ArrayElementType("ext.Component")]
  /**
   * Find a component under this container at any level by property
   * @param prop
   * @param value
   * @deprecated
   * @return Array of Ext.Components
   */
  public native function find(prop:String, value:String):Array;

  [Deprecated(message="Use <code>down(...)</code> or <code>query(...)</code> with selector <code>'xtype'</code> instead. Use selector <code>'xtype(true)'</code> for shallow xtype lookup.\n\n", since="6.0")]
  [ArrayElementType("ext.Component")]
  /**
   * Find a component under this container at any level by xtype or class
   * @param xtype The xtype string for a component, or the class of the component directly
   * @param shallow False to check whether this Component is descended from the xtype (this is the default), or true to check whether this Component is directly of the specified xtype.
   * @return Array of Ext.Components
   */
  public native function findByType(xtype:*, shallow:Boolean = false):Array;

  /**
   * Retrieves the named →<code>ext.Action</code> from this view or any ancestor which
   * has that named Action. See →<code>actions</code>
   * @see ext.Action
   * @see #actions
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-getAction Original Ext JS documentation of 'getAction'
   */
  public native function getAction(name:String):Action;

  /**
   * Returns the value of <code>actions</code>.
   * @see #actions
   */
  public native function getActions():Object;

  /**
   * Return the immediate child Component in which the passed element is located.
   * @param el The element to test (or ID of element).
   * @param deep If <code>true</code>, returns the deepest descendant Component which contains
   * the passed element.
   * @return The child item which contains the passed element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-getChildByElement Original Ext JS documentation of 'getChildByElement'
   */
  public native function getChildByElement(el:*, deep:Boolean):Component;

  /**
   * Examines this container's →<code>items</code> <b>property</b> and gets a direct child
   * component of this container.
   * @since 2.3.0
   * @param comp This parameter may be any of the following:
   * <ul>
   * <li>a <b>String</b> : representing the →<code>ext.Component.itemId</code>
   * or →<code>ext.Component.id</code> of the child component.</li>
   * <li>a <b>Number</b> : representing the position of the child component
   * within the →<code>items</code> <b>property</b></li>
   * </ul>
   * <p>For additional information see →<code>ext.util.MixedCollection.get()</code>.</p>
   * @return The component (if found).
   * @see #items
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-getComponent Original Ext JS documentation of 'getComponent'
   * @see ext.Component#itemId
   * @see ext.Component#id
   * @see ext.util.MixedCollection#get()
   */
  public native function getComponent(comp:*):Component;

  /**
   * Finds the configured default focus item. See →<code>defaultFocus</code>.
   * @see #defaultFocus
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-getDefaultFocus Original Ext JS documentation of 'getDefaultFocus'
   */
  public native function getDefaultFocus():Component;

  /**
   * Returns the focus holder element associated with this Container.
   * By default, this is the Container's target element; however if →<code>defaultFocus</code>
   * is defined, the child component referenced by that property will be found
   * and returned instead.
   * @return the focus holding element.
   * @see #defaultFocus
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-getFocusEl Original Ext JS documentation of 'getFocusEl'
   */
  override protected native function getFocusEl():Element;

  /**
   * Returns the <i>layout</i> (→<code>ext.layout.container.ContainerLayout</code>) instance currently associated
   * with this Container. If a layout has not been instantiated yet, that is done first
   * @return The layout
   * @see ext.layout.container.ContainerLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-getLayout Original Ext JS documentation of 'getLayout'
   */
  public native function getLayout():ContainerLayout;

  /**
   * @inheritDoc
   */
  public native function getNamedItems():Object;

  /**
   * Used by →<code>ext.ComponentQuery</code>, →<code>child()</code> and →<code>down()</code>
   * to retrieve all of the items which can potentially be considered a child of this Container.
   * <p>This may be overriden by Components which have ownership of Components
   * that are not contained in the →<code>items</code> collection.</p>
   * <p>NOTE: IMPORTANT note for maintainers:
   * Items are returned in tree traversal order. Each item is appended to the result array
   * followed by the results of that child's getRefItems call.
   * Floating child items are appended after internal child items.</p>
   * @see ext.#ComponentQuery ext.ComponentQuery
   * @see #child()
   * @see #down()
   * @see #items
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-getRefItems Original Ext JS documentation of 'getRefItems'
   */
  protected native function getRefItems(deep:*):Array;

  /**
   * @inheritDoc
   */
  public native function getReferences():Object;

  /**
   * Called by <code>→getInherited()</code> to initialize the inheritedState the first time it is
   * requested.
   * @param inheritedState The state object for this instance.
   * @param inheritedStateInner This object is only provided for containers.
   * @see #getInherited()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-initInheritedState Original Ext JS documentation of 'initInheritedState'
   */
  override protected native function initInheritedState(inheritedState:Object, inheritedStateInner:Object = null):void;

  /**
   * This method is called to initialize the <code>items</code> collection. A derived class can
   * override this method to do any last minute manipulation of <code>items</code> and then call
   * this method using <code>callParent</code>. Upon return, the <code>items</code> will no longer be a simple
   * array.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-initItems Original Ext JS documentation of 'initItems'
   */
  protected native function initItems():void;

  /**
   * Inserts a Component into this Container at a specified index. Fires the
   * →<code>event:onBeforeAdd</code> event before inserting, then fires the →<code>event:onAdd</code>
   * event after the Component has been inserted.
   * @since 2.3.0
   * @param index The index at which the Component will be inserted
   * into the Container's items collection
   * @param component The child Component
   * or config object to insert.
   * <p>Ext uses lazy rendering, and will only render the inserted Component should
   * it become necessary.</p>
   * <p>A Component config object may be passed in order to avoid the overhead of
   * constructing a real Component object if lazy rendering might mean that the
   * inserted Component will not be rendered immediately. To take advantage of
   * this 'lazy instantiation', set the →<code>ext.Component.xtype</code> config
   * property to the registered type of the Component wanted.</p>
   * <p>You can pass an array of Component instances and config objects.</p>
   * <p>For a list of all available xtypes, see →<code>null</code>.</p>
   * @return component The Component (or config object) that was
   * inserted with the Container's default config values applied.
   * @see #event:onBeforeAdd
   * @see #event:onAdd
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-insert Original Ext JS documentation of 'insert'
   * @see ext.Component#xtype
   * @see null
   */
  public native function insert(index:Number, component:Component):Component;

  /**
   * @inheritDoc
   */
  public native function lookup(ref:String):Component;

  /**
   * Called when a raw config object is added to this container either during initialization
   * of the →<code>items</code> config, or when new items are <i>added</i> (→<code>add()</code>),
   * or <i>inserted</i> (→<code>insert()</code>).
   * <p>This method converts the passed object into an instanced child component.</p>
   * <p>This may be overridden in subclasses when special processing needs to be applied to child
   * creation.</p>
   * @param comp The config object being added.
   * @return The component to be added.
   * @see #items
   * @see #add()
   * @see #insert()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-lookupComponent Original Ext JS documentation of 'lookupComponent'
   */
  protected native function lookupComponent(comp:Object):Component;

  /**
   * @inheritDoc
   */
  public native function lookupName(name:String):Component;

  /**
   * @inheritDoc
   */
  public native function lookupReference(ref:String):Component;

  [Deprecated(replacement="moveBefore", since="5.0")]
  /**
   * Moves a Component within the Container. This method does <b>not</b> account for things
   * like splitter components added by a layout. To better handle these situations, it
   * is recommended to use <code>→moveBefore()</code> or <code>→moveAfter()</code> instead.
   * @param direction Possible values are:
   * <ul>
   * <li><code>"l"</code> (or <code>"left"</code>)</li>
   * <li><code>"r"</code> (or <code>"right"</code>)</li>
   * <li><code>"t"</code> (or <code>"top"</code>, or <code>"up"</code>)</li>
   * <li><code>"b"</code> (or <code>"bottom"</code>, or <code>"down"</code>)</li>
   * </ul>
   * @param distance How far to move the element in pixels
   * @param animate true for the default animation or a standard
   * Element animation config object
   * @see #moveBefore()
   * @see #moveAfter()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-move Original Ext JS documentation of 'move'
   */
  override public native function move(direction:String, distance:Number, animate:* = undefined):void;

  /**
   * Moves the given <code>item(s)</code> into this container following <code>after</code>. This method will
   * account for layout-generated components like splitters and should be used instead
   * of index based <code>→move()</code>. If <code>after</code> is <code>null</code> then the <code>item</code> will be the
   * first item in this container.
   * <pre>
   * var tb = Ext.create({
   *     xtype: 'toolbar',
   *     renderTo: Ext.getBody(),
   *     items: [{
   *         text: 'one'
   *     }, {
   *         text: 'two'
   *     }]
   * });
   *
   * // moves the 'one' button after the 'two' button
   * tb.moveAfter(tb.getComponent(0), tb.getComponent(1));
   * </pre>
   * @since 5.0.0
   * @param item The item to move. May be a component,
   * component configuration object, or an array of either.
   * @param after The reference component. May be <code>null</code>.
   * @return The moved item(s).
   * @see #move()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-moveAfter Original Ext JS documentation of 'moveAfter'
   */
  public native function moveAfter(item:*, after:Component):*;

  /**
   * Moves the given <code>item(s)</code> into this container in front of <code>before</code>. This method
   * will account for layout-generated components like splitters and should be used
   * instead of index based <code>→move()</code>. If <code>before</code> is <code>null</code> then the
   * <code>item</code> will be the last item in this container.
   * <pre>
   * var tb = Ext.create({
   *     xtype: 'toolbar',
   *     renderTo: Ext.getBody(),
   *     items: [{
   *         text: 'one'
   *     }, {
   *         text: 'two'
   *     }]
   * });
   *
   * // moves the 'two' button before the 'one' button
   * tb.moveBefore(tb.getComponent(1), tb.getComponent(0));
   * </pre>
   * @since 5.0.0
   * @param item The item to move. May be a component,
   * component configuration object, or an array of either.
   * @param before The reference component. May be <code>null</code>.
   * @return The moved item(s).
   * @see #move()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-moveBefore Original Ext JS documentation of 'moveBefore'
   */
  public native function moveBefore(item:*, before:Component):*;

  /**
   * A method to find a child component after the passed child parameter. If a selector is also
   * provided, the first child component matching the selector will be returned.
   * @param child The child to use as a starting point to find the next child.
   * @param selector A →<code>ext.ComponentQuery</code> selector to find the next child.
   * This will return the next child matching this selector. This parameter is optional.
   * @return The next child found, <code>null</code> if no child found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-nextChild Original Ext JS documentation of 'nextChild'
   * @see ext.#ComponentQuery ext.ComponentQuery
   */
  public native function nextChild(child:Component, selector:String = null):Component;

  /**
   * This method is invoked after a new Component has been added. It
   * is passed the Component which has been added. This method may
   * be used to update any internal structure which may depend upon
   * the state of the child items.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-onAdd Original Ext JS documentation of 'onAdd'
   */
  protected native function onAdd(component:Component, position:Number):void;

  /**
   * This method is invoked before adding a new child Component. It
   * is passed the new Component, and may be used to modify the
   * Component, or prepare the Container in some way. Returning
   * false aborts the add operation.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-onBeforeAdd Original Ext JS documentation of 'onBeforeAdd'
   */
  protected native function onBeforeAdd(item:Component):void;

  /**
   * This method is invoked after a new Component has been
   * removed. It is passed the Component which has been
   * removed. This method may be used to update any internal
   * structure which may depend upon the state of the child items.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param component The removed component
   * @param isDestroying <code>true</code> if the the component is being destroyed in
   * the remove action
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-onRemove Original Ext JS documentation of 'onRemove'
   */
  protected native function onRemove(component:Component, isDestroying:Boolean):void;

  /**
   * Method to manage awareness of when components are removed from their
   * respective Container, firing a #removed event. References are properly
   * cleaned up after removing a component from its owning container.
   * <p>Allows addition of behavior when a Component is removed from
   * its parent Container. At this stage, the Component has been
   * removed from its parent Container's collection of child items,
   * but has not been destroyed (It will be destroyed if the parent
   * Container's <code>→autoDestroy</code> is <code>true</code>, or if the remove call was
   * passed a truthy second parameter). After calling the
   * superclass's <code>→onRemoved()</code>, the <code>→ownerCt</code> and the <code>refOwner</code> will not
   * be present.</p>
   * @param destroying Will be passed as <code>true</code> if the Container performing
   * the remove operation will delete this Component upon remove.
   * @see #autoDestroy
   * @see #onRemoved()
   * @see #ownerCt
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-onRemoved Original Ext JS documentation of 'onRemoved'
   */
  override protected native function onRemoved(destroying:Boolean):void;

  /**
   * Called when the component is resized.
   * <p>This method is not called on components that use →<code>liquidLayout</code>, such as
   * <i>Buttons</i> (→<code>ext.button.Button</code>) and <i>Form Fields</i> (→<code>ext.form.field.BaseField</code>).</p>
   * @param width The new width that was set
   * @param height The new height that was set
   * @param oldWidth The previous width
   * @param oldHeight The previous height
   * @see #liquidLayout
   * @see ext.button.Button
   * @see ext.form.field.BaseField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-onResize Original Ext JS documentation of 'onResize'
   */
  override protected native function onResize(width:Number, height:Number, oldWidth:Number, oldHeight:Number):void;

  /**
   * A method to find a child component before the passed child parameter. If a selector is also
   * provided, the first child component matching the selector will be returned.
   * @param child The child to use as a starting point to find the previous child.
   * @param selector A →<code>ext.ComponentQuery</code> selector to find the previous child.
   * This will return the first child matching this selector. This parameter is optional.
   * @return The previous child found, <code>null</code> if no child found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-prevChild Original Ext JS documentation of 'prevChild'
   * @see ext.#ComponentQuery ext.ComponentQuery
   */
  public native function prevChild(child:Component, selector:String = null):Component;

  [ArrayElementType("ext.Component")]
  /**
   * @inheritDoc
   */
  public native function query(selector:String = null):Array;

  [ArrayElementType("ext.Component")]
  /**
   * @inheritDoc
   */
  public native function queryBy(fn:Function, scope:Object = null):Array;

  /**
   * @inheritDoc
   */
  public native function queryById(id:String):Component;

  /**
   * Removes a component from this container. Fires the →<code>event:onBeforeRemove</code> event
   * before removing, then fires the →<code>event:onRemove</code> event after the component has
   * been removed.
   * @since 2.3.0
   * @param component The component instance or id to remove.
   * @param autoDestroy Flags to determine what to do with the removed component.
   * (May also be specified as a boolean <code>→autoDestroy</code> flag for backward compatibility).
   * <ul>
   * <li><code>destroy:Boolean</code> (optional) —
   * Defaults to this Container's →<code>autoDestroy</code>
   * config. Specifies whether to destroy the component being removed.
   * </li>
   * <li><code>detach</code> (optional) —
   * Defaults to the →<code>detachOnRemove</code> configuration
   * Specifies whether to remove the component's DOM from the container and into
   * the <i>detached body element</i> (→<code>ext.Ext.getDetachedBody()</code>)
   * </li>
   * </ul>
   * @return component The Component that was removed.
   * @see #event:onBeforeRemove
   * @see #event:onRemove
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-remove Original Ext JS documentation of 'remove'
   * @see #autoDestroy
   * @see #detachOnRemove
   * @see ext.SExt#getDetachedBody() ext.Ext.getDetachedBody()
   */
  public native function remove(component:*, autoDestroy:Object = null):Component;

  [ArrayElementType("ext.Component")]
  /**
   * Removes all components from this container.
   * @since 2.3.0
   * @param autoDestroy True to automatically invoke the removed
   * Component's →<code>ext.Component.destroy()</code> function.
   * Defaults to the value of this Container's →<code>autoDestroy</code> config.
   * @return Array of the removed components
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-removeAll Original Ext JS documentation of 'removeAll'
   * @see ext.Component#destroy()
   * @see #autoDestroy
   */
  public native function removeAll(autoDestroy:Boolean = false):Array;

  /**
   * Sets the value of <code>actions</code>.
   * @param actions The new value.
   * @see #actions
   */
  public native function setActions(actions:Object):void;

  /**
   * Sets a component as the active layout item. This only applies when using
   * a →<code>ext.layout.container.CardLayout</code> layout.
   * <pre>
   * var card1 = Ext.create('Ext.panel.Panel', {itemId: 'card-1'});
   * var card2 = Ext.create('Ext.panel.Panel', {itemId: 'card-2'});
   * var panel = Ext.create('Ext.panel.Panel', {
   *     layout: 'card',
   *     items: [card1, card2]
   * });
   * // These are all equivalent
   * panel.getLayout().setActiveItem(card2);
   * panel.getLayout().setActiveItem('card-2');
   * panel.getLayout().setActiveItem(1);
   * </pre>
   * @param item The component, component
   * →<code>ext.Component.id</code>, →<code>ext.Component.itemId</code>, or index of component.
   * @return the activated component or false when nothing activated.
   * False is returned also when trying to activate an already active item.
   * @see ext.layout.container.CardLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-setActiveItem Original Ext JS documentation of 'setActiveItem'
   * @see ext.Component#id
   * @see ext.Component#itemId
   */
  public native function setActiveItem(item:*):Component;

  /**
   * Reconfigures the initially configured →<code>layout</code>.
   * <p>NOTE: this method cannot be used to change the "type" of layout after the component
   * has been rendered to the DOM. After rendering, this method can only modify the
   * existing layout's configuration properties. The reason for this restriction is that
   * many container layouts insert special wrapping elements into the dom, and the
   * framework does not currently support dynamically changing these elements once
   * rendered.</p>
   * @param configuration object for the layout
   * @see #layout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#method-setLayout Original Ext JS documentation of 'setLayout'
   */
  public native function setLayout(configuration:Object):void;

  /**
   * @inheritDoc
   */
  public native function visitPostOrder(selector:Object, fn:Function, scope:Object = null, extraArgs:Array = null):void;

  /**
   * @inheritDoc
   */
  public native function visitPreOrder(selector:Object, fn:Function, scope:Object = null, extraArgs:Array = null):void;
}
}
