package ext.container {
import ext.Base;
import ext.Component;

[Native("Ext.container.DockingContainer", require)]
/**
 * @see ext.container.events.DockingContainer_component_indexEvent.DOCKED_ADD
 * @eventType ext.container.events.DockingContainer_component_indexEvent.DOCKED_ADD
 */
[Event(name='onDockedAdd', type='ext.container.events.DockingContainer_component_indexEvent')]
/**
 * @see ext.container.events.DockingContainer_componentEvent.DOCKED_REMOVE
 * @eventType ext.container.events.DockingContainer_componentEvent.DOCKED_REMOVE
 */
[Event(name='onDockedRemove', type='ext.container.events.DockingContainer_componentEvent')]
/**
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.DockingContainer.html Original Ext JS documentation of 'Ext.container.DockingContainer'
 */
public class DockingContainer extends Base implements IDockingContainer {
  /**
   * @param config @inheritDoc
   */
  public function DockingContainer(config:DockingContainer = null) {
    super();
  }

  [ExtConfig]
  /**
   * This object holds the default weights applied to dockedItems that have no weight.
   * These start with a weight of 1, to allow negative weights to insert before top items
   * and are odd numbers so that even weights can be used to get between different dock orders.
   * <p>To make default docking order match border layout, do this:</p>
   * <pre>
   *  Ext.panel.Panel.prototype.defaultDockWeights = { top: 1, bottom: 3, left: 5, right: 7 };
   * </pre>
   * <p>Changing these defaults as above or individually on this object will effect all Panels.
   * To change the defaults on a single panel, you should replace the entire object:</p>
   * <pre>
   *  initComponent: function() {
   *      // NOTE: Don't change members of defaultDockWeights since the object is shared.
   *      this.defaultDockWeights = { top: 1, bottom: 3, left: 5, right: 7 };
   *
   *      this.callParent();
   *  }
   * </pre>
   * <p>To change only one of the default values, you do this:</p>
   * <pre>
   *  initComponent: function() {
   *      // NOTE: Don't change members of defaultDockWeights since the object is shared.
   *      this.defaultDockWeights = Ext.applyIf({ top: 10 }, this.defaultDockWeights);
   *
   *      this.callParent();
   *  }
   * </pre>
   * @default {
   *     top: {
   *         render: 1,
   *         visual: 1
   *     },
   *     left: {
   *         render: 3,
   *         visual: 5
   *     },
   *     right: {
   *         render: 5,
   *         visual: 7
   *     },
   *     bottom: {
   *         render: 7,
   *         visual: 3
   *     }
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.DockingContainer.html#cfg-defaultDockWeights Original Ext JS documentation of 'defaultDockWeights'
   */
  public native function get defaultDockWeights():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultDockWeights(value:Object):void;

  [ArrayElementType("ext.Component")]
  /**
   * Adds docked item(s) to the container.
   * @param items The Component or array of components to add. The components
   * must include a 'dock' parameter on each component to indicate where it should be docked
   * ('top', 'right', 'bottom', 'left').
   * @param pos The index at which the Component will be added
   * @return The added components.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.DockingContainer.html#method-addDocked Original Ext JS documentation of 'addDocked'
   */
  public native function addDocked(items:*, pos:Number = NaN):Array;

  /**
   * Finds a docked component by id, itemId or position. Also see →<code>getDockedItems()</code>
   * @param comp The id, itemId or position of the docked component
   * (see →<code>ext.container.Container.getComponent()</code> for details)
   * @return The docked component (if found)
   * @see #getDockedItems()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.DockingContainer.html#method-getDockedComponent Original Ext JS documentation of 'getDockedComponent'
   * @see ext.container.Container#getComponent()
   */
  public native function getDockedComponent(comp:*):Component;

  [ArrayElementType("ext.Component")]
  /**
   * Retrieves an array of all currently docked Components.
   * <p>For example to find a toolbar that has been docked at top:</p>
   * <pre>
   * panel.getDockedItems('toolbar[dock="top"]');
   * </pre>
   * @param selector A →<code>ext.ComponentQuery</code> selector string
   * to filter the returned items.
   * @param beforeBody An optional flag to limit the set of items to only those
   * before the body (true) or after the body (false). All components are returned by default.
   * @return The array of docked components meeting the specified criteria.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.DockingContainer.html#method-getDockedItems Original Ext JS documentation of 'getDockedItems'
   * @see ext.#ComponentQuery ext.ComponentQuery
   */
  public native function getDockedItems(selector:String, beforeBody:Boolean = undefined):Array;

  /**
   * Initializes an Item Collection for docked items to be inserted into. If items
   * already exist, they will be added to the new collection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.DockingContainer.html#method-initDockingItems Original Ext JS documentation of 'initDockingItems'
   */
  protected native function initDockingItems():void;

  /**
   * Inserts docked item(s) to the panel at the indicated position.
   * @param pos The index at which the Component will be inserted
   * @param items The Component or array of components to add. The components
   * must include a 'dock' paramater on each component to indicate where it should be docked
   * ('top', 'right', 'bottom', 'left').
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.DockingContainer.html#method-insertDocked Original Ext JS documentation of 'insertDocked'
   */
  public native function insertDocked(pos:Number, items:*):void;

  /**
   * Invoked after a docked item is added to the Panel.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.DockingContainer.html#method-onDockedAdd Original Ext JS documentation of 'onDockedAdd'
   */
  protected native function onDockedAdd(component:Component):void;

  /**
   * Invoked after a docked item is removed from the Panel.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.DockingContainer.html#method-onDockedRemove Original Ext JS documentation of 'onDockedRemove'
   */
  protected native function onDockedRemove(component:Component):void;

  /**
   * Removes the docked item from the panel.
   * @param item The Component to remove.
   * @param flags Pass <code>true</code> to destroy the item or an
   * object with multiple options. If not passed, →<code>autoDestroy</code> will
   * determine if the item is destroyed.
   * <ul>
   * <li><code>destroy:Boolean</code> (optional) —
   * Pass <code>true</code> to destroy the item.
   * </li>
   * <li><code>detach:Boolean</code> (optional) —
   * Pass <code>true</code> to put the item in the
   * <i>detachedBody element</i> (→<code>ext.Ext.getDetachedBody()</code>).
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.DockingContainer.html#method-removeDocked Original Ext JS documentation of 'removeDocked'
   * @see #autoDestroy
   * @see ext.SExt#getDetachedBody() ext.Ext.getDetachedBody()
   */
  public native function removeDocked(item:Component, flags:* = undefined):void;
}
}