package ext.container {

[Native("Ext.container.Viewport", require)]
/**
 * A specialized container representing the viewable application area (the browser viewport).
 * <p>The Viewport renders itself to the document body, and automatically sizes itself to the size of
 * the browser viewport and manages window resizing. There may only be one Viewport created
 * in a page.</p>
 * <p>Like any →<code>ext.container.Container</code>, a Viewport will only perform sizing
 * and positioning on its child Components if you configure it with a →<code>layout</code>.</p>
 * <p>A Common layout used with Viewports is <i>border layout</i> (→<code>ext.layout.container.BorderLayout</code>),
 * but if the required layout is simpler, a different layout should be chosen.</p>
 * <p>For example, to simply make a single child item occupy all available space, use
 * <i>fit layout</i> (→<code>ext.layout.container.FitLayout</code>).</p>
 * <p>To display one "active" item at full size from a choice of several child items, use
 * <i>card layout</i> (→<code>ext.layout.container.CardLayout</code>).</p>
 * <p>Inner layouts are available because all →<code>ext.panel.Panel</code>s
 * added to the Viewport, either through its →<code>items</code>, or the →<code>add()</code>
 * method of any of its child Panels may themselves have a layout.</p>
 * <p>The Viewport does not provide scrolling, so child Panels within the Viewport should provide
 * for scrolling if needed using the →<code>scrollable</code> config.</p>
 * <p>An example showing a classic application border layout:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.container.Viewport', {
 *     layout: 'border',
 *     items: [{
 *         region: 'north',
 *         html: '&lt;h1 class="x-panel-header"&gt;Page Title&lt;/h1&gt;',
 *         border: false,
 *         margin: '0 0 5 0'
 *     }, {
 *         region: 'west',
 *         collapsible: true,
 *         title: 'Navigation',
 *         width: 150
 *         // could use a TreePanel or AccordionLayout for navigational items
 *     }, {
 *         region: 'south',
 *         title: 'South Panel',
 *         collapsible: true,
 *         html: 'Information goes here',
 *         split: true,
 *         height: 100,
 *         minHeight: 100
 *     }, {
 *         region: 'east',
 *         title: 'East Panel',
 *         collapsible: true,
 *         split: true,
 *         width: 150
 *     }, {
 *         region: 'center',
 *         xtype: 'tabpanel', // TabPanel itself has no title
 *         activeTab: 0,      // First tab active by default
 *         items: {
 *             title: 'Default Tab',
 *             html: 'The first tab\'s content. Others may be added dynamically'
 *         }
 *     }]
 * });
 * </pre>
 * <p>Alternatively you can turn any normal Container (or Component) into a Viewport using
 * the <code>viewport plugin (→ext.plugin.ViewportPlugin)</code>.</p>
 * @see ext.container.Container
 * @see #layout
 * @see ext.layout.container.BorderLayout
 * @see ext.layout.container.FitLayout
 * @see ext.layout.container.CardLayout
 * @see ext.panel.Panel
 * @see #items
 * @see #add()
 * @see #scrollable
 * @see ext.plugin.ViewportPlugin
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Viewport.html Original Ext JS documentation of 'Ext.container.Viewport'
 */
public class Viewport extends Container {
  /**
   * @param config @inheritDoc
   */
  public function Viewport(config:Viewport = null) {
    super();
  }

  /**
   * <code>true</code> in this class to identify an object as an instantiated Viewport, or subclass thereof.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Viewport.html#property-isViewport Original Ext JS documentation of 'isViewport'
   */
  public native function get isViewport():Boolean;

  [ExtConfig]
  /**
   * The maximum zoom scale. Only applicable for touch devices. Set this to 1 to
   * disable zooming.
   * @default 10
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Viewport.html#cfg-maxUserScale Original Ext JS documentation of 'maxUserScale'
   */
  public native function get maxUserScale():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maxUserScale(value:Number):void;
}
}