package ext.container.events {
import ext.Component;
import ext.container.Container;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.container.events.Container_component_indexEvent")]
public class Container_component_indexEvent extends FlExtEvent {
  /**
   * Fires after any →<code>ext.Component</code> is added or inserted into the container.
   * @since 2.3.0
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#event-add Original Ext JS documentation of 'add'
   * @see ext.container.Container
   * @eventType onAdd
   */
  public static const ADD:String = "onAdd";
  /**
   * Fires before any →<code>ext.Component</code> is added or inserted into the container.
   * A handler can return false to cancel the add.
   * @since 2.3.0
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#event-beforeadd Original Ext JS documentation of 'beforeadd'
   * @see ext.container.Container
   * @eventType onBeforeAdd
   */
  public static const BEFORE_ADD:String = "onBeforeAdd";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "component", "index", "eOpts"];

  public function Container_component_indexEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The component that was added
   */
  public native function get component():Component;

  /**
   * The index at which the component was added to the container's items
   * collection
   */
  public native function get index():Number;

  public native function get source():Container;
}
}