package ext.container.events {
import ext.Component;
import ext.container.Container;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.container.events.Container_component_prevIndex_newIndexEvent")]
public class Container_component_prevIndex_newIndexEvent extends FlExtEvent {
  /**
   * Fires after any →<code>ext.Component</code> has changed its ordinal position within the container.
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#event-childmove Original Ext JS documentation of 'childmove'
   * @see ext.container.Container
   * @eventType onChildMove
   */
  public static const CHILD_MOVE:String = "onChildMove";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "component", "prevIndex", "newIndex", "eOpts"];

  public function Container_component_prevIndex_newIndexEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The component that was moved
   */
  public native function get component():Component;

  /**
   * The new ordinal position of the Component
   */
  public native function get newIndex():Number;

  /**
   * The previous ordinal position of the Component
   */
  public native function get prevIndex():Number;

  public native function get source():Container;
}
}