package ext.container.events {
import ext.container.Container;
import ext.layout.container.ContainerLayout;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.container.events.Container_layoutEvent")]
public class Container_layoutEvent extends FlExtEvent {
  /**
   * Fires when the components in this container are arranged by the associated layout manager.
   * @since 2.3.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.Container.html#event-afterlayout Original Ext JS documentation of 'afterlayout'
   * @see ext.container.Container
   * @eventType onAfterLayout
   */
  public static const AFTER_LAYOUT:String = "onAfterLayout";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "layout", "eOpts"];

  public function Container_layoutEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The ContainerLayout implementation for this
   * container
   */
  public native function get layout():ContainerLayout;

  public native function get source():Container;
}
}