package ext.dashboard {
import ext.panel.Panel;

[Native("Ext.dashboard.Dashboard", require)]
/**
 * @see ext.dashboard.events.DashboardEvent.BEFORE_DRAG_OVER
 * @eventType ext.dashboard.events.DashboardEvent.BEFORE_DRAG_OVER
 */
[Event(name='onBeforeDragOver', type='ext.dashboard.events.DashboardEvent')]
/**
 * @see ext.dashboard.events.DashboardEvent.BEFORE_DROP
 * @eventType ext.dashboard.events.DashboardEvent.BEFORE_DROP
 */
[Event(name='onBeforeDrop', type='ext.dashboard.events.DashboardEvent')]
/**
 * @see ext.dashboard.events.DashboardEvent.DRAG_OVER
 * @eventType ext.dashboard.events.DashboardEvent.DRAG_OVER
 */
[Event(name='onDragOver', type='ext.dashboard.events.DashboardEvent')]
/**
 * @see ext.dashboard.events.DashboardEvent.DROP
 * @eventType ext.dashboard.events.DashboardEvent.DROP
 */
[Event(name='onDrop', type='ext.dashboard.events.DashboardEvent')]
/**
 * @see ext.dashboard.events.DashboardEvent.VALIDATE_DROP
 * @eventType ext.dashboard.events.DashboardEvent.VALIDATE_DROP
 */
[Event(name='onValidateDrop', type='ext.dashboard.events.DashboardEvent')]
/**
 * This class manages a drag-drop Dashboard similar to the legacy Ext JS Portal example.
 * The user-directed layout of the Dashboard is preserved the Ext JS <code>→stateful</code> mechanism
 * to preserve potentially dynamic user sizing and collapsed states as well as order of
 * items in their columns.
 * @see #stateful
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dashboard.Dashboard.html Original Ext JS documentation of 'Ext.dashboard.Dashboard'
 */
public class Dashboard extends Panel {
  /**
   * @param config @inheritDoc
   */
  public function Dashboard(config:Dashboard = null) {
    super();
  }

  [ArrayElementType("Number")]
  [ExtConfig]
  /**
   * An array designating the width of columns in your dashboard's default state as described
   * by the →<code>defaultContent</code> property. For example:
   * <pre>
   * columnWidths: [
   *    0.35,
   *    0.40,
   *    0.25
   * ]
   * </pre>
   * <p>As you can see, this array contains the default widths for the 3 columns in the dashboard's
   * initial view. The column widths should total to an integer value, typically 1 as shown
   * above. When column widths exceed 1, they will be wrapped effectively creating "rows". This
   * means that if your column widths add up to more than 1, you would still want the first few
   * to total 1 to ensure that the first row fills the dashboard space. This applies whenever
   * the column widths extend past an integer value.</p>
   * <p><b>Note:</b> columnWidths will not be utilized if there is stateful information that
   * dictates different user saved column widths.</p>
   * @see #defaultContent
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dashboard.Dashboard.html#cfg-columnWidths Original Ext JS documentation of 'columnWidths'
   */
  public native function get columnWidths():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set columnWidths(value:Array):void;

  [ExtConfig]
  /**
   * An array of <i>part</i> (→<code>ext.dashboard.Part</code>) configuration objects that define your
   * dashboard's default state. These should not be confused with component configurations.
   * <p>Each config object should also include:</p>
   * <ul>
   * <li><code>type</code> - The type of <i>part</i> (→<code>ext.dashboard.Part</code>) that you want to be generated.</li>
   * <li><code>columnIndex</code> - The column position in which the <i>part</i> (→<code>ext.dashboard.Part</code>) should
   * reside.</li>
   * <li><code>→height</code> - The desired height of the <i>part</i> (→<code>ext.dashboard.Part</code>) to be generated.</li>
   * </ul>
   * <p>The remaining properties are specific to your part's config object. For example:</p>
   * <pre>
   *   defaultContent: [{
   *       type: 'rss',
   *       columnIndex: 0,
   *       height: 500,
   *       feedUrl: 'http://feeds.feedburner.com/extblog'
   *   }, {
   *       type: 'stockTicker',
   *       columnIndex: 1,
   *       height: 300
   *   }, {
   *       type: 'stocks',
   *       columnIndex: 1,
   *       height: 300
   *   }, {
   *       type: 'rss',
   *       columnIndex: 2,
   *       height: 350,
   *       feedUrl: 'http://rss.cnn.com/rss/edition.rss'
   *   }]
   * </pre>
   * <p>Default column widths are defined by →<code>columnWidths</code> and not in these
   * part config objects.</p>
   * <p><b>Note:</b> defaultContent will not be utilized if there is stateful information that
   * dictates different user saved positioning and componentry.</p>
   * @see ext.dashboard.Part
   * @see #height
   * @see #columnWidths
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dashboard.Dashboard.html#cfg-defaultContent Original Ext JS documentation of 'defaultContent'
   */
  public native function get defaultContent():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultContent(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * The maximum number of visible columns.
   * @default 4
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dashboard.Dashboard.html#cfg-maxColumns Original Ext JS documentation of 'maxColumns'
   * @see #getMaxColumns()
   * @see #setMaxColumns()
   */
  public native function get maxColumns():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set maxColumns(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * An object keyed by <code>→id</code> for the parts that can be created for this <code>Dashboard</code>.
   * @see #id
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dashboard.Dashboard.html#cfg-parts Original Ext JS documentation of 'parts'
   * @see #getParts()
   * @see #setParts()
   */
  public native function get parts():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set parts(value:Object):void;

  /**
   * Returns the value of <code>maxColumns</code>.
   * @see #maxColumns
   */
  public native function getMaxColumns():Number;

  /**
   * Returns the value of <code>parts</code>.
   * @see #parts
   */
  public native function getParts():Object;

  /**
   * Sets the value of <code>maxColumns</code>.
   * @param maxColumns The new value.
   * @see #maxColumns
   */
  public native function setMaxColumns(maxColumns:Number):void;

  /**
   * Sets the value of <code>parts</code>.
   * @param parts The new value.
   * @see #parts
   */
  public native function setParts(parts:Object):void;
}
}