package ext.dashboard {
import ext.Base;
import ext.Component;
import ext.mixin.IFactoryable;
import ext.mixin.IIdentifiable;

[Native("Ext.dashboard.Part", require)]
/**
 * This class encapsulates the creation of items for a <code>Dashboard</code>. Generally a <code>Part</code> is a
 * component factory that allows all parts of a common type to be easily coordinated as
 * needed for that type. For example, an RSS feed might need certain configuration data to
 * properly initialize. Perahps not all of this data can or should be supplied from the UI
 * that creates new instances for the <code>Dashboard</code>.
 * <p><b><i>Part Configuration</i></b></p>
 * <p>The primary role of a <code>Part</code> is to provide an abstract way to define the configuration
 * needed to create views. For example, an RSS Part would at least need the URL for the
 * feed.</p>
 * <p>To implement this a derived class provides a <code>→displayForm()</code> method:</p>
 * <pre>
 *  Ext.define('App.parts.RSS', {
 *      extend: 'Ext.dashboard.Part',
 *      alias: 'part.rss',
 *
 *      displayForm: function(instance, currentConfig, callback, scope) {
 *          var me = this,
 *              title = instance ? 'Edit RSS Feed' : 'Add RSS Feed';
 *
 *          // Display a prompt using current URL as default text.
 *          //
 *          Ext.Msg.prompt(title, 'RSS Feed URL', function(btn, text) {
 *              if (btn === 'ok') {
 *                  var config = {
 *                      feedUrl: text
 *                  };
 *
 *                  callback.call(scope || me, config);
 *              }
 *          }, me, false, currentConfig ? currentConfig.feedUrl : '');
 *      }
 *  });
 * </pre>
 * <p>The returned configuration object is used to create views. It is also passed back to
 * <code>→displayForm()</code> to allow the user to edit the configuration for an existing view.</p>
 * <p><b><i>Creating Views</i></b></p>
 * <p>The next step is to define the view (the components) appropriate for the part. To
 * continue with the above example.</p>
 * <pre>
 *  Ext.define('App.parts.RSS', {
 *      extend: 'Ext.dashboard.Part',
 *      alias: 'part.rss',
 *
 *      // The viewTemplate is "component template" that is evaluated against the
 *      // configuration (as returned by displayForm). The top-most component is
 *      // a panel specific to the Dashboard so it can be configured but should
 *      // not be replaced. Instead, fit an appropriate component to the panel.
 *      //
 *      viewTemplate: {
 *          layout: 'fit',
 *          items: [{
 *              xtype: 'feedpanel',
 *              feedUrl: '{feedUrl}'  // from the configuration object
 *          }]
 *      },
 *
 *      displayForm: ...
 *  });
 * </pre>
 * <p>You can instead choose to override the <code>→createView()</code> method if <code>→viewTemplate</code> does not
 * provide enough flexibility. It is usually a better solution to create a class (like
 * in the above example) and pass basic configurations to it rather than over-complicate
 * either the <code>→viewTemplate</code> or a custom <code>→createView()</code> method.</p>
 * @see #displayForm()
 * @see #createView()
 * @see #viewTemplate
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dashboard.Part.html Original Ext JS documentation of 'Ext.dashboard.Part'
 */
public class Part extends Base implements IFactoryable, IIdentifiable {
  /**
   * @param config @inheritDoc
   */
  public function Part(config:Part = null) {
    super();
  }

  /**
   * The <code>Dashboard</code> instance that owns this <code>part</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dashboard.Part.html#property-dashboard Original Ext JS documentation of 'dashboard'
   */
  public native function get dashboard():DashboardPanel;

  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The configuration object used for creating instances of this <code>Part</code>. This is
   * used by the <code>→createView()</code> method to create views.
   * @default {
   *     collapsed: '{collapsed}',
   *     columnIndex: '{columnIndex}',
   *     id: '{id}',
   *     title: '{title}',
   *     height: '{height}'
   * }
   * @see #createView()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dashboard.Part.html#cfg-viewTemplate Original Ext JS documentation of 'viewTemplate'
   * @see #getViewTemplate()
   * @see #setViewTemplate()
   */
  public native function get viewTemplate():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set viewTemplate(value:*):void;

  /**
   * This method is responsible for converting a configuration object from <code>→displayForm()</code>
   * into a "view" (an object that can be passed to <code>Ext.widget</code>).
   * <p>If you override this method it is recommended that you <code>callParent</code> to get the view
   * produced and then edit that result. This is because there are several private
   * properties placed on the returned configuration object.</p>
   * <pre>
   *  createView: function(config) {
   *      var view = this.callParent([config]);
   *
   *      // edit view
   *
   *      return view;
   *  }
   * </pre>
   * @since 5.0.0
   * @param config The object returned from <code>→displayForm()</code>.
   * @return The view configuration object.
   * @see #displayForm()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dashboard.Part.html#method-createView Original Ext JS documentation of 'createView'
   */
  protected native function createView(config:Object):Object;

  /**
   * This method should display an appropriate edit form (probably a modal <code>→ext.window.Window</code>
   * or <code>Ext.Msg.prompt</code>) to get or edit configuration for an instance of this part.
   * <p>See the class documentation for examples on implementing this method.</p>
   * @since 5.0.0
   * @param instance The already existing view or <code>null</code> if called to
   * configure a new instance.
   * @param currentConfig The configuration returned from this method for the
   * existing view (<code>instance</code>) or <code>null</code> if called to configure a new instance.
   * @param callback The function to call passing
   * <ul>
   * <li><code>config:Object</code> (optional) —
   * The configuration that defines the instance to be
   * created. This value is passed to <code>→createView()</code> and applied to the <code>→viewTemplate</code>.
   * </li>
   * </ul>
   * @param scope The scope with which to call the <code>callback</code>.
   * @see ext.window.Window
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dashboard.Part.html#method-displayForm Original Ext JS documentation of 'displayForm'
   * @see #createView()
   * @see #viewTemplate
   */
  public native function displayForm(instance:Component, currentConfig:Object, callback:Function, scope:Object):void;

  /**
   * @inheritDoc
   */
  public native function getId():String;

  /**
   * Returns the value of <code>viewTemplate</code>.
   * @see #viewTemplate
   */
  public native function getViewTemplate():*;

  /**
   * Sets the value of <code>viewTemplate</code>.
   * @param viewTemplate The new value.
   * @see #viewTemplate
   */
  public native function setViewTemplate(viewTemplate:*):void;
}
}