package ext.data {
import ext.mixin.IFactoryable;
import ext.mixin.Observable;
import ext.util.Collection;

[Native("Ext.data.AbstractStore", require)]
/**
 * @see ext.data.events.AbstractStore_store_records_indexEvent.ADD
 * @eventType ext.data.events.AbstractStore_store_records_indexEvent.ADD
 */
[Event(name='onAdd', type='ext.data.events.AbstractStore_store_records_indexEvent')]
/**
 * @see ext.data.events.AbstractStore_store_sortersEvent.BEFORE_SORT
 * @eventType ext.data.events.AbstractStore_store_sortersEvent.BEFORE_SORT
 */
[Event(name='onBeforeSort', type='ext.data.events.AbstractStore_store_sortersEvent')]
/**
 * @see ext.data.events.AbstractStoreEvent.BEGIN_UPDATE
 * @eventType ext.data.events.AbstractStoreEvent.BEGIN_UPDATE
 */
[Event(name='onBeginUpdate', type='ext.data.events.AbstractStoreEvent')]
/**
 * @see ext.data.events.AbstractStoreEvent.CLEAR
 * @eventType ext.data.events.AbstractStoreEvent.CLEAR
 */
[Event(name='onClear', type='ext.data.events.AbstractStoreEvent')]
/**
 * @see ext.data.events.AbstractStoreEvent.DATA_CHANGED
 * @eventType ext.data.events.AbstractStoreEvent.DATA_CHANGED
 */
[Event(name='onDataChanged', type='ext.data.events.AbstractStoreEvent')]
/**
 * @see ext.data.events.AbstractStoreEvent.END_UPDATE
 * @eventType ext.data.events.AbstractStoreEvent.END_UPDATE
 */
[Event(name='onEndUpdate', type='ext.data.events.AbstractStoreEvent')]
/**
 * @see ext.data.events.AbstractStoreEvent.REFRESH
 * @eventType ext.data.events.AbstractStoreEvent.REFRESH
 */
[Event(name='onRefresh', type='ext.data.events.AbstractStoreEvent')]
/**
 * @see ext.data.events.AbstractStore_store_records_index_isMoveEvent.REMOVE
 * @eventType ext.data.events.AbstractStore_store_records_index_isMoveEvent.REMOVE
 */
[Event(name='onRemove', type='ext.data.events.AbstractStore_store_records_index_isMoveEvent')]
/**
 * @see ext.data.events.AbstractStore_storeEvent.SORT
 * @eventType ext.data.events.AbstractStore_storeEvent.SORT
 */
[Event(name='onSort', type='ext.data.events.AbstractStore_storeEvent')]
/**
 * @see ext.data.events.AbstractStore_record_operation_modifiedFieldNames_detailsEvent.UPDATE
 * @eventType ext.data.events.AbstractStore_record_operation_modifiedFieldNames_detailsEvent.UPDATE
 */
[Event(name='onUpdate', type='ext.data.events.AbstractStore_record_operation_modifiedFieldNames_detailsEvent')]
/**
 * AbstractStore is a superclass of →<code>ext.data.ProxyStore</code> and →<code>ext.data.ChainedStore</code>.
 * It's never used directly, but offers a set of methods used by both of those subclasses.
 * <p>Unless you need to make a whole new type of Store, see →<code>ext.data.Store</code> instead.</p>
 * @see ext.data.ProxyStore
 * @see ext.data.ChainedStore
 * @see ext.data.Store
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html Original Ext JS documentation of 'Ext.data.AbstractStore'
 */
public class AbstractStore extends Observable implements IFactoryable {
  /**
   * @param config @inheritDoc
   */
  public function AbstractStore(config:AbstractStore = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * When a Store is used by only one →<code>ext.view.DataView</code>, and should only exist
   * for the lifetime of that view, then configure the autoDestroy flag as <code>true</code>. This
   * causes the destruction of the view to trigger the destruction of its Store.
   * @default undefined
   * @see ext.view.DataView
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#cfg-autoDestroy Original Ext JS documentation of 'autoDestroy'
   * @see #getAutoDestroy()
   * @see #setAutoDestroy()
   */
  public native function get autoDestroy():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set autoDestroy(value:Boolean):void;

  /**
   * The page that the Store has most recently loaded
   * (see →<code>ext.data.Store.loadPage()</code>)
   * @default 1
   * @see ext.data.Store#loadPage()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#property-currentPage Original Ext JS documentation of 'currentPage'
   */
  public native function get currentPage():Number;

  /**
   * @private
   */
  public native function set currentPage(value:Number):void;

  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Array of <i>Filters</i> (→<code>ext.util.Filter</code>) for this store. Can also be an array
   * of functions which will be used as the →<code>ext.util.Filter.filterFn</code>
   * config for filters:
   * <pre>
   * filters: [
   *     function(item) {
   *         return item.weight &gt; 0;
   *     }
   * ]
   * </pre>
   * <p>Individual filters can be specified as an <code>→ext.util.Filter</code> instance, a config
   * object for <code>→ext.util.Filter</code> or simply a function that will be wrapped in a
   * instance with its →<code>ext.util.Filter.filterFn</code> set.</p>
   * <p>If a <code>Collection</code> of filters is passed, its items (filters) will be added. Any
   * subsequent modification to the collection will have no affect.</p>
   * <p>For fine grain control of the filters collection, call <code>→getFilters()</code> to return
   * the <code>→ext.util.Collection</code> instance that holds this store's filters.</p>
   * <pre>
   *  var filters = store.getFilters(); // an Ext.util.FilterCollection
   *
   *  function legalAge (item) {
   *      return item.age &gt;= 21;
   *  }
   *
   *  filters.add(legalAge);
   *
   *  //...
   *
   *  filters.remove(legalAge);
   * </pre>
   * <p>Any changes to the <code>→filters</code> collection will cause this store to adjust
   * its items accordingly.</p>
   * @default null
   * @see ext.util.Filter
   * @see ext.util.Filter#filterFn
   * @see #getFilters()
   * @see ext.util.Collection
   * @see #filters
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#cfg-filters Original Ext JS documentation of 'filters'
   * @see #setFilters()
   */
  public native function get filters():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set filters(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The direction in which sorting should be applied when grouping. Supported values are
   * "ASC" and "DESC".
   * @default 'ASC'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#cfg-groupDir Original Ext JS documentation of 'groupDir'
   * @see #getGroupDir()
   * @see #setGroupDir()
   */
  public native function get groupDir():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set groupDir(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The field by which to group data in the store. Internally, grouping is very similar to
   * sorting - the groupField and →<code>groupDir</code> are injected as the first sorter
   * (see →<code>sort()</code>). Stores support a single level of grouping, and groups can be
   * fetched via the →<code>getGroups()</code> method.
   * @default undefined
   * @see #groupDir
   * @see #sort()
   * @see #getGroups()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#cfg-groupField Original Ext JS documentation of 'groupField'
   * @see #getGroupField()
   * @see #setGroupField()
   */
  public native function get groupField():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set groupField(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The grouper by which to group the data store. May also be specified by the
   * →<code>groupField</code> config, however
   * they should not be used together.
   * @default null
   * @see #groupField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#cfg-grouper Original Ext JS documentation of 'grouper'
   * @see #getGrouper()
   * @see #setGrouper()
   */
  public native function get grouper():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set grouper(value:*):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Store, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#property-isStore Original Ext JS documentation of 'isStore'
   */
  public native function get isStore():Boolean;

  /**
   * @private
   */
  public native function set isStore(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The number of records considered to form a 'page'. This is used to power the built-in
   * paging using the nextPage and previousPage functions when the grid is paged using a
   * →<code>ext.toolbar.PagingToolbar</code> Defaults to 25.
   * <p>To disable paging, set the pageSize to <code>0</code>.</p>
   * @default 25
   * @see ext.toolbar.PagingToolbar
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#cfg-pageSize Original Ext JS documentation of 'pageSize'
   * @see #getPageSize()
   * @see #setPageSize()
   */
  public native function get pageSize():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set pageSize(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Set this to <code>true</code> to trigger a reload when the last sorter is removed (only
   * applicable when →<code>remoteSort</code> is <code>true</code>).
   * <p>By default, the store reloads itself when a sorter is added or removed.</p>
   * <p>When the last sorter is removed, however, the assumption is that the data
   * does not need to become "unsorted", and so no reload is triggered.</p>
   * <p>If the server has a default order to which it reverts in the absence of any
   * sorters, then it is useful to set this config to <code>true</code>.</p>
   * @default false
   * @since 6.5.1
   * @see #remoteSort
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#cfg-reloadOnClearSorters Original Ext JS documentation of 'reloadOnClearSorters'
   * @see #getReloadOnClearSorters()
   * @see #setReloadOnClearSorters()
   */
  public native function get reloadOnClearSorters():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set reloadOnClearSorters(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to defer any filtering operation to the server. If <code>false</code>, filtering is done
   * locally on the client.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#cfg-remoteFilter Original Ext JS documentation of 'remoteFilter'
   * @see #getRemoteFilter()
   * @see #setRemoteFilter()
   */
  public native function get remoteFilter():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set remoteFilter(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> if the sorting should be performed on the server side, false if it is local only.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#cfg-remoteSort Original Ext JS documentation of 'remoteSort'
   * @see #getRemoteSort()
   * @see #setRemoteSort()
   */
  public native function get remoteSort():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set remoteSort(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The initial set of <i>Sorters</i> (→<code>ext.util.Sorter</code>)
   * <p>Individual sorters can be specified as an <code>→ext.util.Sorter</code> instance, a config
   * object for <code>→ext.util.Sorter</code> or simply the name of a property by which to sort.</p>
   * <p>An alternative way to extend the sorters is to call the <code>sort</code> method and pass
   * a property or sorter config to add to the sorters.</p>
   * <p>For fine grain control of the sorters collection, call <code>→getSorters()</code> to return
   * the <code>→ext.util.Collection</code> instance that holds this collection's sorters.</p>
   * <pre>
   *  var sorters = store.getSorters(); // an Ext.util.SorterCollection
   *
   *  sorters.add('name');
   *
   *  //...
   *
   *  sorters.remove('name');
   * </pre>
   * <p>Any changes to the <code>→sorters</code> collection will cause this store to adjust
   * its items accordingly.</p>
   * @default null
   * @see ext.util.Sorter
   * @see #getSorters()
   * @see ext.util.Collection
   * @see #sorters
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#cfg-sorters Original Ext JS documentation of 'sorters'
   * @see #setSorters()
   */
  public native function get sorters():Array;

  [ExtConfig]
  [Bindable]
  [ArrayElementType("ext.util.Sorter")]
  /**
   * @private
   */
  public native function set sorters(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * Configure as <code>true</code> to have the filters saved when a client <i>grid</i> (→<code>ext.grid.GridPanel</code>)
   * saves its state.
   * @default false
   * @see ext.grid.GridPanel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#cfg-statefulFilters Original Ext JS documentation of 'statefulFilters'
   * @see #getStatefulFilters()
   * @see #setStatefulFilters()
   */
  public native function get statefulFilters():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set statefulFilters(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Unique identifier for this store. If present, this Store will be registered with the
   * →<code>ext.data.StoreManager</code>, making it easy to reuse elsewhere.
   * <p>Note that when a store is instantiated by a Controller, the storeId will default
   * to the name of the store if not specified in the class.</p>
   * @see ext.data.#StoreManager ext.data.StoreManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#cfg-storeId Original Ext JS documentation of 'storeId'
   * @see #getStoreId()
   * @see #setStoreId()
   */
  public native function get storeId():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set storeId(value:String):void;

  /**
   * A counter that is increased by <code>→beginUpdate()</code> and decreased by <code>→endUpdate()</code>. When
   * this transitions from 0 to 1 the <code>→event:onBeginUpdate</code> event is
   * fired. When it transitions back from 1 to 0 the <code>→event:onEndUpdate</code>
   * event is fired.
   * @default 0
   * @since 5.0.0
   * @see #beginUpdate()
   * @see #endUpdate()
   * @see #event:onBeginUpdate
   * @see #event:onEndUpdate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#property-updating Original Ext JS documentation of 'updating'
   */
  public native function get updating():Number;

  /**
   * Adds a new Filter to this Store's <i>filter set</i> (→<code>filters</code>) and
   * by default, applies the updated filter set to the Store's unfiltered dataset.
   * @param filters The set of filters to add to the current
   * <i>filter set</i> (→<code>filters</code>).
   * @param suppressEvent If <code>true</code> the filter is cleared silently.
   * @see #filters
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-addFilter Original Ext JS documentation of 'addFilter'
   */
  public native function addFilter(filters:*, suppressEvent:Boolean = false):void;

  /**
   * This method may be called to indicate the start of multiple changes to the store.
   * <p>Automatic synchronization as configured by the →<code>ext.data.ProxyStore.autoSync</code>
   * flag is deferred until the →<code>endUpdate()</code> method is called, so multiple mutations can be
   * coalesced into one synchronization operation.</p>
   * <p>Internally this method increments a counter that is decremented by <code>→endUpdate()</code>. It
   * is important, therefore, that if you call <code>→beginUpdate()</code> directly you match that
   * call with a call to <code>→endUpdate()</code> or you will prevent the collection from updating
   * properly.</p>
   * <p>For example:</p>
   * <pre>
   *  var store = Ext.StoreManager.lookup({
   *      //...
   *      autoSync: true
   *  });
   *
   *  store.beginUpdate();
   *
   *  record.set('fieldName', 'newValue');
   *
   *  store.add(item);
   *  // ...
   *
   *  store.insert(index, otherItem);
   *  //...
   *
   *  // Interested parties will listen for the endupdate event
   *  store.endUpdate();
   * </pre>
   * @since 5.0.0
   * @see ext.data.ProxyStore#autoSync
   * @see #endUpdate()
   * @see #beginUpdate()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-beginUpdate Original Ext JS documentation of 'beginUpdate'
   */
  public native function beginUpdate():void;

  /**
   * Reverts to a view of the Record cache with no filtering applied.
   * @param suppressEvent If <code>true</code> the filter is cleared silently.
   * <p>For a locally filtered Store, this means that the filter collection is cleared without
   * firing the →<code>event:onDataChanged</code> event.</p>
   * <p>For a remotely filtered Store, this means that the filter collection is cleared, but
   * the store is not reloaded from the server.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-clearFilter Original Ext JS documentation of 'clearFilter'
   * @see #event:onDataChanged
   */
  public native function clearFilter(suppressEvent:Boolean = false):void;

  /**
   * Clear the store grouping
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-clearGrouping Original Ext JS documentation of 'clearGrouping'
   */
  public native function clearGrouping():void;

  /**
   * Checks if a record is in the current active data set.
   * @param record The record
   * @return <code>true</code> if the record is in the current active data set.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-contains Original Ext JS documentation of 'contains'
   */
  public native function contains(record:Model):Boolean;

  /**
   * Create a <code>Range</code> instance to access records by their index.
   * @since 6.5.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-createActiveRange Original Ext JS documentation of 'createActiveRange'
   */
  public native function createActiveRange(config:* = undefined):DataRange;

  /**
   * Perform the Store destroying sequence. Override this method to add destruction
   * behaviors to your custom Stores.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#property-doDestroy Original Ext JS documentation of 'doDestroy'
   */
  protected native function doDestroy():void;

  /**
   * This method is called after modifications are complete on a store. For details
   * see <code>→beginUpdate()</code>.
   * @since 5.0.0
   * @see #beginUpdate()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-endUpdate Original Ext JS documentation of 'endUpdate'
   */
  public native function endUpdate():void;

  /**
   * Filters the data in the Store by one or more fields. Example usage:
   * <pre>
   * //filter with a single field
   * myStore.filter('firstName', 'Don');
   *
   * //filtering with multiple filters
   * myStore.filter([
   *     {
   *         property : 'firstName',
   *         value    : 'Don'
   *     },
   *     {
   *         property : 'lastName',
   *         value    : 'Griffin'
   *     }
   * ]);
   * </pre>
   * <p>Internally, Store converts the passed arguments into an array of
   * →<code>ext.util.Filter</code> instances, and delegates the actual filtering to its internal
   * →<code>ext.util.Collection</code> or the remote server.</p>
   * @param filters Either a string name of one of the
   * fields in this Store's configured →<code>ext.data.Model</code>, or an array of
   * filter configurations.
   * @param value The property value by which to filter. Only applicable if
   * <code>→filters</code> is a string.
   * @see ext.util.Filter
   * @see ext.util.Collection
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-filter Original Ext JS documentation of 'filter'
   * @see ext.data.Model
   * @see #filters
   */
  public native function filter(filters:* = undefined, value:String = null):void;

  /**
   * Filters by a function. The specified function will be called for each
   * Record in this Store. If the function returns <code>true</code> the Record is included,
   * otherwise it is filtered out.
   * <p>When store is filtered, most of the methods for accessing store data will be working only
   * within the set of filtered records. The notable exception is →<code>getById()</code>.</p>
   * @param fn The function to be called. It will be passed the following parameters:
   * <ul>
   * <li><code>record:ext.data.Model</code> (optional) —
   * The record to test for filtering. Access field values
   * using →<code>ext.data.Model.get()</code>.
   * </li>
   * </ul>
   * @param scope The scope (this reference) in which the function is executed.
   * Defaults to this Store.
   * @see #getById()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-filterBy Original Ext JS documentation of 'filterBy'
   * @see ext.data.Model#get()
   */
  public native function filterBy(fn:Function, scope:Object = null):void;

  /**
   * Finds the index of the first matching Record in this store by a specific field value.
   * <p>When store is filtered, finds records only within filter.</p>
   * <p><b>IMPORTANT</b></p>
   * <p><b>If this store is <i>Buffered</i> (→<code>ext.data.BufferedStore</code>), this can ONLY find records
   * which happen to be cached in the page cache. This will be parts of the dataset around the
   * currently visible zone, or recently visited zones if the pages have not yet been purged from
   * the cache.</b></p>
   * @param property The name of the Record field to test.
   * @param value Either a string that the field value
   * should begin with, or a RegExp to test against the field.
   * @param startIndex The index to start searching at
   * @default 0
   * @param anyMatch True to match any part of the string, not just the
   * beginning.
   * @default false
   * @param caseSensitive True for case sensitive comparison
   * @default false
   * @param exactMatch True to force exact match (^ and $ characters
   * added to the regex). Ignored if <code>anyMatch</code> is <code>true</code>.
   * @default false
   * @return The matched index or -1
   * @see ext.data.BufferedStore
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-find Original Ext JS documentation of 'find'
   */
  public native function find(property:String, value:*, startIndex:Number = 0, anyMatch:Boolean = false, caseSensitive:Boolean = false, exactMatch:Boolean = false):Number;

  /**
   * Find the index of the first matching Record in this Store by a function.
   * If the function returns <code>true</code> it is considered a match.
   * <p>When store is filtered, finds records only within filter.</p>
   * <p><b>IMPORTANT</b></p>
   * <p><b>If this store is <i>Buffered</i> (→<code>ext.data.BufferedStore</code>), this can ONLY find records which
   * happen to be cached in the page cache. This will be parts of the dataset around the
   * currently visible zone, or recently visited zones if the pages have not yet been purged
   * from the cache.</b></p>
   * @param fn The function to be called. It will be passed the following parameters:
   * <ul>
   * <li><code>record:ext.data.Model</code> (optional) —
   * The record to test for filtering. Access field values
   * using →<code>ext.data.Model.get()</code>.
   * </li>
   * <li><code>id:Object</code> (optional) —
   * The ID of the Record passed.
   * </li>
   * </ul>
   * @param scope The scope (this reference) in which the function is executed.
   * Defaults to this Store.
   * @param start The index at which to start searching.
   * @default 0
   * @return The matched index or -1
   * @see ext.data.BufferedStore
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-findBy Original Ext JS documentation of 'findBy'
   * @see ext.data.Model#get()
   */
  public native function findBy(fn:Function, scope:Object = null, start:Number = 0):Number;

  /**
   * Finds the index of the first matching Record in this store by a specific field value.
   * <p>When store is filtered, finds records only within filter.</p>
   * <p><b>IMPORTANT</b></p>
   * <p><b>If this store is <i>Buffered</i> (→<code>ext.data.BufferedStore</code>), this can ONLY find records which
   * happen to be cached in the page cache. This will be parts of the dataset around the
   * currently visible zone, or recently visited zones if the pages have not yet been purged
   * from the cache.</b></p>
   * @param fieldName The name of the Record field to test.
   * @param value The value to match the field against.
   * @param startIndex The index to start searching at
   * @default 0
   * @return The matched index or -1
   * @see ext.data.BufferedStore
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-findExact Original Ext JS documentation of 'findExact'
   */
  public native function findExact(fieldName:String, value:*, startIndex:Number = 0):Number;

  /**
   * Finds the first matching Record in this store by a specific field value.
   * <p>When store is filtered, finds records only within filter.</p>
   * <p><b>IMPORTANT</b></p>
   * <p><b>If this store is <i>Buffered</i> (→<code>ext.data.BufferedStore</code>), this can ONLY find records which
   * happen to be cached in the page cache. This will be parts of the dataset around the
   * currently visible zone, or recently visited zones if the pages have not yet been purged
   * from the cache.</b></p>
   * @param fieldName The name of the Record field to test.
   * @param value Either a string that the field value
   * should begin with, or a RegExp to test against the field.
   * @param startIndex The index to start searching at
   * @default 0
   * @param anyMatch True to match any part of the string, not just the
   * beginning.
   * @default false
   * @param caseSensitive True for case sensitive comparison
   * @default false
   * @param exactMatch True to force exact match (^ and $ characters
   * added to the regex). Ignored if <code>anyMatch</code> is <code>true</code>.
   * @default false
   * @return The matched record or null
   * @see ext.data.BufferedStore
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-findRecord Original Ext JS documentation of 'findRecord'
   */
  public native function findRecord(fieldName:String, value:*, startIndex:Number = 0, anyMatch:Boolean = false, caseSensitive:Boolean = false, exactMatch:Boolean = false):Model;

  /**
   * Get the Record at the specified index.
   * <p>The index is effected by filtering.</p>
   * @param index The index of the Record to find.
   * @return The Record at the passed index. Returns null if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-getAt Original Ext JS documentation of 'getAt'
   */
  public native function getAt(index:Number):Model;

  /**
   * Returns the value of <code>autoDestroy</code>.
   * @see #autoDestroy
   */
  public native function getAutoDestroy():Boolean;

  /**
   * Get the Record with the specified id.
   * <p>This method is not affected by filtering, lookup will be performed from all records
   * inside the store, filtered or not.</p>
   * @param id The id of the Record to find.
   * @return The Record with the passed id. Returns null if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-getById Original Ext JS documentation of 'getById'
   */
  public native function getById(id:*):Model;

  /**
   * Gets the number of records in store.
   * <p>If using paging, this may not be the total size of the dataset. If the data object used by
   * the Reader contains the dataset size, then the →<code>ext.data.ProxyStore.getTotalCount()</code>
   * function returns the dataset size. <b>Note</b>: see the Important note in
   * →<code>ext.data.ProxyStore.load()</code>.</p>
   * <p>When store is filtered, it's the number of records matching the filter.</p>
   * @return The number of Records in the Store.
   * @see ext.data.ProxyStore#getTotalCount()
   * @see ext.data.ProxyStore#load()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-getCount Original Ext JS documentation of 'getCount'
   */
  public native function getCount():Number;

  /**
   * Returns the value of <code>filters</code>.
   * @see #filters
   */
  public native function getFilters(autoCreate:Boolean = false):Collection;

  /**
   * Returns the value of <code>groupDir</code>.
   * @see #groupDir
   */
  public native function getGroupDir():String;

  /**
   * Returns the value of <code>groupField</code>.
   * @see #groupField
   */
  public native function getGroupField():String;

  /**
   * Returns the value of <code>grouper</code>.
   * @see #grouper
   */
  public native function getGrouper():*;

  /**
   * Returns a collection of readonly sub-collections of your store's records
   * with grouping applied. These sub-collections are maintained internally by
   * the collection.
   * <p>See →<code>groupField</code>, →<code>groupDir</code>. Example for a store
   * containing records with a color field:</p>
   * <pre>
   * var myStore = Ext.create('Ext.data.Store', {
   *     groupField: 'color',
   *     groupDir  : 'DESC'
   * });
   *
   * myStore.getGroups();
   * </pre>
   * <p>The above should result in the following format:</p>
   * <pre>
   * [
   *     {
   *         name: 'yellow',
   *         children: [
   *             // all records where the color field is 'yellow'
   *         ]
   *     },
   *     {
   *         name: 'red',
   *         children: [
   *             // all records where the color field is 'red'
   *         ]
   *     }
   * ]
   * </pre>
   * <p>Group contents are affected by filtering.</p>
   * @return The grouped data
   * @see #groupField
   * @see #groupDir
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-getGroups Original Ext JS documentation of 'getGroups'
   */
  public native function getGroups():Collection;

  /**
   * Returns the value of <code>pageSize</code>.
   * @see #pageSize
   */
  public native function getPageSize():Number;

  [ArrayElementType("ext.data.Model")]
  /**
   * Gathers a range of Records between specified indices.
   * <p>This method is affected by filtering.</p>
   * @param start The starting index. Defaults to zero.
   * @param end The ending index. Defaults to the last record. The end index
   * <b>is included</b>.
   * @return An array of records.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-getRange Original Ext JS documentation of 'getRange'
   */
  public native function getRange(start:Number = 0, end:Number = NaN):Array;

  /**
   * Returns the value of <code>reloadOnClearSorters</code>.
   * @see #reloadOnClearSorters
   */
  public native function getReloadOnClearSorters():Boolean;

  /**
   * Returns the value of <code>remoteFilter</code>.
   * @see #remoteFilter
   */
  public native function getRemoteFilter():Boolean;

  /**
   * Returns the value of <code>remoteSort</code>.
   * @see #remoteSort
   */
  public native function getRemoteSort():Boolean;

  /**
   * Returns the value of <code>sorters</code>.
   * @see #sorters
   */
  public native function getSorters(autoCreate:Boolean = false):Collection;

  /**
   * Returns the value of <code>statefulFilters</code>.
   * @see #statefulFilters
   */
  public native function getStatefulFilters():Boolean;

  /**
   * Returns the value of <code>storeId</code>.
   * @see #storeId
   */
  public native function getStoreId():String;

  /**
   * Groups data inside the store.
   * @param grouper Either a string name of one of the fields in this Store's
   * configured →<code>ext.data.Model</code>, or an object, or a <i>grouper</i> (→<code>ext.util.Grouper</code>)
   * configuration object.
   * @param direction The overall direction to group the data by. Defaults to the
   * value of →<code>groupDir</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-group Original Ext JS documentation of 'group'
   * @see ext.data.Model
   * @see ext.util.Grouper
   * @see #groupDir
   */
  public native function group(grouper:*, direction:String = null):void;

  /**
   * Tests whether the store currently has any active filters.
   * @return <code>true</code> if the store is filtered.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-isFiltered Original Ext JS documentation of 'isFiltered'
   */
  public native function isFiltered():Boolean;

  /**
   * Tests whether the store currently has an active grouper.
   * @return <code>true</code> if the store is grouped.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-isGrouped Original Ext JS documentation of 'isGrouped'
   */
  public native function isGrouped():Boolean;

  /**
   * Returns <code>true</code> if the Store has been loaded.
   * @return <code>true</code> if the Store has been loaded.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-isLoaded Original Ext JS documentation of 'isLoaded'
   */
  public native function isLoaded():Boolean;

  /**
   * Returns <code>true</code> if the Store is currently performing a load operation.
   * @return <code>true</code> if the Store is currently loading.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-isLoading Original Ext JS documentation of 'isLoading'
   */
  public native function isLoading():Boolean;

  /**
   * Tests whether the store currently has any active sorters.
   * @return <code>true</code> if the store is sorted.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-isSorted Original Ext JS documentation of 'isSorted'
   */
  public native function isSorted():Boolean;

  /**
   * Removes an individual Filter from the current <i>filter set</i> (→<code>filters</code>)
   * using the passed Filter/Filter id and by default, applies the updated filter set
   * to the Store's unfiltered dataset.
   * @param toRemove The id of a Filter to remove from the
   * filter set, or a Filter instance to remove.
   * @param suppressEvent If <code>true</code> the filter is cleared silently.
   * @see #filters
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-removeFilter Original Ext JS documentation of 'removeFilter'
   */
  public native function removeFilter(toRemove:*, suppressEvent:Boolean = false):void;

  /**
   * Sets the value of <code>autoDestroy</code>.
   * @param autoDestroy The new value.
   * @see #autoDestroy
   */
  public native function setAutoDestroy(autoDestroy:Boolean):void;

  /**
   * Sets the value of <code>filters</code>.
   * @param filters The new value.
   * @see #filters
   */
  public native function setFilters(filters:*):void;

  /**
   * Sets the value of <code>groupDir</code>.
   * @param groupDir The new value.
   * @see #groupDir
   */
  public native function setGroupDir(groupDir:String):void;

  /**
   * Sets the value of <code>groupField</code>.
   * @param groupField The new value.
   * @see #groupField
   */
  public native function setGroupField(groupField:String):void;

  /**
   * Sets the value of <code>grouper</code>.
   * @param grouper The new value.
   * @see #grouper
   */
  public native function setGrouper(grouper:*):void;

  /**
   * Sets the value of <code>pageSize</code>.
   * @param pageSize The new value.
   * @see #pageSize
   */
  public native function setPageSize(pageSize:Number):void;

  /**
   * Sets the value of <code>reloadOnClearSorters</code>.
   * @param reloadOnClearSorters The new value.
   * @see #reloadOnClearSorters
   */
  public native function setReloadOnClearSorters(reloadOnClearSorters:Boolean):void;

  /**
   * Sets the value of <code>remoteFilter</code>.
   * @param remoteFilter The new value.
   * @see #remoteFilter
   */
  public native function setRemoteFilter(remoteFilter:Boolean):void;

  /**
   * Sets the value of <code>remoteSort</code>.
   * @param remoteSort The new value.
   * @see #remoteSort
   */
  public native function setRemoteSort(remoteSort:Boolean):void;

  /**
   * Sets the value of <code>sorters</code>.
   * @param sorters The new value.
   * @see #sorters
   */
  public native function setSorters(sorters:*):void;

  /**
   * Sets the value of <code>statefulFilters</code>.
   * @param statefulFilters The new value.
   * @see #statefulFilters
   */
  public native function setStatefulFilters(statefulFilters:Boolean):void;

  /**
   * Sets the value of <code>storeId</code>.
   * @param storeId The new value.
   * @see #storeId
   */
  public native function setStoreId(storeId:String):void;

  /**
   * Sorts the data in the Store by one or more of its properties. Example usage:
   * <pre>
   * //sort by a single field
   * myStore.sort('myField', 'DESC');
   *
   * //sorting by multiple fields
   * myStore.sort([
   *     {
   *         property : 'age',
   *         direction: 'ASC'
   *     },
   *     {
   *         property : 'name',
   *         direction: 'DESC'
   *     }
   * ]);
   * </pre>
   * <p>Internally, Store converts the passed arguments into an array of →<code>ext.util.Sorter</code>
   * instances, and either delegates the actual sorting to its internal
   * →<code>ext.util.Collection</code> or the remote server.</p>
   * <p>When passing a single string argument to sort, Store maintains a ASC/DESC toggler per field,
   * so this code:</p>
   * <pre>
   * store.sort('myField');
   * store.sort('myField');
   * </pre>
   * <p>Is equivalent to this code, because Store handles the toggling automatically:</p>
   * <pre>
   * store.sort('myField', 'ASC');
   * store.sort('myField', 'DESC');
   * </pre>
   * @param field Either a string name of one of the
   * fields in this Store's configured →<code>ext.data.Model</code>, or an array of
   * sorter configurations.
   * @param direction The overall direction to sort the data by.
   * @default "ASC"
   * @param mode
   * @default "replace"
   * @see ext.util.Sorter
   * @see ext.util.Collection
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.AbstractStore.html#method-sort Original Ext JS documentation of 'sort'
   * @see ext.data.Model
   */
  public native function sort(field:* = undefined, direction:String = "ASC", mode:String = "replace"):void;
}
}