package ext.data {

[Native("Ext.data.ArrayStore", require)]
/**
 * Small helper class to make creating →<code>ext.data.Store</code>s from Array data easier. An
 * ArrayStore will be automatically configured with a →<code>ext.data.reader.ArrayReader</code>.
 * <p>A store configuration would be something like:</p>
 * <pre>
 * var store = Ext.create('Ext.data.ArrayStore', {
 *     // store configs
 *     storeId: 'myStore',
 *     // reader configs
 *     fields: [
 *        'company',
 *        {name: 'price', type: 'float'},
 *        {name: 'change', type: 'float'},
 *        {name: 'pctChange', type: 'float'},
 *        {name: 'lastChange', type: 'date', dateFormat: 'n/j h:ia'}
 *     ]
 * });
 * </pre>
 * <p>This store is configured to consume a returned object of the form:</p>
 * <pre>
 * var myData = [
 *     ['3m Co',71.72,0.02,0.03,'9/1 12:00am'],
 *     ['Alcoa Inc',29.01,0.42,1.47,'9/1 12:00am'],
 *     ['Boeing Co.',75.43,0.53,0.71,'9/1 12:00am'],
 *     ['Hewlett-Packard Co.',36.53,-0.03,-0.08,'9/1 12:00am'],
 *     ['Wal-Mart Stores, Inc.',45.45,0.73,1.63,'9/1 12:00am']
 * ];
 * </pre>
 * <p>An object literal of this form could also be used as the →<code>data</code> config option.</p>
 * @see ext.data.Store
 * @see ext.data.reader.ArrayReader
 * @see #data
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ArrayStore.html Original Ext JS documentation of 'Ext.data.ArrayStore'
 */
public class ArrayStore extends Store {
  /**
   * @param config @inheritDoc
   */
  public function ArrayStore(config:ArrayStore = null) {
    super();
  }
}
}