package ext.data {
import ext.data.operation.Operation;
import ext.mixin.Observable;

[Native("Ext.data.Batch", require)]
/**
 * @see ext.data.events.Batch_operationEvent.COMPLETE
 * @eventType ext.data.events.Batch_operationEvent.COMPLETE
 */
[Event(name='onComplete', type='ext.data.events.Batch_operationEvent')]
/**
 * @see ext.data.events.Batch_operationEvent.EXCEPTION
 * @eventType ext.data.events.Batch_operationEvent.EXCEPTION
 */
[Event(name='onException', type='ext.data.events.Batch_operationEvent')]
/**
 * @see ext.data.events.Batch_operationEvent.OPERATION_COMPLETE
 * @eventType ext.data.events.Batch_operationEvent.OPERATION_COMPLETE
 */
[Event(name='onOperationComplete', type='ext.data.events.Batch_operationEvent')]
/**
 * Provides a mechanism to run one or more <i>operations</i> (→<code>ext.data.operation.Operation</code>)
 * in a given order. Fires the <code>→event:onOperationComplete</code> event after the completion of each
 * Operation, and the <code>complete</code> event when all Operations have been successfully executed.
 * Fires an <code>exception</code> event if any of the Operations encounter an exception.
 * <p>Usually these are only used internally by →<code>ext.data.proxy.DataProxy</code> classes.</p>
 * @see ext.data.operation.Operation
 * @see #event:onOperationComplete
 * @see ext.data.proxy.DataProxy
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html Original Ext JS documentation of 'Ext.data.Batch'
 */
public class Batch extends Observable {
  /**
   * Creates new Batch object.
   * @param config Config object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Batch(config:Batch = null) {
    super();
  }

  [ArrayElementType("ext.data.operation.Operation")]
  /**
   * Ordered array of operations that raised an exception during the most recent
   * batch execution and did not successfully complete
   * @default []
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#property-exceptions Original Ext JS documentation of 'exceptions'
   */
  public native function get exceptions():Array;

  /**
   * @private
   */
  public native function set exceptions(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * True to pause the execution of the batch if any operation encounters an exception
   * (defaults to false). If you set this to true you are responsible for implementing
   * the appropriate handling logic and restarting or discarding the batch as needed.
   * There are different ways you could do this, e.g. by handling the batch's
   * →<code>event:onException</code> event directly, or perhaps by overriding
   * →<code>ext.data.ProxyStore.onBatchException()</code> at the store level.
   * If you do pause and attempt to handle the exception you can call →<code>retry()</code> to
   * process the same operation again.
   * <p>Note that <i>operations</i> (→<code>ext.data.operation.Operation</code>) are atomic, so any operations
   * that may have succeeded prior to an exception (and up until pausing the batch) will be
   * finalized at the server level and will not be automatically reversible. Any transactional
   * / rollback behavior that might be desired would have to be implemented at the application
   * level. Pausing on exception will likely be most beneficial when used in coordination with
   * such a scheme, where an exception might actually affect subsequent operations in the same
   * batch and so should be handled before continuing with the next operation.</p>
   * <p>If you have not implemented transactional operation handling then this option should
   * typically be left to the default of false (e.g. process as many operations as possible,
   * and handle any exceptions asynchronously without holding up the rest of the batch).</p>
   * @default false
   * @see #event:onException
   * @see ext.data.ProxyStore#onBatchException()
   * @see #retry()
   * @see ext.data.operation.Operation
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#cfg-pauseOnException Original Ext JS documentation of 'pauseOnException'
   * @see #getPauseOnException()
   * @see #setPauseOnException()
   */
  public native function get pauseOnException():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set pauseOnException(value:Boolean):void;

  /**
   * Adds a new operation to this batch at the end of the →<code>operations</code> array
   * @param operation The →<code>ext.data.operation.Operation</code> object or an array of operations.
   * @return this
   * @see #operations
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#method-add Original Ext JS documentation of 'add'
   * @see ext.data.operation.Operation
   */
  public native function add(operation:*):Batch;

  /**
   * Gets the currently running operation. Will return null if the batch has
   * not started or is completed.
   * @return The operation
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#method-getCurrent Original Ext JS documentation of 'getCurrent'
   */
  public native function getCurrent():Operation;

  [ArrayElementType("ext.data.operation.Operation")]
  /**
   * Gets any operations that have returned without success in this batch.
   * @return The exceptions
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#method-getExceptions Original Ext JS documentation of 'getExceptions'
   */
  public native function getExceptions():Array;

  [ArrayElementType("ext.data.operation.Operation")]
  /**
   * Gets the operations for this batch.
   * @return The operations.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#method-getOperations Original Ext JS documentation of 'getOperations'
   */
  public native function getOperations():Array;

  /**
   * Returns the value of <code>pauseOnException</code>.
   * @see #pauseOnException
   */
  public native function getPauseOnException():Boolean;

  /**
   * Gets the total number of operations in this batch.
   * @return The total
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#method-getTotal Original Ext JS documentation of 'getTotal'
   */
  public native function getTotal():Number;

  /**
   * Checks if this batch has any exceptions.
   * @return <code>true</code> if this batch has any exceptions.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#method-hasException Original Ext JS documentation of 'hasException'
   */
  public native function hasException():Boolean;

  /**
   * Checks if this batch is complete.
   * @return <code>true</code> if this batch is complete.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#method-isComplete Original Ext JS documentation of 'isComplete'
   */
  public native function isComplete():Boolean;

  /**
   * Checks if this batch is running.
   * @return <code>true</code> if this batch is running.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#method-isRunning Original Ext JS documentation of 'isRunning'
   */
  public native function isRunning():Boolean;

  /**
   * Pauses execution of the batch, but does not cancel the current operation
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#method-pause Original Ext JS documentation of 'pause'
   */
  public native function pause():Batch;

  /**
   * Kicks off execution of the batch, continuing from the current operation. This is intended
   * for restarting a <i>paused</i> (→<code>pause()</code>) batch after an exception, and the operation that
   * raised the exception will now be retried. The batch will then continue with its normal
   * processing until all operations are complete or another exception is encountered.
   * <p>Note that if the batch is already running any call to retry will be ignored.</p>
   * @return this
   * @see #pause()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#method-retry Original Ext JS documentation of 'retry'
   */
  public native function retry():Batch;

  /**
   * Sets the value of <code>pauseOnException</code>.
   * @param pauseOnException The new value.
   * @see #pauseOnException
   */
  public native function setPauseOnException(pauseOnException:Boolean):void;

  /**
   * Sorts the <code>operations (→ext.data.operation.Operation)</code> based on their type and
   * the foreign key dependencies of the entities. Consider a simple Parent and Child
   * case where the Child has a "parentId" field. If this batch contains two <code>→create()</code>
   * operations, one of a Parent and one for its Child, the server must receive and
   * process the <code>→create()</code> of the Parent before the Child can be created.
   * <p>In the case of <code>→destroy()</code> operations this order is reversed. The Child entity must be
   * destroyed before the Parent to avoid any foreign key constraints (a Child with an
   * invalid parentId field).</p>
   * <p>Further, <code>→create()</code> operations must all occur before <code>update</code> operations to ensure
   * that all entities exist that might be now referenced by the updates. The created
   * entities can safely reference already existing entities.</p>
   * <p>Finally, <code>→destroy()</code> operations are sorted after <code>update</code> operations to allow those
   * updates to remove references to the soon-to-be-deleted entities.</p>
   * @see ext.data.operation.Operation
   * @see #create()
   * @see #destroy()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#method-sort Original Ext JS documentation of 'sort'
   */
  public native function sort():void;

  /**
   * Kicks off execution of the batch, continuing from the next operation if the previous
   * operation encountered an exception, or if execution was paused. Use this method to start
   * the batch for the first time or to restart a paused batch by skipping the current
   * unsuccessful operation.
   * <p>To retry processing the current operation before continuing to the rest of the batch (e.g.
   * because you explicitly handled the operation's exception), call →<code>retry()</code> instead.</p>
   * <p>Note that if the batch is already running any call to start will be ignored.</p>
   * @return this
   * @see #retry()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Batch.html#method-start Original Ext JS documentation of 'start'
   */
  public native function start():Batch;
}
}