package ext.data {

[Native("Ext.data.BufferedStore", require)]
/**
 * A BufferedStore maintains a sparsely populated map of pages corresponding to an extremely large
 * server-side dataset.
 * <p><b>Note:</b> Buffered Stores are not available in the modern toolkit. Instead use
 * <code>→ext.data.virtual.VirtualStore</code>.</p>
 * <p>Use a BufferedStore when the dataset size is so large that the database and network latency,
 * and client memory requirements preclude caching the entire dataset in a regular
 * →<code>ext.data.Store</code>.</p>
 * <p>When using a BufferedStore <i>not all of the dataset is present in the client</i>. Only pages which
 * have been requested by the UI (usually a →<code>ext.grid.GridPanel</code>) and surrounding pages
 * will be present. Retention of viewed pages in the BufferedStore after they have been scrolled
 * out of view is configurable. See →<code>leadingBufferZone</code>, →<code>trailingBufferZone</code> and
 * →<code>purgePageCount</code>.</p>
 * <p>To use a BufferedStore, initiate the loading process by loading the first page. The number of
 * rows rendered are determined automatically, and the range of pages needed to keep the cache
 * primed for scrolling is requested and cached.
 * Example:</p>
 * <pre>
 * myBufferedStore.loadPage(1); // Load page 1
 * </pre>
 * <p>A →<code>null</code> is instantiated which will monitor
 * the scrolling in the grid, and refresh the view's rows from the page cache as needed. It will
 * also pull new data into the page cache when scrolling of the view draws upon data near either
 * end of the prefetched data.</p>
 * <p>The margins which trigger view refreshing from the prefetched data are
 * →<code>null.numFromEdge</code>,
 * →<code>null.leadingBufferZone</code>, and
 * →<code>null.trailingBufferZone</code>.</p>
 * <p>The margins which trigger loading more data into the page cache are, →<code>leadingBufferZone</code>
 * and →<code>trailingBufferZone</code>.</p>
 * <p>By default, only 5 pages of data (in addition to the pages which over the visible region) are
 * cached in the page cache, with old pages being evicted from the cache as the view moves down
 * through the dataset. This is controlled by the →<code>purgePageCount</code> setting.</p>
 * <p>Setting this value to zero means that no pages are <i>ever</i> scrolled out of the page cache, and
 * that eventually the whole dataset may become present in the page cache. This is sometimes
 * desirable as long as datasets do not reach astronomical proportions.</p>
 * <p>Selection state may be maintained across page boundaries by configuring the SelectionModel
 * not to discard records from its collection when those Records cycle out of the Store's primary
 * collection. This is done by configuring the SelectionModel like this:</p>
 * <pre>
 * selModel: {
 *     pruneRemoved: false
 * }
 * </pre>
 * @see ext.data.virtual.VirtualStore
 * @see ext.data.Store
 * @see ext.grid.GridPanel
 * @see #leadingBufferZone
 * @see #trailingBufferZone
 * @see #purgePageCount
 * @see null
 * @see null#numFromEdge
 * @see null#leadingBufferZone
 * @see null#trailingBufferZone
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html Original Ext JS documentation of 'Ext.data.BufferedStore'
 */
public class BufferedStore extends ProxyStore {
  /**
   * @param config @inheritDoc
   */
  public function BufferedStore(config:BufferedStore = null) {
    super();
  }

  /**
   * <code>true</code> in this class to identify an object as an instantiated BufferedStore, or subclass
   * thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#property-isBufferedStore Original Ext JS documentation of 'isBufferedStore'
   */
  public native function get isBufferedStore():Boolean;

  /**
   * @private
   */
  public native function set isBufferedStore(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The number of extra rows to keep cached on the leading side of scrolling
   * buffer as scrolling proceeds. A larger number means fewer replenishments from
   * the server.
   * @default 200
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#cfg-leadingBufferZone Original Ext JS documentation of 'leadingBufferZone'
   * @see #getLeadingBufferZone()
   * @see #setLeadingBufferZone()
   */
  public native function get leadingBufferZone():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set leadingBufferZone(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The number of pages <i>in addition to twice the required buffered range</i> to keep
   * in the prefetch cache before purging least recently used records.
   * <p>For example, if the height of the view area and the configured
   * →<code>trailingBufferZone</code> and →<code>leadingBufferZone</code> require that there
   * are three pages in the cache, then a <code>→purgePageCount</code> of 5 ensures that up to
   * 11 pages can be in the page cache any any one time. This is enough to allow
   * the user to scroll rapidly between different areas of the dataset without
   * evicting pages which are still needed.</p>
   * <p>A value of 0 indicates to never purge the prefetched data.</p>
   * @default 5
   * @see #trailingBufferZone
   * @see #leadingBufferZone
   * @see #purgePageCount
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#cfg-purgePageCount Original Ext JS documentation of 'purgePageCount'
   * @see #getPurgePageCount()
   * @see #setPurgePageCount()
   */
  public native function get purgePageCount():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set purgePageCount(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to defer any filtering operation to the server. If <code>false</code>, filtering is done
   * locally on the client.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#cfg-remoteFilter Original Ext JS documentation of 'remoteFilter'
   * @see #getRemoteFilter()
   * @see #setRemoteFilter()
   */
  override public native function get remoteFilter():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set remoteFilter(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> if the sorting should be performed on the server side, false if it is local only.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#cfg-remoteSort Original Ext JS documentation of 'remoteSort'
   * @see #getRemoteSort()
   * @see #setRemoteSort()
   */
  override public native function get remoteSort():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set remoteSort(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * If true, any sorters attached to this Store will be run after loading data,
   * before the datachanged event is fired. Defaults to true, ignored if
   * →<code>ext.data.Store.remoteSort</code> is true
   * @default false
   * @see ext.data.Store#remoteSort
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#cfg-sortOnLoad Original Ext JS documentation of 'sortOnLoad'
   * @see #getSortOnLoad()
   * @see #setSortOnLoad()
   */
  override public native function get sortOnLoad():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set sortOnLoad(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The →<code>ext.data.ProxyStore.trackRemoved</code> config is not
   * supported by buffered stores.
   * @default false
   * @see ext.data.ProxyStore#trackRemoved
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#cfg-trackRemoved Original Ext JS documentation of 'trackRemoved'
   * @see #getTrackRemoved()
   * @see #setTrackRemoved()
   */
  override public native function get trackRemoved():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set trackRemoved(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The number of extra records to keep cached on the trailing side of scrolling
   * buffer as scrolling proceeds. A larger number means fewer replenishments from
   * the server.
   * @default 25
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#cfg-trailingBufferZone Original Ext JS documentation of 'trailingBufferZone'
   * @see #getTrailingBufferZone()
   * @see #setTrailingBufferZone()
   */
  public native function get trailingBufferZone():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set trailingBufferZone(value:Number):void;

  /**
   * We are using applyData so that we can return nothing and prevent the <code>this.data</code>
   * property to be overridden.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#method-applyData Original Ext JS documentation of 'applyData'
   */
  public native function applyData(data:*):void;

  /**
   * Checks if a record is in the current active data set.
   * @param record The record
   * @return <code>true</code> if the record is in the current active data set.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#method-contains Original Ext JS documentation of 'contains'
   */
  override public native function contains(record:Model):Boolean;

  /**
   * Get the Record at the specified index.
   * <p>The index is effected by filtering.</p>
   * @param index The index of the Record to find.
   * @return The Record at the passed index. Returns null if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#method-getAt Original Ext JS documentation of 'getAt'
   */
  override public native function getAt(index:Number):Model;

  /**
   * Get the Record with the specified id.
   * <p>This method is not affected by filtering, lookup will be performed from all records
   * inside the store, filtered or not.</p>
   * @param id The id of the Record to find.
   * @return The Record with the passed id. Returns null if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#method-getById Original Ext JS documentation of 'getById'
   */
  override public native function getById(id:*):Model;

  /**
   * Returns the value of <code>leadingBufferZone</code>.
   * @see #leadingBufferZone
   */
  public native function getLeadingBufferZone():Number;

  /**
   * Determines the page from a record index
   * @param index The record index
   * @return The page the record belongs to
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#method-getPageFromRecordIndex Original Ext JS documentation of 'getPageFromRecordIndex'
   */
  public native function getPageFromRecordIndex(index:Number):Number;

  /**
   * Returns the value of <code>purgePageCount</code>.
   * @see #purgePageCount
   */
  public native function getPurgePageCount():Number;

  /**
   * Returns the value of <code>remoteFilter</code>.
   * @see #remoteFilter
   */
  override public native function getRemoteFilter():Boolean;

  /**
   * Returns the value of <code>remoteSort</code>.
   * @see #remoteSort
   */
  override public native function getRemoteSort():Boolean;

  /**
   * Returns the value of <code>sortOnLoad</code>.
   * @see #sortOnLoad
   */
  override public native function getSortOnLoad():Boolean;

  /**
   * Returns the value of <code>trackRemoved</code>.
   * @see #trackRemoved
   */
  override public native function getTrackRemoved():Boolean;

  /**
   * Returns the value of <code>trailingBufferZone</code>.
   * @see #trailingBufferZone
   */
  public native function getTrailingBufferZone():Number;

  [Deprecated(replacement="getRange", since="4.2")]
  /**
   * Guarantee a specific range, this will load the store with a range (that
   * must be the <code>→pageSize</code> or smaller) and take care of any loading that may
   * be necessary.
   * @param start The starting index. Defaults to zero.
   * @param end The ending index. Defaults to the last record. The end index
   * <b>is included</b>.
   * @param callback Function to call with the results
   * @param scope The <code>this</code> pointer for the <code>callback</code>.
   * @see #pageSize
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#method-guaranteeRange Original Ext JS documentation of 'guaranteeRange'
   */
  public native function guaranteeRange(start:Number, end:Number, callback:Function, scope:Object = null):void;

  /**
   * Get the index of the record within the store.
   * <p>When store is filtered, records outside of filter will not be found.</p>
   * @param record The Ext.data.Model object to find.
   * @return The index of the passed Record. Returns -1 if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#method-indexOf Original Ext JS documentation of 'indexOf'
   */
  public native function indexOf(record:Model):Number;

  /**
   * Get the index within the store of the Record with the passed id.
   * <p>Like #indexOf, this method is effected by filtering.</p>
   * @param id The id of the Record to find.
   * @return The index of the Record. Returns -1 if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#method-indexOfId Original Ext JS documentation of 'indexOfId'
   */
  public native function indexOfId(id:String):Number;

  /**
   * Prefetches data into the store using its configured →<code>proxy</code>.
   * @param options config object, passed into the
   * Ext.data.operation.Operation object before loading.
   * See →<code>load()</code>
   * @see #proxy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#method-prefetch Original Ext JS documentation of 'prefetch'
   * @see #load()
   */
  public native function prefetch(options:Object = null):*;

  /**
   * Prefetches a page of data.
   * @param page The page to prefetch
   * @param options config object, passed into the
   * Ext.data.operation.Operation object before loading.
   * See →<code>load()</code>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#method-prefetchPage Original Ext JS documentation of 'prefetchPage'
   * @see #load()
   */
  public native function prefetchPage(page:Number, options:Object = null):void;

  /**
   * Ensures that the specified range of rows is present in the cache.
   * <p>Converts the row range to a page range and then only load pages which are not already
   * present in the page cache.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.BufferedStore.html#method-prefetchRange Original Ext JS documentation of 'prefetchRange'
   */
  public native function prefetchRange(start:*, end:*):void;

  /**
   * Sets the value of <code>leadingBufferZone</code>.
   * @param leadingBufferZone The new value.
   * @see #leadingBufferZone
   */
  public native function setLeadingBufferZone(leadingBufferZone:Number):void;

  /**
   * Sets the value of <code>purgePageCount</code>.
   * @param purgePageCount The new value.
   * @see #purgePageCount
   */
  public native function setPurgePageCount(purgePageCount:Number):void;

  /**
   * Sets the value of <code>remoteFilter</code>.
   * @param remoteFilter The new value.
   * @see #remoteFilter
   */
  override public native function setRemoteFilter(remoteFilter:Boolean):void;

  /**
   * Sets the value of <code>remoteSort</code>.
   * @param remoteSort The new value.
   * @see #remoteSort
   */
  override public native function setRemoteSort(remoteSort:Boolean):void;

  /**
   * Sets the value of <code>sortOnLoad</code>.
   * @param sortOnLoad The new value.
   * @see #sortOnLoad
   */
  override public native function setSortOnLoad(sortOnLoad:Boolean):void;

  /**
   * Sets the value of <code>trackRemoved</code>.
   * @param trackRemoved The new value.
   * @see #trackRemoved
   */
  override public native function setTrackRemoved(trackRemoved:Boolean):void;

  /**
   * Sets the value of <code>trailingBufferZone</code>.
   * @param trailingBufferZone The new value.
   * @see #trailingBufferZone
   */
  public native function setTrailingBufferZone(trailingBufferZone:Number):void;
}
}