package ext.data {
import ext.util.Collection;

[Native("Ext.data.ChainedStore", require)]
/**
 * A chained store is a store that is a "view" of an existing store. The data comes from the
 * →<code>source</code>, however this view of the store may be sorted &amp; filtered independently without
 * having any impact on the →<code>source</code> store.
 * @see #source
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html Original Ext JS documentation of 'Ext.data.ChainedStore'
 */
public class ChainedStore extends AbstractStore implements ILocalStore {
  /**
   * @param config @inheritDoc
   */
  public function ChainedStore(config:ChainedStore = null) {
    super();
  }

  /**
   * <code>true</code> in this class to identify an object as an instantiated ChainedStore, or subclass
   * thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#property-isChainedStore Original Ext JS documentation of 'isChainedStore'
   */
  public native function get isChainedStore():Boolean;

  /**
   * @private
   */
  public native function set isChainedStore(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The backing data source for this chained store. Either a store instance
   * or the id of an existing store.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#cfg-source Original Ext JS documentation of 'source'
   * @see #getSource()
   * @see #setSource()
   */
  public native function get source():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set source(value:*):void;

  [ArrayElementType("ext.data.Model")]
  /**
   * Adds Model instance to the Store. This method accepts either:
   * <ul>
   * <li>An array of Model instances or Model configuration objects.</li>
   * <li>Any number of Model instance or Model configuration object arguments.</li>
   * </ul>
   * <p>The new Model instances will be added at the end of the existing collection.</p>
   * <p>Sample usage:</p>
   * <pre>
   * myStore.add({some: 'data'}, {some: 'other data'});
   * </pre>
   * <p>Note that if this Store is sorted, the new Model instances will be inserted
   * at the correct point in the Store to maintain the sort order.</p>
   * @param record An array of
   * records or configuration objects, or variable number of record or config arguments.
   * @return The record instances that were added.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-add Original Ext JS documentation of 'add'
   */
  public native function add(...record):Array;

  /**
   * Runs the aggregate function for all the records in the store.
   * <p>When store is filtered, only items within the filter are aggregated.</p>
   * @param fn The function to execute. The function is called with a single parameter,
   * an array of records for that group.
   * @param scope The scope to execute the function in. Defaults to the store.
   * @param grouped True to perform the operation for each group
   * in the store. The value returned will be an object literal with the key being the group
   * name and the group average being the value. The grouped parameter is only honored if
   * the store has a groupField.
   * @param field The field to get the value from
   * @return An object literal with the group names and their appropriate values.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-aggregate Original Ext JS documentation of 'aggregate'
   */
  public native function aggregate(fn:Function, scope:Object = null, grouped:Boolean = false, field:String = null):Object;

  /**
   * Gets the average value in the store.
   * <p>When store is filtered, only items within the filter are aggregated.</p>
   * @param field The field in each record
   * @param grouped True to perform the operation for each group
   * in the store. The value returned will be an object literal with the key being the group
   * name and the group average being the value. The grouped parameter is only honored if
   * the store has a groupField.
   * @return The average value, if no items exist, 0.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-average Original Ext JS documentation of 'average'
   */
  public native function average(field:String, grouped:Boolean = false):Object;

  /**
   * Collects unique values for a particular dataIndex from this store.
   * <p>Note that the <code>filtered</code> option can also be passed as a separate parameter for
   * compatibility with previous versions.</p>
   * <pre>
   * var store = Ext.create('Ext.data.Store', {
   *     fields: ['name'],
   *     data: [{
   *         name: 'Larry'
   *     }, {
   *         name: 'Darryl'
   *     }, {
   *         name: 'Darryl'
   *     }]
   * });
   *
   * store.collect('name');
   * // returns ["Larry", "Darryl"]
   * </pre>
   * @param property The property to collect
   * @param includeOptions An object which contains options which modify how
   * the store is traversed. For compatibility, this argument may be the <code>allowNull</code>
   * value itself. If so, the next argument is the <code>filtered</code> value.
   * <ul>
   * <li><code>allowNull:Boolean</code> (optional) —
   * Pass true to allow null, undefined or
   * empty string values.
   * </li>
   * <li><code>filtered:Boolean</code> (optional) —
   * Pass <code>true</code> to collect from all records,
   * even ones which are filtered.
   * </li>
   * </ul>
   * @param filtered This argument only applies when the legacy call form
   * is used and <code>includeOptions</code> is actually the <code>allowNull</code> value.
   * @return An array of the unique values
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-collect Original Ext JS documentation of 'collect'
   */
  public native function collect(property:String, includeOptions:Object = null, filtered:Boolean = false):Array;

  /**
   * Gets the count of items in the store.
   * <p>When store is filtered, only items within the filter are counted.</p>
   * @param grouped True to perform the operation for each group
   * in the store. The value returned will be an object literal with the key being the group
   * name and the count for each group being the value. The grouped parameter is only honored if
   * the store has a groupField.
   * @return the count
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-count Original Ext JS documentation of 'count'
   */
  public native function count(grouped:Boolean = false):Number;

  /**
   * Calls the specified function for each <i>record</i> (→<code>ext.data.Model</code>) in the store.
   * <p>When store is filtered, only loops over the filtered records.</p>
   * @param fn The function to call. The <i>Record</i> (→<code>ext.data.Model</code>) is passed
   * as the first parameter. Returning <code>false</code> aborts and exits the iteration.
   * @param scope The scope (<code>this</code> reference) in which the function is executed.
   * Defaults to the current <i>record</i> (→<code>ext.data.Model</code>) in the iteration.
   * @param includeOptions An object which contains options which
   * modify how the store is traversed. Or simply the <code>filtered</code> option.
   * <ul>
   * <li><code>filtered:Boolean</code> (optional) —
   * Pass <code>true</code> to include filtered out
   * nodes in the iteration.
   * </li>
   * </ul>
   * @see ext.data.Model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-each Original Ext JS documentation of 'each'
   */
  public native function each(fn:Function, scope:Object = null, includeOptions:* = undefined):void;

  /**
   * Convenience function for getting the first model instance in the store.
   * <p>When store is filtered, will return first item within the filter.</p>
   * @param grouped True to perform the operation for each group
   * in the store. The value returned will be an object literal with the key being the group
   * name and the first record being the value. The grouped parameter is only honored if
   * the store has a groupField.
   * @return The first model instance in the store, or undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-first Original Ext JS documentation of 'first'
   */
  public native function first(grouped:Boolean = false):*;

  /**
   * Get the Record with the specified id.
   * <p>This method is not affected by filtering, lookup will be performed from all records
   * inside the store, filtered or not.</p>
   * @param id The id of the Record to find.
   * @return The Record with the passed id. Returns null if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-getById Original Ext JS documentation of 'getById'
   */
  override public native function getById(id:*):Model;

  /**
   * Get the Record with the specified internalId.
   * <p>This method is not affected by filtering, lookup will be performed from all records
   * inside the store, filtered or not.</p>
   * @param internalId The id of the Record to find.
   * @return The Record with the passed internalId. Returns null if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-getByInternalId Original Ext JS documentation of 'getByInternalId'
   */
  public native function getByInternalId(internalId:*):Model;

  /**
   * Get the model used for this store.
   * @return The model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-getModel Original Ext JS documentation of 'getModel'
   */
  public native function getModel():Model;

  /**
   * Returns the value of <code>source</code>.
   * @see #source
   */
  public native function getSource():*;

  /**
   * @inheritDoc
   */
  public native function getSummaryRecord():Model;

  /**
   * Get the index of the record within the store.
   * <p>When store is filtered, records outside of filter will not be found.</p>
   * @param record The Ext.data.Model object to find.
   * @return The index of the passed Record. Returns -1 if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-indexOf Original Ext JS documentation of 'indexOf'
   */
  public native function indexOf(record:Model):Number;

  /**
   * Get the index within the store of the Record with the passed id.
   * <p>Like #indexOf, this method is affected by filtering.</p>
   * @param id The id of the Record to find.
   * @return The index of the Record. Returns -1 if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-indexOfId Original Ext JS documentation of 'indexOfId'
   */
  public native function indexOfId(id:String):Number;

  [ArrayElementType("ext.data.Model")]
  /**
   * Inserts Model instances into the Store at the given index and fires the add event.
   * See also →<code>add()</code>.
   * @param index The start index at which to insert the passed Records.
   * @param records An <code>→ext.data.Model</code>
   * instance, the data needed to populate an instance or an array of either of these.
   * @return records The added records
   * @see #add()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-insert Original Ext JS documentation of 'insert'
   * @see ext.data.Model
   */
  public native function insert(index:Number, records:*):Array;

  /**
   * Convenience function for getting the last model instance in the store.
   * <p>When store is filtered, will return last item within the filter.</p>
   * @param grouped True to perform the operation for each group
   * in the store. The value returned will be an object literal with the key being the group
   * name and the last record being the value. The grouped parameter is only honored if
   * the store has a groupField.
   * @return The last model instance in the store, or undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-last Original Ext JS documentation of 'last'
   */
  public native function last(grouped:Boolean = false):*;

  /**
   * Gets the maximum value in the store.
   * <p>When store is filtered, only items within the filter are aggregated.</p>
   * @param field The field in each record
   * @param grouped True to perform the operation for each group
   * in the store. The value returned will be an object literal with the key being the group
   * name and the maximum in the group being the value. The grouped parameter is only honored if
   * the store has a groupField.
   * @return The maximum value, if no items exist, undefined.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-max Original Ext JS documentation of 'max'
   */
  public native function max(field:String, grouped:Boolean = false):Object;

  /**
   * Gets the minimum value in the store.
   * <p>When store is filtered, only items within the filter are aggregated.</p>
   * @param field The field in each record
   * @param grouped True to perform the operation for each group
   * in the store. The value returned will be an object literal with the key being the group
   * name and the minimum in the group being the value. The grouped parameter is only honored if
   * the store has a groupField.
   * @return The minimum value, if no items exist, undefined.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-min Original Ext JS documentation of 'min'
   */
  public native function min(field:String, grouped:Boolean = false):Object;

  /**
   * Query all the cached records in this Store by name/value pair.
   * The parameters will be used to generated a filter function that is given
   * to the queryBy method.
   * <p>This method complements queryBy by generating the query function automatically.</p>
   * <p>This method is not affected by filtering, it will always search <i>all</i> records in the store
   * regardless of filtering.</p>
   * @param property The property to create the filter function for
   * @param value The string/regex to compare the property value to
   * @param anyMatch True to match any part of the string, not just the
   * beginning.
   * @default false
   * @param caseSensitive <code>true</code> to create a case-sensitive regex.
   * @default false
   * @param exactMatch True to force exact match (^ and $ characters
   * added to the regex). Ignored if <code>anyMatch</code> is <code>true</code>.
   * @default false
   * @return The matched records
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-query Original Ext JS documentation of 'query'
   */
  public native function query(property:String, value:*, anyMatch:Boolean = false, caseSensitive:Boolean = false, exactMatch:Boolean = false):Collection;

  /**
   * Query all the cached records in this Store using a filtering function. The specified function
   * will be called with each record in this Store. If the function returns <code>true</code> the record is
   * included in the results.
   * <p>This method is not affected by filtering, it will always search <i>all</i> records in the store
   * regardless of filtering.</p>
   * @param fn The function to be called. It will be passed the following parameters:
   * <ul>
   * <li><code>record:ext.data.Model</code> (optional) —
   * The record to test for filtering. Access field values
   * using →<code>ext.data.Model.get()</code>.
   * </li>
   * <li><code>id:Object</code> (optional) —
   * The ID of the Record passed.
   * </li>
   * </ul>
   * @param scope The scope (this reference) in which the function is executed
   * Defaults to this Store.
   * @return The matched records
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-queryBy Original Ext JS documentation of 'queryBy'
   * @see ext.data.Model#get()
   */
  public native function queryBy(fn:Function, scope:Object = null):Collection;

  /**
   * Sets the value of <code>source</code>.
   * @param source The new value.
   * @see #source
   */
  public native function setSource(source:*):void;

  /**
   * Sums the value of <code>field</code> for each <i>record</i> (→<code>ext.data.Model</code>) in store
   * and returns the result.
   * <p>When store is filtered, only sums items within the filter.</p>
   * @param field A field in each record
   * @param grouped True to perform the operation for each group
   * in the store. The value returned will be an object literal with the key being the group
   * name and the sum for that group being the value. The grouped parameter is only honored if
   * the store has a groupField.
   * @return The sum
   * @see ext.data.Model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ChainedStore.html#method-sum Original Ext JS documentation of 'sum'
   */
  public native function sum(field:String, grouped:Boolean = false):Number;
}
}