package ext.data {

[Native("Ext.data.ClientStore", require)]
/**
 * This class is used to store data on the client in a specified <code>→storage</code> (either 'local'
 * or 'session'). Unlike the <i>localStorage proxy</i> (→<code>ext.data.proxy.LocalStorageProxy</code>), this
 * store uses a single <code>→storageKey</code> to hold the entire contents of the store. This helps
 * reduce key overhead but also requires that all records and field be saved for any change.
 * @see #storage
 * @see ext.data.proxy.LocalStorageProxy
 * @see #storageKey
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ClientStore.html Original Ext JS documentation of 'Ext.data.ClientStore'
 */
public class ClientStore extends Store {
  /**
   * @inheritDoc
   */
  public function ClientStore(config:Store = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Specify 'local' to use <code>localStorage</code> and 'session' to use <code>sessionStorage</code>.
   * @default 'local'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ClientStore.html#cfg-storage Original Ext JS documentation of 'storage'
   * @see #getStorage()
   * @see #setStorage()
   */
  public native function get storage():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set storage(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * <b>This is a required setting</b>. The key to use for saving the content of this store.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ClientStore.html#cfg-storageKey Original Ext JS documentation of 'storageKey'
   * @see #getStorageKey()
   * @see #setStorageKey()
   */
  public native function get storageKey():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set storageKey(value:String):void;

  /**
   * Returns the value of <code>storage</code>.
   * @see #storage
   */
  public native function getStorage():String;

  /**
   * Returns the value of <code>storageKey</code>.
   * @see #storageKey
   */
  public native function getStorageKey():String;

  /**
   * Sets the value of <code>storage</code>.
   * @param storage The new value.
   * @see #storage
   */
  public native function setStorage(storage:String):void;

  /**
   * Sets the value of <code>storageKey</code>.
   * @param storageKey The new value.
   * @see #storageKey
   */
  public native function setStorageKey(storageKey:String):void;
}
}