package ext.data {
import ext.data.request.BaseRequest;
import ext.mixin.Observable;

[Native("Ext.data.Connection", require)]
/**
 * @see ext.data.events.Connection_optionsEvent.BEFORE_REQUEST
 * @eventType ext.data.events.Connection_optionsEvent.BEFORE_REQUEST
 */
[Event(name='onBeforeRequest', type='ext.data.events.Connection_optionsEvent')]
/**
 * @see ext.data.events.Connection_response_optionsEvent.REQUEST_COMPLETE
 * @eventType ext.data.events.Connection_response_optionsEvent.REQUEST_COMPLETE
 */
[Event(name='onRequestComplete', type='ext.data.events.Connection_response_optionsEvent')]
/**
 * @see ext.data.events.Connection_response_optionsEvent.REQUEST_EXCEPTION
 * @eventType ext.data.events.Connection_response_optionsEvent.REQUEST_EXCEPTION
 */
[Event(name='onRequestException', type='ext.data.events.Connection_response_optionsEvent')]
/**
 * The Connection class encapsulates a connection to the page's originating domain, allowing
 * requests to be made either to a configured URL, or to a URL specified at request time.
 * <p>Requests made by this class are asynchronous, and will return immediately. No data from the
 * server will be available to the statement immediately following the →<code>request()</code> call.
 * To process returned data, use a success callback in the request options object, or an
 * <i>event listener</i> (→<code>event:onRequestComplete</code>).</p>
 * <p><b>File Uploads</b></p>
 * <p>File uploads are not performed using normal "Ajax" techniques, that is they are not performed
 * using XMLHttpRequests. Instead the form is submitted in the standard manner with the DOM
 * &lt;form&gt; element temporarily modified to have its target set to refer to a dynamically
 * generated, hidden &lt;iframe&gt; which is inserted into the document but removed after the
 * return data has been gathered.</p>
 * <p>The server response is parsed by the browser to create the document for the IFRAME. If the
 * server is using JSON to send the return object, then the Content-Type header must be set to
 * "text/html" in order to tell the browser to insert the text unchanged into the document body.</p>
 * <p>Characters which are significant to an HTML parser must be sent as HTML entities, so encode
 * <code>&lt;</code> as <code>&amp;lt;</code>, <code>&amp;</code> as <code>&amp;amp;</code> etc.</p>
 * <p>The response text is retrieved from the document, and a fake XMLHttpRequest object is created
 * containing a responseText property in order to conform to the requirements of event handlers and
 * callbacks.</p>
 * <p>Be aware that file upload packets are sent with the content type multipart/form and some server
 * technologies (notably JEE) may require some custom processing in order to retrieve parameter
 * names and parameter values from the packet content.</p>
 * <p>Also note that it's not possible to check the response code of the hidden iframe, so the success
 * handler will ALWAYS fire.</p>
 * <p><b>Binary Posts</b></p>
 * <p>The class supports posting binary data to the server by using native browser capabilities,
 * or a flash polyfill plugin in browsers that do not support native binary posting (e.g.
 * Internet Explorer version 9 or less). A number of limitations exist when the polyfill is used:</p>
 * <ul>
 * <li>Only asynchronous connections are supported.</li>
 * <li>Only the POST method can be used.</li>
 * <li>The return data can only be binary for now. Set the →<code>ext.data.Connection.binary</code>
 * parameter to <code>true</code>.</li>
 * <li>Only the 0, 1 and 4 (complete) readyState values will be reported to listeners.</li>
 * <li>The flash object will be injected at the bottom of the document and should be invisible.</li>
 * <li>Important: See note about packaing the flash plugin with the app in the documenetation of
 * →<code>null</code>.</li>
 * </ul>
 * @see #request()
 * @see #event:onRequestComplete
 * @see ext.data.Connection#binary
 * @see null
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html Original Ext JS documentation of 'Ext.data.Connection'
 */
public class Connection extends Observable {
  /**
   * @param config @inheritDoc
   */
  public function Connection(config:Connection = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> if this request should run asynchronously. Setting this to <code>false</code> should
   * generally be avoided, since it will cause the UI to be blocked, the user won't be able
   * to interact with the browser until the request completes.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#cfg-async Original Ext JS documentation of 'async'
   * @see #getAsync()
   * @see #setAsync()
   */
  public native function get async():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set async(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Whether this request should abort any pending requests.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#cfg-autoAbort Original Ext JS documentation of 'autoAbort'
   * @see #getAutoAbort()
   * @see #setAutoAbort()
   */
  public native function get autoAbort():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set autoAbort(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * True if the response should be treated as binary data. If true, the binary
   * data will be accessible as a "responseBytes" property on the response object.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#cfg-binary Original Ext JS documentation of 'binary'
   * @see #getBinary()
   * @see #setBinary()
   */
  public native function get binary():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set binary(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * True to enable CORS support on the XHR object. Currently the only effect of this option
   * is to use the XDomainRequest object instead of XMLHttpRequest if the browser is IE8
   * or above.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#cfg-cors Original Ext JS documentation of 'cors'
   * @see #getCors()
   * @see #setCors()
   */
  public native function get cors():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set cors(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * An object containing request headers which are added to each request made by this object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#cfg-defaultHeaders Original Ext JS documentation of 'defaultHeaders'
   * @see #getDefaultHeaders()
   * @see #setDefaultHeaders()
   */
  public native function get defaultHeaders():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set defaultHeaders(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The default header to be sent out with any post request.
   * @default 'application/x-www-form-urlencoded; charset=UTF-8'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#cfg-defaultPostHeader Original Ext JS documentation of 'defaultPostHeader'
   * @see #getDefaultPostHeader()
   * @see #setDefaultPostHeader()
   */
  public native function get defaultPostHeader():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set defaultPostHeader(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The header to send with Ajax requests. Also see →<code>useDefaultXhrHeader</code>.
   * @default 'XMLHttpRequest'
   * @see #useDefaultXhrHeader
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#cfg-defaultXhrHeader Original Ext JS documentation of 'defaultXhrHeader'
   * @see #getDefaultXhrHeader()
   * @see #setDefaultXhrHeader()
   */
  public native function get defaultXhrHeader():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set defaultXhrHeader(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * True to add a unique cache-buster param to GET requests.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#cfg-disableCaching Original Ext JS documentation of 'disableCaching'
   * @see #getDisableCaching()
   * @see #setDisableCaching()
   */
  public native function get disableCaching():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set disableCaching(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Change the parameter which is sent went disabling caching through a cache buster.
   * @default '_dc'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#cfg-disableCachingParam Original Ext JS documentation of 'disableCachingParam'
   * @see #getDisableCachingParam()
   * @see #setDisableCachingParam()
   */
  public native function get disableCachingParam():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set disableCachingParam(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Any parameters to be appended to the request.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#cfg-extraParams Original Ext JS documentation of 'extraParams'
   * @see #getExtraParams()
   * @see #setExtraParams()
   */
  public native function get extraParams():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set extraParams(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The default HTTP method to be used for requests.
   * <p>If not set, but →<code>request()</code> params are present, POST will be used;
   * otherwise, GET will be used.</p>
   * @see #request()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#cfg-method Original Ext JS documentation of 'method'
   * @see #getMethod()
   * @see #setMethod()
   */
  public native function get method():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set method(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The password to pass when using →<code>withCredentials</code>.
   * @default ''
   * @see #withCredentials
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#cfg-password Original Ext JS documentation of 'password'
   * @see #getPassword()
   * @see #setPassword()
   */
  public native function get password():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set password(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The timeout in milliseconds to be used for
   * requests.
   * Defaults to 30000 milliseconds (30 seconds).
   * <p>When a request fails due to timeout the XMLHttpRequest response object will
   * contain:</p>
   * <pre>
   * timedout: true
   * </pre>
   * @default 30000
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#cfg-timeout Original Ext JS documentation of 'timeout'
   * @see #getTimeout()
   * @see #setTimeout()
   */
  public native function get timeout():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set timeout(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The URL for this connection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#cfg-url Original Ext JS documentation of 'url'
   * @see #getUrl()
   * @see #setUrl()
   */
  public native function get url():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set url(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to send the →<code>defaultXhrHeader</code> along with any request.
   * @default true
   * @see #defaultXhrHeader
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#cfg-useDefaultXhrHeader Original Ext JS documentation of 'useDefaultXhrHeader'
   * @see #getUseDefaultXhrHeader()
   * @see #setUseDefaultXhrHeader()
   */
  public native function get useDefaultXhrHeader():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set useDefaultXhrHeader(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The username to pass when using →<code>withCredentials</code>.
   * @default ''
   * @see #withCredentials
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#cfg-username Original Ext JS documentation of 'username'
   * @see #getUsername()
   * @see #setUsername()
   */
  public native function get username():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set username(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * True to set <code>withCredentials = true</code> on the XHR object
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#cfg-withCredentials Original Ext JS documentation of 'withCredentials'
   * @see #getWithCredentials()
   * @see #setWithCredentials()
   */
  public native function get withCredentials():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set withCredentials(value:Boolean):void;

  /**
   * Aborts an active request.
   * @param request Defaults to the last request
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#method-abort Original Ext JS documentation of 'abort'
   */
  public native function abort(request:Object = null):void;

  /**
   * Aborts all active requests
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#method-abortAll Original Ext JS documentation of 'abortAll'
   */
  public native function abortAll():void;

  /**
   * Returns the value of <code>async</code>.
   * @see #async
   */
  public native function getAsync():Boolean;

  /**
   * Returns the value of <code>autoAbort</code>.
   * @see #autoAbort
   */
  public native function getAutoAbort():Boolean;

  /**
   * Returns the value of <code>binary</code>.
   * @see #binary
   */
  public native function getBinary():Boolean;

  /**
   * Returns the value of <code>cors</code>.
   * @see #cors
   */
  public native function getCors():Boolean;

  /**
   * Returns the value of <code>defaultHeaders</code>.
   * @see #defaultHeaders
   */
  public native function getDefaultHeaders():Object;

  /**
   * Returns the value of <code>defaultPostHeader</code>.
   * @see #defaultPostHeader
   */
  public native function getDefaultPostHeader():String;

  /**
   * Returns the value of <code>defaultXhrHeader</code>.
   * @see #defaultXhrHeader
   */
  public native function getDefaultXhrHeader():String;

  /**
   * Returns the value of <code>disableCaching</code>.
   * @see #disableCaching
   */
  public native function getDisableCaching():Boolean;

  /**
   * Returns the value of <code>disableCachingParam</code>.
   * @see #disableCachingParam
   */
  public native function getDisableCachingParam():String;

  /**
   * Returns the value of <code>extraParams</code>.
   * @see #extraParams
   */
  public native function getExtraParams():Object;

  /**
   * Returns the value of <code>method</code>.
   * @see #method
   */
  public native function getMethod():String;

  /**
   * Returns the value of <code>password</code>.
   * @see #password
   */
  public native function getPassword():String;

  /**
   * Returns the value of <code>timeout</code>.
   * @see #timeout
   */
  public native function getTimeout():Number;

  /**
   * Returns the value of <code>url</code>.
   * @see #url
   */
  public native function getUrl():String;

  /**
   * Returns the value of <code>useDefaultXhrHeader</code>.
   * @see #useDefaultXhrHeader
   */
  public native function getUseDefaultXhrHeader():Boolean;

  /**
   * Returns the value of <code>username</code>.
   * @see #username
   */
  public native function getUsername():String;

  /**
   * Returns the value of <code>withCredentials</code>.
   * @see #withCredentials
   */
  public native function getWithCredentials():Boolean;

  /**
   * Determines whether this object has a request outstanding.
   * @param request Defaults to the last transaction
   * @return True if there is an outstanding request.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#method-isLoading Original Ext JS documentation of 'isLoading'
   */
  public native function isLoading(request:Object = null):Boolean;

  /**
   * Sends an HTTP (Ajax) request to a remote server.
   * <p><b>Important:</b> Ajax server requests are asynchronous, and this call will
   * return before the response has been received.</p>
   * <p>Instead, process any returned data using a promise:</p>
   * <pre>
   *  Ext.Ajax.request({
   *      url: 'ajax_demo/sample.json'
   *  }).then(function(response, opts) {
   *      var obj = Ext.decode(response.responseText);
   *      console.dir(obj);
   *  },
   *  function(response, opts) {
   *      console.log('server-side failure with status code ' + response.status);
   *  });
   * </pre>
   * <p>Or in callback functions:</p>
   * <pre>
   *  Ext.Ajax.request({
   *      url: 'ajax_demo/sample.json',
   *
   *      success: function(response, opts) {
   *          var obj = Ext.decode(response.responseText);
   *          console.dir(obj);
   *      },
   *
   *      failure: function(response, opts) {
   *          console.log('server-side failure with status code ' + response.status);
   *      }
   *  });
   * </pre>
   * <p>To execute a callback function in the correct scope, use the <code>scope</code> option.</p>
   * @param options An object which may contain the following properties:
   * <p>(The options object may also contain any other property which might be needed to perform
   * postprocessing in a callback because it is passed to callback functions.)</p>
   * <ul>
   * <li><code>url</code> (optional) —
   * The URL to which to send the request, or a function
   * to call which returns a URL string. The scope of the function is specified by the <code>scope</code>
   * option. Defaults to the configured <code>→url</code>.
   * </li>
   * <li><code>async:Boolean</code> (optional) —
   * <code>true</code> if this request should run asynchronously.
   * Setting this to <code>false</code> should generally be avoided, since it will cause the UI to be
   * blocked, the user won't be able to interact with the browser until the request completes.
   * Defaults to <code>true</code>.
   * </li>
   * <li><code>params</code> (optional) —
   * An object containing properties which are
   * used as parameters to the request, a url encoded string or a function to call to get either.
   * The scope of the function is specified by the <code>scope</code> option.
   * </li>
   * <li><code>method:String</code> (optional) —
   * The HTTP method to use
   * for the request. Defaults to the configured method, or if no method was configured,
   * "GET" if no parameters are being sent, and "POST" if parameters are being sent. Note that
   * the method name is case-sensitive and should be all caps.
   * </li>
   * <li><code>callback:Function</code> (optional) —
   * The function to be called upon receipt of the HTTP
   * response. The callback is called regardless of success or failure and is passed the
   * following parameters:
   * <ul>
   * <li><code>options:Object</code> (optional) —
   * The parameter to the request call.
   * </li>
   * <li><code>success:Boolean</code> (optional) —
   * True if the request succeeded.
   * </li>
   * <li><code>response:Object</code> (optional) —
   * The XMLHttpRequest object containing the response
   * data. See <a href="http://www.w3.org/TR/XMLHttpRequest/">www.w3.org/TR/XMLHttpRequest/</a> for details
   * about accessing elements of the response.
   * </li>
   * </ul>
   * </li>
   * <li><code>success:Function</code> (optional) —
   * The function to be called upon success of the request.
   * The callback is passed the following parameters:
   * <ul>
   * <li><code>response:Object</code> (optional) —
   * The XMLHttpRequest object containing the response
   * data.
   * </li>
   * <li><code>options:Object</code> (optional) —
   * The parameter to the request call.
   * </li>
   * </ul>
   * </li>
   * <li><code>failure:Function</code> (optional) —
   * The function to be called upon failure of the request.
   * The callback is passed the following parameters:
   * <ul>
   * <li><code>response:Object</code> (optional) —
   * The XMLHttpRequest object containing the response
   * data.
   * </li>
   * <li><code>options:Object</code> (optional) —
   * The parameter to the request call.
   * </li>
   * </ul>
   * </li>
   * <li><code>scope:Object</code> (optional) —
   * The scope in which to execute the callbacks: The "this" object
   * for the callback function. If the <code>→url</code>, or <code>params</code> options were specified as functions
   * from which to draw values, then this also serves as the scope for those function calls.
   * Defaults to the browser window.
   * </li>
   * <li><code>timeout:Number</code> (optional) —
   * The timeout in milliseconds to be used for this
   * request.
   * Defaults to 30000 milliseconds (30 seconds).
   * <p>When a request fails due to timeout the XMLHttpRequest response object will
   * contain:</p>
   * <pre>
   * timedout: true
   * </pre>
   * </li>
   * <li><code>form</code> (optional) —
   * The <code>&lt;form&gt;</code> Element or the id of the
   * <code>&lt;form&gt;</code> to pull parameters from.
   * </li>
   * <li><code>isUpload:Boolean</code> (optional) —
   * <b>Only meaningful when used with the <code>form</code> option.</b>
   * <p>True if the form object is a file upload (will be set automatically if the form was
   * configured with <b><code>enctype</code></b> <code>"multipart/form-data"</code>).</p>
   * <p>File uploads are not performed using normal "Ajax" techniques, that is they are <b>not</b>
   * performed using XMLHttpRequests. Instead the form is submitted in the standard manner with
   * the DOM <code>&amp;lt;form&amp;gt;</code> element temporarily modified to have its
   * <a href="https://developer.mozilla.org/en-US/docs/Web/API/HTMLFormElement/target">target</a>
   * set to refer to a dynamically generated, hidden <code>&amp;lt;iframe&amp;gt;</code> which is inserted
   * into the document but removed after the return data has been gathered.</p>
   * <p>The server response is parsed by the browser to create the document for the IFRAME. If the
   * server is using JSON to send the return object, then the
   * <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Type">Content-Type</a>
   * header must be set to "text/html" in order to tell the browser to insert the text
   * unchanged into the document body.</p>
   * <p>The response text is retrieved from the document, and a fake XMLHttpRequest object is created
   * containing a <code>responseText</code> property in order to conform to the requirements of event
   * handlers and callbacks.</p>
   * <p>Be aware that file upload packets are sent with the content type
   * <a href="https://tools.ietf.org/html/rfc7233#section-4.1">multipart/form</a> and some server
   * technologies (notably JEE) may require some custom processing in order to retrieve parameter
   * names and parameter values from the packet content.</p>
   * <ul>
   * <li><a href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-target">target</a></li>
   * <li><a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a></li>
   * <li><a href="http://www.faqs.org/rfcs/rfc2388.html">multipart/form</a></li>
   * </ul>
   * </li>
   * <li><code>headers:Object</code> (optional) —
   * Request headers to set for the request.
   * The XHR will attempt to set an appropriate Content-Type based on the params/data passed
   * to the request. To prevent this, setting the Content-Type header to <code>null</code> or <code>undefined</code>
   * will not attempt to set any Content-Type and it will be left to the browser.
   * </li>
   * <li><code>xmlData:Object</code> (optional) —
   * XML document to use for the post. Note: This will be used
   * instead of params for the post data. Any params will be appended to the URL.
   * </li>
   * <li><code>jsonData</code> (optional) —
   * JSON data to use as the post. Note: This will be used
   * instead of params for the post data. Any params will be appended to the URL.
   * </li>
   * <li><code>rawData:String</code> (optional) —
   * A raw string to use as the post. Note: This will be used
   * instead of params for the post data. Any params will be appended to the URL.
   * </li>
   * <li><code>binaryData:Array</code> (optional) —
   * An array of bytes to submit in binary form. Any params
   * will be appended to the URL. If binaryData is present, you must set
   * →<code>ext.data.Connection.binary</code> to <code>true</code> and options.method to <code>POST</code>.
   * </li>
   * <li><code>disableCaching:Boolean</code> (optional) —
   * True to add a unique cache-buster param to GET
   * requests.
   * </li>
   * <li><code>withCredentials:Boolean</code> (optional) —
   * True to add the withCredentials property to the
   * XHR object
   * </li>
   * <li><code>username:String</code> (optional) —
   * The username to pass when using <code>→withCredentials</code>.
   * </li>
   * <li><code>password:String</code> (optional) —
   * The password to pass when using <code>→withCredentials</code>.
   * </li>
   * <li><code>binary:Boolean</code> (optional) —
   * True if the response should be treated as binary data.
   * If true, the binary data will be accessible as a "responseBytes" property on the response
   * object.
   * </li>
   * </ul>
   * @return The request object. This may be used to abort the
   * request.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#method-request Original Ext JS documentation of 'request'
   * @see #url
   * @see ext.data.Connection#binary
   * @see #withCredentials
   */
  public native function request(options:Object):BaseRequest;

  /**
   * Sets the value of <code>async</code>.
   * @param async The new value.
   * @see #async
   */
  public native function setAsync(async:Boolean):void;

  /**
   * Sets the value of <code>autoAbort</code>.
   * @param autoAbort The new value.
   * @see #autoAbort
   */
  public native function setAutoAbort(autoAbort:Boolean):void;

  /**
   * Sets the value of <code>binary</code>.
   * @param binary The new value.
   * @see #binary
   */
  public native function setBinary(binary:Boolean):void;

  /**
   * Sets the value of <code>cors</code>.
   * @param cors The new value.
   * @see #cors
   */
  public native function setCors(cors:Boolean):void;

  /**
   * Sets the value of <code>defaultHeaders</code>.
   * @param defaultHeaders The new value.
   * @see #defaultHeaders
   */
  public native function setDefaultHeaders(defaultHeaders:Object):void;

  /**
   * Sets the value of <code>defaultPostHeader</code>.
   * @param defaultPostHeader The new value.
   * @see #defaultPostHeader
   */
  public native function setDefaultPostHeader(defaultPostHeader:String):void;

  /**
   * Sets the value of <code>defaultXhrHeader</code>.
   * @param defaultXhrHeader The new value.
   * @see #defaultXhrHeader
   */
  public native function setDefaultXhrHeader(defaultXhrHeader:String):void;

  /**
   * Sets the value of <code>disableCaching</code>.
   * @param disableCaching The new value.
   * @see #disableCaching
   */
  public native function setDisableCaching(disableCaching:Boolean):void;

  /**
   * Sets the value of <code>disableCachingParam</code>.
   * @param disableCachingParam The new value.
   * @see #disableCachingParam
   */
  public native function setDisableCachingParam(disableCachingParam:String):void;

  /**
   * Sets the value of <code>extraParams</code>.
   * @param extraParams The new value.
   * @see #extraParams
   */
  public native function setExtraParams(extraParams:Object):void;

  /**
   * Sets the value of <code>method</code>.
   * @param method The new value.
   * @see #method
   */
  public native function setMethod(method:String):void;

  /**
   * Sets various options such as the url, params for the request
   * @param options The initial options
   * @param scope The scope to execute in
   * @return The params for the request
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Connection.html#method-setOptions Original Ext JS documentation of 'setOptions'
   */
  public native function setOptions(options:Object, scope:Object):Object;

  /**
   * Sets the value of <code>password</code>.
   * @param password The new value.
   * @see #password
   */
  public native function setPassword(password:String):void;

  /**
   * Sets the value of <code>timeout</code>.
   * @param timeout The new value.
   * @see #timeout
   */
  public native function setTimeout(timeout:Number):void;

  /**
   * Sets the value of <code>url</code>.
   * @param url The new value.
   * @see #url
   */
  public native function setUrl(url:String):void;

  /**
   * Sets the value of <code>useDefaultXhrHeader</code>.
   * @param useDefaultXhrHeader The new value.
   * @see #useDefaultXhrHeader
   */
  public native function setUseDefaultXhrHeader(useDefaultXhrHeader:Boolean):void;

  /**
   * Sets the value of <code>username</code>.
   * @param username The new value.
   * @see #username
   */
  public native function setUsername(username:String):void;

  /**
   * Sets the value of <code>withCredentials</code>.
   * @param withCredentials The new value.
   * @see #withCredentials
   */
  public native function setWithCredentials(withCredentials:Boolean):void;
}
}