package ext.data {
import ext.Base;

[Deprecated(replacement="ext.data.Validation", since="5.0")]
[Native("Ext.data.Error", require)]
/**
 * This class hols the results of a validator for an <code>→ext.data.Model</code>. These objects are
 * placed in an <code>→ext.data.DataErrorCollection</code> and returned by <code>→ext.data.Model.validate()</code>.
 * <p>Usually this class does not need to be instantiated directly - instances are instead created
 * automatically when →<code>ext.data.Model.validate()</code> on a model instance.</p>
 * @see ext.data.Model
 * @see ext.data.DataErrorCollection
 * @see ext.data.Model#validate()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Error.html Original Ext JS documentation of 'Ext.data.Error'
 */
public class DataError extends Base {
  /**
   * @param config @inheritDoc
   */
  public function DataError(config:DataError = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The name of the field this error belongs to.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Error.html#cfg-field Original Ext JS documentation of 'field'
   * @see #getField()
   * @see #setField()
   */
  public native function get field():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set field(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The message containing the description of the error.
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Error.html#cfg-message Original Ext JS documentation of 'message'
   * @see #getMessage()
   * @see #setMessage()
   */
  public native function get message():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set message(value:String):void;

  /**
   * Returns the value of <code>field</code>.
   * @see #field
   */
  public native function getField():String;

  /**
   * Returns the value of <code>message</code>.
   * @see #message
   */
  public native function getMessage():String;

  /**
   * Sets the value of <code>field</code>.
   * @param field The new value.
   * @see #field
   */
  public native function setField(field:String):void;

  /**
   * Sets the value of <code>message</code>.
   * @param message The new value.
   * @see #message
   */
  public native function setMessage(message:String):void;
}
}