package ext.data {
import ext.util.MixedCollection;

[Native("Ext.data.ErrorCollection", require)]
/**
 * Wraps a collection of validation error responses and provides convenient functions for
 * accessing and errors for specific fields.
 * <p>Usually this class does not need to be instantiated directly - instances are instead
 * created automatically when →<code>ext.data.Model.validate()</code> on a model instance:</p>
 * <pre>
 *  // Validate some existing model instance - in this case it returned 2 failures
 *  // messages
 *
 *  var errors = myModel.validate();
 *  errors.isValid(); //false
 *
 *  errors.length; //2
 *  errors.getByField('name');  // [{field: 'name',  message: 'must be present'}]
 *  errors.getByField('title'); // [{field: 'title', message: 'is too short'}]
 * </pre>
 * @see ext.data.Model#validate()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ErrorCollection.html Original Ext JS documentation of 'Ext.data.ErrorCollection'
 */
public class DataErrorCollection extends MixedCollection {
  /**
   * @inheritDoc
   */
  public function DataErrorCollection(config:MixedCollection = null) {
    super();
  }

  /**
   * Returns all of the errors for the given field
   * @param fieldName The field to get errors for
   * @return All errors for the given field
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ErrorCollection.html#method-getByField Original Ext JS documentation of 'getByField'
   */
  public native function getByField(fieldName:String):Array;

  /**
   * Returns true if there are no errors in the collection
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ErrorCollection.html#method-isValid Original Ext JS documentation of 'isValid'
   */
  public native function isValid():Boolean;
}
}