package ext.data {
import ext.util.Group;

[Native("Ext.data.Group", require)]
/**
 * Encapsulates a group of records. Can provide a
 * →<code>getSummaryRecord()</code> summary record.
 * @see #getSummaryRecord()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Group.html Original Ext JS documentation of 'Ext.data.Group'
 */
public class DataGroup extends Group {
  /**
   * @inheritDoc
   */
  public function DataGroup(config:Group = null) {
    super();
  }

  /**
   * Returns the summary results for the group.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Group.html#method-getSummaryRecord Original Ext JS documentation of 'getSummaryRecord'
   */
  public native function getSummaryRecord():Model;
}
}