package ext.data {
import ext.Base;

[Native("Ext.data.Range", require)]
/**
 * This class provides access to a range of records in a <i>store</i> (→<code>ext.data.Store</code>).
 * Instances of this class are not created directly but are rather returned by a store's
 * →<code>ext.data.AbstractStore.createActiveRange()</code> method.
 * <p>This class is useful for buffered rendering where only a portion of the total set of
 * records are needed. By passing that information to a <code>Range</code>, the access to records
 * can be abstracted even across <i>virtual stores</i> (→<code>ext.data.virtual.VirtualStore</code>) where
 * only those records needed by views are fetched from the server.</p>
 * @see ext.data.Store
 * @see ext.data.AbstractStore#createActiveRange()
 * @see ext.data.virtual.VirtualStore
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Range.html Original Ext JS documentation of 'Ext.data.Range'
 */
public class DataRange extends Base {
  [ExtConfig]
  /**
   * The first record index of interest.
   * <p>This property is set by the <code>→goto()</code> method and is stored on the instance for
   * readonly use.</p>
   * @default 0
   * @see #goto()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Range.html#cfg-begin Original Ext JS documentation of 'begin'
   */
  public native function get begin():Number;

  [ExtConfig]
  /**
   * The buffer to execute server requests.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Range.html#cfg-buffer Original Ext JS documentation of 'buffer'
   */
  public native function get buffer():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set buffer(value:Number):void;

  [ExtConfig]
  /**
   * The first record beyond the range of interest. This is to make "length" of the
   * range simply <code>end - begin</code>.
   * <p>This property is set by the <code>→goto()</code> method and is stored on the instance for
   * readonly use.</p>
   * @default 0
   * @see #goto()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Range.html#cfg-end Original Ext JS documentation of 'end'
   */
  public native function get end():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set end(value:Number):void;

  /**
   * (Number} length
   * The number of records in the range of <code>[begin, end)</code>. This is equal to the
   * difference <code>end - begin</code>.
   * <p>This property is maintained by the <code>→goto()</code> method and is stored on the instance for
   * readonly use.</p>
   * @default 0
   * @see #goto()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Range.html#property-length Original Ext JS documentation of 'length'
   */
  public native function get length():*;

  [ArrayElementType("ext.data.Model")]
  /**
   * The records corresponding to the <code>→begin</code> and <code>→end</code> of this range. For normal
   * stores this is the standard array of records.
   * <p>For a <i>virtual store</i> (→<code>ext.data.virtual.VirtualStore</code>) this is a sparse object of
   * available records bounded by the limits of this range.</p>
   * <p>In all cases, this object is keyed by the record index and (except for the
   * <code>→length</code> property) should be treated as an array.</p>
   * @see #begin
   * @see #end
   * @see ext.data.virtual.VirtualStore
   * @see #length
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Range.html#property-records Original Ext JS documentation of 'records'
   */
  public native function get records():Array;

  [ExtConfig]
  /**
   * The associated store. This config must be supplied at construction and cannot
   * be changed after that time.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Range.html#cfg-store Original Ext JS documentation of 'store'
   */
  public native function get store():AbstractStore;

  [ExtConfig]
  /**
   * A timeout to wait for promises to complete returned from <code>→goto()</code>. <code>null</code> for
   * the timeout to be infinite.
   * @default 10000
   * @see #goto()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Range.html#cfg-waitTimeout Original Ext JS documentation of 'waitTimeout'
   */
  public native function get waitTimeout():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set waitTimeout(value:Number):void;

  /**
   * Go to a particular point in the range.
   * @param begin The start index, inclusive.
   * @param end The end index, exclusive.
   * @return Ext.Promise The promise. Resolves with <code>this</code> when the range is resolved
   * successfully. Resolves with <code>null</code> if the range times out, or a new range is requested
   * before the current one completes.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Range.html#method-goto Original Ext JS documentation of 'goto'
   */
  public native function goto(begin:Number, end:Number):*;
}
}