package ext.data {

[Native("Ext.data.DirectStore", require)]
/**
 * Small helper class to create an →<code>ext.data.Store</code> configured with an
 * →<code>ext.data.proxy.DirectProxy</code> and →<code>ext.data.reader.JsonReader</code> to make interacting with an
 * →<code>ext.direct.DirectManager</code> server-side →<code>ext.direct.Provider</code> easier. To create
 * a different proxy/reader combination create a basic →<code>ext.data.Store</code> configured as needed.
 * <p><b>Note:</b> Although they are not listed, this class inherits all of the config options of:</p>
 * <ul>
 * <li>
 * <p><b>→<code>ext.data.Store</code></b></p>
 * </li>
 * <li>
 * <p><b>→<code>ext.data.reader.JsonReader</code></b></p>
 * <ul>
 * <li><b>→<code>ext.data.reader.JsonReader.rootProperty</code></b></li>
 * <li><b>→<code>ext.data.reader.JsonReader.totalProperty</code></b></li>
 * </ul>
 * </li>
 * <li>
 * <p><b>→<code>ext.data.proxy.DirectProxy</code></b></p>
 * <ul>
 * <li><b>→<code>ext.data.proxy.DirectProxy.directFn</code></b></li>
 * <li><b>→<code>ext.data.proxy.DirectProxy.paramOrder</code></b></li>
 * <li><b>→<code>ext.data.proxy.DirectProxy.paramsAsHash</code></b></li>
 * </ul>
 * </li>
 * </ul>
 * @see ext.data.Store
 * @see ext.data.proxy.DirectProxy
 * @see ext.data.reader.JsonReader
 * @see ext.direct.#DirectManager ext.direct.DirectManager
 * @see ext.direct.Provider
 * @see ext.data.reader.JsonReader#rootProperty
 * @see ext.data.reader.JsonReader#totalProperty
 * @see ext.data.proxy.DirectProxy#directFn
 * @see ext.data.proxy.DirectProxy#paramOrder
 * @see ext.data.proxy.DirectProxy#paramsAsHash
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.DirectStore.html Original Ext JS documentation of 'Ext.data.DirectStore'
 */
public class DirectStore extends Store {
  /**
   * @param config @inheritDoc
   */
  public function DirectStore(config:DirectStore = null) {
    super();
  }
}
}