package ext.data {

[Native("Ext.data.JsonP", require)]
/**
 * This class is used to create JSONP requests. JSONP is a mechanism that allows for making
 * requests for data cross domain. JSONP is basically a <code>&lt;script&gt;</code> node with the source of the url
 * executing a function that was created by Ext.data.JsonP. Once the resource has loaded, the
 * <code>&lt;script&gt;</code> node will be destroyed.
 * <p>If you have a request such as:</p>
 * <pre>
 * Ext.data.JsonP.request({
 *     url : 'foo.php'
 * });
 * </pre>
 * <p>Ext.data.JsonP will create a <code>&lt;script&gt;</code> node in the <code>&lt;head&gt;</code> with the <code>src</code> attribute pointing
 * to <code>foo.php?callback=Ext.data.JsonP.callback1</code>. The <code>foo.php</code> script will have to detect the
 * <code>callback</code> URL parameter and return valid JavaScript:</p>
 * <pre>
 * Ext.data.JsonP.callback1({"foo":"bar"});
 * </pre>
 * <p>A simple PHP example would look like:</p>
 * <pre>
 * &lt;?php
 *
 * $data = array('foo' =&gt; 'bar');
 *
 * if (!empty($_REQUEST['callback'])) {
 *     header('Content-Type: application/javascript');
 *     echo $_REQUEST['callback'] . '(';
 * }
 *
 * echo json_encode($data);
 *
 * if (!empty($_REQUEST['callback']) {
 *     echo ');';
 * }
 *
 * ?&gt;
 * </pre>
 * <p>More information is available <a href="http://en.wikipedia.org/wiki/JSONP">here</a>. You can
 * also use <a href="http://www.jsonplint.com">JSONPLint</a> to test your JSONP.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.JsonP.html Original Ext JS documentation of 'Ext.data.JsonP'
 */
public const JsonP:SJsonP = new SJsonP;
}