package ext.data {

[Native("Ext.data.JsonPStore", require)]
/**
 * Small helper class to make creating →<code>ext.data.Store</code>s from different domain JSON
 * data easier.
 * <p>A JsonPStore will be automatically configured with a →<code>ext.data.reader.JsonReader</code> and a
 * →<code>ext.data.proxy.JsonPProxy</code>.</p>
 * <p>A store configuration would be something like:</p>
 * <pre>
 * var store = new Ext.data.JsonPStore({
 *     // store configs
 *     storeId: 'myStore',
 *
 *     // proxy configs
 *     url: 'get-images.php',
 *
 *     // reader configs
 *     root: 'images',
 *     fields: ['name', 'url', {name: 'size', type: 'float'}, {name: 'lastmod', type: 'date'}]
 * });
 * </pre>
 * <p>This store is configured to consume a returned object of the form:</p>
 * <pre>
 * stcCallback({
 *     images: [{
 *         name: 'Image one',
 *         url: '/GetImage.php?id=1',
 *         size: 46.5,
 *         lastmod: new Date(2007, 10, 29)
 *     }, {
 *         name: 'Image Two',
 *         url: '/GetImage.php?id=2',
 *         size: 43.2,
 *         lastmod: new Date(2007, 10, 30)
 *     }]
 * })
 * </pre>
 * <p>Where stcCallback is the callback name passed in the request to the remote domain. See
 * →<code>ext.data.proxy.JsonPProxy</code> for details of how this works.</p>
 * <p>An object literal of this form could also be used as the →<code>data</code> config option.</p>
 * @see ext.data.Store
 * @see ext.data.reader.JsonReader
 * @see ext.data.proxy.JsonPProxy
 * @see #data
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.JsonPStore.html Original Ext JS documentation of 'Ext.data.JsonPStore'
 */
public class JsonPStore extends Store {
  /**
   * @param config @inheritDoc
   */
  public function JsonPStore(config:JsonPStore = null) {
    super();
  }
}
}