package ext.data {

[Native("Ext.data.JsonStore", require)]
/**
 * Small helper class to make creating →<code>ext.data.Store</code>s from JSON data easier.
 * A JsonStore will be automatically configured with a →<code>ext.data.reader.JsonReader</code>.
 * <p>A store configuration would be something like:</p>
 * <pre>
 * var store = new Ext.data.JsonStore({
 *     // store configs
 *     storeId: 'myStore',
 *
 *     proxy: {
 *         type: 'ajax',
 *         url: 'get-images.php',
 *         reader: {
 *             type: 'json',
 *             rootProperty: 'images'
 *         }
 *     },
 *
 *     //alternatively, a Model name can be given (see Ext.data.Store for an example)
 *     fields: ['name', 'url', {name: 'size', type: 'float'}, {name: 'lastmod', type: 'date'}]
 * });
 * </pre>
 * <p>This store is configured to consume a returned object of the form:</p>
 * <pre>
 * {
 *     images: [{
 *         name: 'Image one',
 *         url: '/GetImage.php?id=1',
 *         size: 46.5,
 *         lastmod: new Date(2007, 10, 29)
 *     }, {
 *         name: 'Image Two',
 *         url: '/GetImage.php?id=2',
 *         size: 43.2,
 *         lastmod: new Date(2007, 10, 30)
 *     }]
 * }
 * </pre>
 * <p>An object literal of this form could also be used as the →<code>data</code> config option.</p>
 * @see ext.data.Store
 * @see ext.data.reader.JsonReader
 * @see #data
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.JsonStore.html Original Ext JS documentation of 'Ext.data.JsonStore'
 */
public class JsonStore extends Store {
  /**
   * @param config @inheritDoc
   */
  public function JsonStore(config:JsonStore = null) {
    super();
  }
}
}