package ext.data {

import ext.data.operation.DestroyOperation;
import ext.tree.TreePanel;

[Native("Ext.data.NodeInterface", require)]
/**
 * @see ext.data.events.NodeInterface_node_indexEvent.APPEND
 * @eventType ext.data.events.NodeInterface_node_indexEvent.APPEND
 */
[Event(name='onAppend', type='ext.data.events.NodeInterface_node_indexEvent')]
/**
 * @see ext.data.events.NodeInterface_nodeEvent.BEFORE_APPEND
 * @eventType ext.data.events.NodeInterface_nodeEvent.BEFORE_APPEND
 */
[Event(name='onBeforeAppend', type='ext.data.events.NodeInterface_nodeEvent')]
/**
 * @see ext.data.events.NodeInterfaceEvent.BEFORE_COLLAPSE
 * @eventType ext.data.events.NodeInterfaceEvent.BEFORE_COLLAPSE
 */
[Event(name='onBeforeCollapse', type='ext.data.events.NodeInterfaceEvent')]
/**
 * @see ext.data.events.NodeInterfaceEvent.BEFORE_EXPAND
 * @eventType ext.data.events.NodeInterfaceEvent.BEFORE_EXPAND
 */
[Event(name='onBeforeExpand', type='ext.data.events.NodeInterfaceEvent')]
/**
 * @see ext.data.events.NodeInterface_node_refNodeEvent.BEFORE_INSERT
 * @eventType ext.data.events.NodeInterface_node_refNodeEvent.BEFORE_INSERT
 */
[Event(name='onBeforeInsert', type='ext.data.events.NodeInterface_node_refNodeEvent')]
/**
 * @see ext.data.events.NodeInterface_oldParent_newParent_indexEvent.BEFORE_MOVE
 * @eventType ext.data.events.NodeInterface_oldParent_newParent_indexEvent.BEFORE_MOVE
 */
[Event(name='onBeforeMove', type='ext.data.events.NodeInterface_oldParent_newParent_indexEvent')]
/**
 * @see ext.data.events.NodeInterface_node_isMoveEvent.BEFORE_REMOVE
 * @eventType ext.data.events.NodeInterface_node_isMoveEvent.BEFORE_REMOVE
 */
[Event(name='onBeforeRemove', type='ext.data.events.NodeInterface_node_isMoveEvent')]
/**
 * @see ext.data.events.NodeInterfaceEvent.COLLAPSE
 * @eventType ext.data.events.NodeInterfaceEvent.COLLAPSE
 */
[Event(name='onCollapse', type='ext.data.events.NodeInterfaceEvent')]
/**
 * @see ext.data.events.NodeInterfaceEvent.EXPAND
 * @eventType ext.data.events.NodeInterfaceEvent.EXPAND
 */
[Event(name='onExpand', type='ext.data.events.NodeInterfaceEvent')]
/**
 * @see ext.data.events.NodeInterface_node_refNodeEvent.INSERT
 * @eventType ext.data.events.NodeInterface_node_refNodeEvent.INSERT
 */
[Event(name='onInsert', type='ext.data.events.NodeInterface_node_refNodeEvent')]
/**
 * @see ext.data.events.NodeInterface_oldParent_newParent_indexEvent.MOVE
 * @eventType ext.data.events.NodeInterface_oldParent_newParent_indexEvent.MOVE
 */
[Event(name='onMove', type='ext.data.events.NodeInterface_oldParent_newParent_indexEvent')]
/**
 * @see ext.data.events.NodeInterface_node_isMove_contextEvent.REMOVE
 * @eventType ext.data.events.NodeInterface_node_isMove_contextEvent.REMOVE
 */
[Event(name='onRemove', type='ext.data.events.NodeInterface_node_isMove_contextEvent')]
/**
 * @see ext.data.events.NodeInterface_childNodesEvent.SORT
 * @eventType ext.data.events.NodeInterface_childNodesEvent.SORT
 */
[Event(name='onSort', type='ext.data.events.NodeInterface_childNodesEvent')]
/**
 * This class is used as a set of methods that are applied to the prototype of a
 * →<code>ext.data.Model</code> to decorate it with a Node API. This means that models
 * used in conjunction with a tree will have all of the tree related methods available
 * on the model. In general, this class will not be used directly by the developer.
 * <p>This class also creates extra <i>fields</i> (→<code>ext.data.field.DataField</code>) on the model, if they do
 * not exist, to help maintain the tree state and UI. These fields are documented as
 * config options.</p>
 * <p>The data fields used to render a tree node are: →<code>text</code>, →<code>leaf</code>,
 * →<code>children</code>, and →<code>expanded</code>. Once a node is loaded to the tree store
 * you can use →<code>ext.data.Model.get()</code> to fetch the value of a given field
 * name (provided there is not a convenience accessor on the Node for that field).</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.tip.QuickTipManager.init(); // not required when using Ext.application()
 *
 * var root = {
 *     expanded: true,
 *     children: [{
 *         text: "Leaf node (&lt;i&gt;no folder/arrow icon&lt;/i&gt;)",
 *         leaf: true,
 *         qtitle: 'Sample Tip Title',
 *         qtip: 'Tip body'
 *     }, {
 *         text: "Parent node expanded",
 *         expanded: true,
 *         children: [{
 *             text: "Expanded leaf node 1",
 *             leaf: true
 *         }, {
 *             text: "Expanded leaf node 2",
 *             leaf: true
 *         }]
 *     }, {
 *         text: "Parent node collapsed",
 *         children: [{
 *             text: "Collapsed leaf node 1",
 *             leaf: true
 *         }, {
 *             text: "Collapsed leaf node 2",
 *             leaf: true
 *         }]
 *     }]
 * };
 *
 * var tree = Ext.create('Ext.tree.Panel', {
 *     title: 'TreePanel',
 *     width: 260,
 *     height: 200,
 *     root: root,
 *     rootVisible: false,
 *     renderTo: document.body,
 *     bbar: ['The first node ', {
 *         text: 'is a leaf?',
 *         handler: function() {
 *             var firstChild = tree.getRootNode().getChildAt(0);
 *             Ext.Msg.alert('Is Leaf?', firstChild.isLeaf());
 *         }
 *     }, {
 *         text: 'has text?',
 *         handler: function() {
 *             var firstChild = tree.getRootNode().getChildAt(0);
 *             Ext.Msg.alert('Has Text:', firstChild.get('text'));
 *         }
 *     }]
 * });
 * </pre>
 * <p>The following configs have methods used to set the value / state of the node at
 * runtime:</p>
 * <p><b>→<code>children</code> / →<code>leaf</code></b></p>
 * <ul>
 * <li>→<code>appendChild()</code></li>
 * <li>→<code>hasChildNodes()</code></li>
 * <li>→<code>insertBefore()</code></li>
 * <li>→<code>insertChild()</code></li>
 * <li>→<code>remove()</code></li>
 * <li>→<code>removeAll()</code></li>
 * <li>→<code>removeChild()</code></li>
 * <li>→<code>replaceChild()</code></li>
 * </ul>
 * <p><b>→<code>expanded</code></b></p>
 * <ul>
 * <li>→<code>expand()</code></li>
 * <li>→<code>expandChildren()</code></li>
 * <li>→<code>collapse()</code></li>
 * <li>→<code>collapseChildren()</code></li>
 * </ul>
 * <p>The remaining configs may be set using →<code>ext.data.Model.set()</code>.</p>
 * <pre>
 * node.set('text', 'Changed Text'); // example showing how to change the node label
 * </pre>
 * <p>The →<code>qtip</code>, →<code>qtitle</code>, and →<code>qshowDelay</code> use QuickTips and
 * requires initializing →<code>ext.tip.QuickTipManager</code> unless the application is
 * created using →<code>ext.Ext.application()</code>.</p>
 * <pre>
 * Ext.tip.QuickTipManager.init();
 * </pre>
 * <p>For additional information and examples see the description for
 * →<code>ext.tree.TreePanel</code>.</p>
 * <p>For decorating a model to implement NodeInterface, see the class NodeInterfaceDecorator.</p>
 * @see ext.data.Model
 * @see ext.data.field.DataField
 * @see #text
 * @see #leaf
 * @see #children
 * @see #expanded
 * @see ext.data.Model#get()
 * @see #appendChild()
 * @see #hasChildNodes()
 * @see #insertBefore()
 * @see #insertChild()
 * @see #remove()
 * @see #removeAll()
 * @see #removeChild()
 * @see #replaceChild()
 * @see #expand()
 * @see #expandChildren()
 * @see #collapse()
 * @see #collapseChildren()
 * @see ext.data.Model#set()
 * @see #qtip
 * @see #qtitle
 * @see #qshowDelay
 * @see ext.tip.#QuickTipManager ext.tip.QuickTipManager
 * @see ext.SExt#application() ext.Ext.application()
 * @see ext.tree.TreePanel
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html Original Ext JS documentation of 'Ext.data.NodeInterface'
 */
public interface NodeInterface {
  [ExtConfig] /**
   * Set to false to deny dragging of this node.
   * <p>Applicable when using the →<code>ext.tree.plugin.TreeViewDragDropPlugin</code> plugin.</p>
   * @default true
   * @see ext.tree.plugin.TreeViewDragDropPlugin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#cfg-allowDrag Original Ext JS documentation of 'allowDrag'
   */
  function get allowDrag():Boolean;

  [ExtConfig] /**
   * @private
   */
  function set allowDrag(value:Boolean):void;

  [ExtConfig] /**
   * Set to false to deny dropping on this node.
   * <p>Applicable when using the →<code>ext.tree.plugin.TreeViewDragDropPlugin</code> plugin.</p>
   * @default true
   * @see ext.tree.plugin.TreeViewDragDropPlugin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#cfg-allowDrop Original Ext JS documentation of 'allowDrop'
   */
  function get allowDrop():Boolean;

  [ExtConfig] /**
   * @private
   */
  function set allowDrop(value:Boolean):void;

  [ExtConfig] /**
   * Set to true or false to show a checkbox alongside this node.
   * <p>To fetch an array of checked nodes use →<code>ext.tree.TreePanel.getChecked()</code>.</p>
   * @default null
   * @see ext.tree.TreePanel#getChecked()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#cfg-checked Original Ext JS documentation of 'checked'
   */
  function get checked():Boolean;

  [ExtConfig] /**
   * @private
   */
  function set checked(value:Boolean):void;

  [ArrayElementType("ext.data.NodeInterface")] /**
   * An array of this nodes children. Array will be empty if this node has no children.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#property-childNodes Original Ext JS documentation of 'childNodes'
   */
  function get childNodes():Array;

  /**
   * @private
   */
  function set childNodes(value:Array):void;

  [ArrayElementType("ext.data.NodeInterface")]
  [ExtConfig] /**
   * Array of child nodes.
   * <p><b>Note:</b> By default the child nodes root is <code>→children</code>, but can be set using the
   * reader →<code>ext.data.reader.DataReader.rootProperty</code> config on the
   * <i>TreeStore's</i> (→<code>ext.data.TreeStore</code>) →<code>ext.data.TreeStore.proxy</code>.</p>
   * @see #children
   * @see ext.data.reader.DataReader#rootProperty
   * @see ext.data.TreeStore
   * @see ext.data.TreeStore#proxy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#cfg-children Original Ext JS documentation of 'children'
   */
  function get children():Array;

  [ExtConfig] /**
   * @private
   */
  function set children(value:Array):void;

  [ExtConfig] /**
   * CSS class to apply to this node.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#cfg-cls Original Ext JS documentation of 'cls'
   */
  function get cls():String;

  [ExtConfig] /**
   * @private
   */
  function set cls(value:String):void;

  [ExtConfig] /**
   * False to prevent expanding/collapsing of this node.
   * <p>See also: →<code>isExpandable()</code>.</p>
   * @default true
   * @see #isExpandable()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#cfg-expandable Original Ext JS documentation of 'expandable'
   */
  function get expandable():Boolean;

  [ExtConfig] /**
   * @private
   */
  function set expandable(value:Boolean):void;

  [ExtConfig] /**
   * True if the node is expanded.
   * <p>When the tree is asynchronously remote loaded, expanding a collapsed node loads
   * the children of that node (if the node has not already been loaded previously).</p>
   * <p>See also: →<code>isExpanded()</code>.</p>
   * @default false
   * @see #isExpanded()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#cfg-expanded Original Ext JS documentation of 'expanded'
   */
  function get expanded():Boolean;

  [ExtConfig] /**
   * @private
   */
  function set expanded(value:Boolean):void;

  /**
   * A reference to this node's first child node. <code>null</code> if this node has no children.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#property-firstChild Original Ext JS documentation of 'firstChild'
   */
  function get firstChild():NodeInterface;

  /**
   * @private
   */
  function set firstChild(value:NodeInterface):void;

  [ExtConfig] /**
   * A numeric unicode character code to use as the icon. The default font-family
   * for glyphs can be set globally using
   * →<code>ext.app.Application.glyphFontFamily</code> application
   * config or the →<code>ext.Ext.setGlyphFontFamily()</code> method.
   * It is initially set to <code>'Pictos'</code>.
   * <p>The following shows how to set the glyph using the font icons provided in the
   * SDK (assuming the font-family has been configured globally):</p>
   * <pre>
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'x48'       // the "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 72          // The "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'H'         // the "home" icon
   * </pre>
   * <p>Alternatively, this config option accepts a string with the charCode and
   * font-family separated by the <code>&#64;</code> symbol.</p>
   * <pre>
   * // using Font Awesome
   * glyph: 'xf015&#64;FontAwesome'     // the "home" icon
   *
   * // using Pictos
   * glyph: 'H&#64;Pictos'              // the "home" icon
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a></li>
   * </ul>
   * @since 6.2.0
   * @see ext.app.Application#glyphFontFamily
   * @see ext.SExt#setGlyphFontFamily() ext.Ext.setGlyphFontFamily()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#cfg-glyph Original Ext JS documentation of 'glyph'
   */
  function get glyph():String;

  [ExtConfig] /**
   * @private
   */
  function set glyph(value:String):void;

  [ExtConfig] /**
   * A URL for a link that's created when this config is specified.
   * <p>See also →<code>hrefTarget</code>.</p>
   * @see #hrefTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#cfg-href Original Ext JS documentation of 'href'
   */
  function get href():String;

  [ExtConfig] /**
   * @private
   */
  function set href(value:String):void;

  [ExtConfig] /**
   * Target for link. Only applicable when →<code>href</code> is also specified.
   * @see #href
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#cfg-hrefTarget Original Ext JS documentation of 'hrefTarget'
   */
  function get hrefTarget():String;

  [ExtConfig] /**
   * @private
   */
  function set hrefTarget(value:String):void;

  [ExtConfig] /**
   * Path to an image to use as an icon.
   * <p>For instructions on how you can use icon fonts including those distributed in
   * the SDK see →<code>iconCls</code>.</p>
   * @see #iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#cfg-icon Original Ext JS documentation of 'icon'
   */
  function get icon():String;

  [ExtConfig] /**
   * @private
   */
  function set icon(value:String):void;

  [ExtConfig] /**
   * One or more space separated CSS classes to be applied to the icon element.
   * The CSS rule(s) applied should specify a background image to be used as the
   * icon.
   * <p>An example of specifying a custom icon class would be something like:</p>
   * <pre>
   * // specify the property in the config for the class:
   * iconCls: 'my-home-icon'
   *
   * // css rule specifying the background image to be used as the icon image:
   * .my-home-icon {
   *     background-image: url(../images/my-home-icon.gif) !important;
   * }
   * </pre>
   * <p>In addition to specifying your own classes, you can use the font icons
   * provided in the SDK using the following syntax:</p>
   * <pre>
   * // using Font Awesome
   * iconCls: 'x-fa fa-home'
   *
   * // using Pictos
   * iconCls: 'pictos pictos-home'
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a>
   * Use →<code>icon</code> to set the icon src path directly.</li>
   * </ul>
   * @see #icon
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#cfg-iconCls Original Ext JS documentation of 'iconCls'
   */
  function get iconCls():String;

  [ExtConfig] /**
   * @private
   */
  function set iconCls(value:String):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Node, or subclass
   * thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#property-isNode Original Ext JS documentation of 'isNode'
   */
  function get isNode():Boolean;

  /**
   * @private
   */
  function set isNode(value:Boolean):void;

  /**
   * A reference to this node's last child node. <code>null</code> if this node has no children.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#property-lastChild Original Ext JS documentation of 'lastChild'
   */
  function get lastChild():NodeInterface;

  /**
   * @private
   */
  function set lastChild(value:NodeInterface):void;

  [ExtConfig] /**
   * Set to true to indicate that this child can have no children. The expand icon/arrow will
   * then not be rendered for this node.
   * <p>See also: →<code>isLeaf()</code>.</p>
   * @default false
   * @see #isLeaf()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#cfg-leaf Original Ext JS documentation of 'leaf'
   */
  function get leaf():Boolean;

  [ExtConfig] /**
   * @private
   */
  function set leaf(value:Boolean):void;

  /**
   * A reference to this node's next sibling node. <code>null</code> if this node does not have a next
   * sibling.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#property-nextSibling Original Ext JS documentation of 'nextSibling'
   */
  function get nextSibling():NodeInterface;

  /**
   * @private
   */
  function set nextSibling(value:NodeInterface):void;

  /**
   * A reference to this node's parent node. <code>null</code> if this node is the root node.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#property-parentNode Original Ext JS documentation of 'parentNode'
   */
  function get parentNode():NodeInterface;

  /**
   * @private
   */
  function set parentNode(value:NodeInterface):void;

  /**
   * A reference to this node's previous sibling node. <code>null</code> if this node does not have a
   * previous sibling.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#property-previousSibling Original Ext JS documentation of 'previousSibling'
   */
  function get previousSibling():NodeInterface;

  /**
   * @private
   */
  function set previousSibling(value:NodeInterface):void;

  [ExtConfig] /**
   * Tooltip showDelay.
   * <p>See also →<code>qtip</code>.
   * See also →<code>qtitle</code>.</p>
   * @see #qtip
   * @see #qtitle
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#cfg-qshowDelay Original Ext JS documentation of 'qshowDelay'
   */
  function get qshowDelay():Number;

  [ExtConfig] /**
   * @private
   */
  function set qshowDelay(value:Number):void;

  [ExtConfig] /**
   * Tooltip text to show on this node.
   * <p>See also →<code>qtitle</code>.
   * See also →<code>qshowDelay</code>.</p>
   * @see #qtitle
   * @see #qshowDelay
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#cfg-qtip Original Ext JS documentation of 'qtip'
   */
  function get qtip():String;

  [ExtConfig] /**
   * @private
   */
  function set qtip(value:String):void;

  [ExtConfig] /**
   * Tooltip title.
   * <p>See also →<code>qtip</code>.
   * See also →<code>qshowDelay</code>.</p>
   * @see #qtip
   * @see #qshowDelay
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#cfg-qtitle Original Ext JS documentation of 'qtitle'
   */
  function get qtitle():String;

  [ExtConfig] /**
   * @private
   */
  function set qtitle(value:String):void;

  [ExtConfig] /**
   * The text to show on node label (<i>html tags are accepted</i>).
   * The default text for the root node is <code>ROOT</code>. All other nodes default to ''.
   * <p><b>Note:</b> By default the node label is <code>→text</code>, but can be set using the tree's
   * →<code>ext.tree.TreePanel.displayField</code> config.</p>
   * @see #text
   * @see ext.tree.TreePanel#displayField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#cfg-text Original Ext JS documentation of 'text'
   */
  function get text():String;

  [ExtConfig] /**
   * @private
   */
  function set text(value:String):void;

  /**
   * Inserts node(s) as the last child node of this node.
   * <p>If the node was previously a child node of another parent node, it will be
   * removed from that node first.</p>
   * @param node The node
   * or Array of nodes to append
   * @param suppressEvents True to suppress firing of
   * events.
   * @default false
   * @param commit
   * @default false
   * @return The appended node if single append, or null
   * if an array was passed
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-appendChild Original Ext JS documentation of 'appendChild'
   */
  function appendChild(node:*, suppressEvents:Boolean = false, commit:Boolean = false):NodeInterface;

  /**
   * Bubbles up the tree from this node, calling the specified function with each
   * node. The arguments to the function will be the args provided or the current
   * node. If the function returns false at any point, the bubble is stopped.
   * @param fn The function to call
   * @param scope The scope (this reference) in which the function
   * is executed. Defaults to the current Node.
   * @param args The args to call the function with. Defaults to passing
   * the current Node.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-bubble Original Ext JS documentation of 'bubble'
   */
  function bubble(fn:Function, scope:Object = null, args:Array = null):void;

  /**
   * Cascades down the tree from this node, calling the specified functions with each
   * node. The arguments to the function will be the args provided or the current
   * node. If the <code>before</code> function returns false at any point, the cascade is
   * stopped on that branch.
   * <p>Note that the 3 argument form passing <code>fn, scope, args</code> is still supported.
   * The <code>fn</code> function is as before, called <i>before</i> cascading down into child nodes.
   * If it returns <code>false</code>, the child nodes are not traversed.</p>
   * @param spec An object containing <code>before</code> and <code>after</code>
   * functions, scope and an argument list or simply the <code>before</code> function.
   * <ul>
   * <li><code>before:Function</code> (optional) —
   * A function to call on a node <i>before</i>
   * cascading down into child nodes. If it returns <code>false</code>, the child nodes
   * are not traversed.
   * </li>
   * <li><code>after:Function</code> (optional) —
   * A function to call on a node <i>after</i>
   * cascading down into child nodes.
   * </li>
   * <li><code>scope:Object</code> (optional) —
   * The scope (this reference) in which the
   * functions are executed. Defaults to the current Node.
   * </li>
   * <li><code>args:Array</code> (optional) —
   * The args to call the function with. Defaults
   * to passing the current Node.
   * </li>
   * </ul>
   * @param scope If <code>spec</code> is the <code>before</code> function instead of
   * an object, this argument is the <code>this</code> pointer.
   * @param args If <code>spec</code> is the <code>before</code> function instead of
   * an object, this argument is the <code>args</code> to pass.
   * @param after If <code>spec</code> is the <code>before</code> function instead of
   * an object, this argument is the <code>after</code> function to call.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-cascade Original Ext JS documentation of 'cascade'
   */
  function cascade(spec:*, scope:Object = null, args:Array = null, after:Function = null):void;

  /**
   * Collapse this node.
   * @param recursive True to recursively collapse all the children
   * @default false
   * @param callback The function to execute once the collapse completes
   * @param scope The scope to run the callback in
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-collapse Original Ext JS documentation of 'collapse'
   */
  function collapse(recursive:Boolean = false, callback:Function = null, scope:Object = null):void;

  /**
   * Collapse all the children of this node.
   * @param recursive True to recursively collapse all the children
   * @default false
   * @param callback The function to execute once all the children are
   * collapsed
   * @param scope The scope to run the callback in
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-collapseChildren Original Ext JS documentation of 'collapseChildren'
   */
  function collapseChildren(recursive:Function = null, callback:Function = null, scope:Object = null):void;

  /**
   * Returns true if this node is an ancestor (at any point) of the passed node.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-contains Original Ext JS documentation of 'contains'
   */
  function contains(node:NodeInterface):Boolean;

  /**
   * Creates a copy (clone) of this Node.
   * @param newId A new id, defaults to this Node's id.
   * @param session The session to which the
   * new record belongs.
   * @param deep True to recursively copy all child nodes
   * into the new Node. False to copy without child Nodes.
   * @default false
   * @return A copy of this Node.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-copy Original Ext JS documentation of 'copy'
   */
  function copyNode(newId:String = null, session:Object = null, deep:Boolean = false):NodeInterface;

  /**
   * Ensures that the passed object is an instance of a Record with the NodeInterface
   * applied
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-createNode Original Ext JS documentation of 'createNode'
   */
  function createNode(node:Object):NodeInterface;

  /**
   * Iterates the child nodes of this node, calling the specified function
   * with each node. The arguments to the function will be the args
   * provided or the current node. If the function returns false at any
   * point, the iteration stops.
   * @param fn The function to call
   * @param scope The scope (<i>this</i> reference) in which the
   * function is executed. Defaults to the Node on which eachChild is
   * called.
   * @param args The args to call the function with. Defaults to
   * passing the current Node.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-eachChild Original Ext JS documentation of 'eachChild'
   */
  function eachChild(fn:Function, scope:Object = null, args:Array = null):void;

  /**
   * Destroys the node.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-erase Original Ext JS documentation of 'erase'
   */
  function erase(options:Object = null):DestroyOperation;

  /**
   * Expand this node.
   * @param recursive True to recursively expand all the children
   * @default false
   * @param callback The function to execute once the expand completes
   * @param scope The scope to run the callback in
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-expand Original Ext JS documentation of 'expand'
   */
  function expand(recursive:Boolean = false, callback:Function = null, scope:Object = null):void;

  /**
   * Expand all the children of this node.
   * @param recursive True to recursively expand all the children
   * @default false
   * @param callback The function to execute once all the children are
   * expanded
   * @param scope The <code>this</code> pointer for the callback.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-expandChildren Original Ext JS documentation of 'expandChildren'
   */
  function expandChildren(recursive:Boolean = false, callback:Function = null, scope:Object = null):void;

  /**
   * Finds the first child that has the attribute with the specified value.
   * @param attribute The attribute name
   * @param value The value to search for
   * @param deep True to search through nodes deeper than the
   * immediate children
   * @default false
   * @return The found child or null if none was found
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-findChild Original Ext JS documentation of 'findChild'
   */
  function findChild(attribute:String, value:Object, deep:Boolean = false):NodeInterface;

  /**
   * Finds the first child by a custom function. The child matches if the function
   * passed returns true.
   * @param fn A function which must return true if the passed Node is the
   * required Node.
   * @param scope The scope (this reference) in which the function is
   * executed. Defaults to the Node being tested.
   * @param deep True to search through nodes deeper than the
   * immediate children
   * @default false
   * @return The found child or null if none was found
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-findChildBy Original Ext JS documentation of 'findChildBy'
   */
  function findChildBy(fn:Function, scope:Object = null, deep:Boolean = false):NodeInterface;

  /**
   * Fires the specified event with the passed parameters (minus the event name,
   * plus the <code>options</code> object passed to
   * →<code>ext.mixin.Observable.addListener()</code>).
   * <p>An event may be set to bubble up an Observable parent hierarchy (See
   * →<code>ext.Component.getBubbleTarget()</code>) by
   * calling →<code>ext.mixin.Observable.enableBubble()</code>.</p>
   * @param eventName The name of the event to fire.
   * @param args Variable number of parameters are passed to handlers.
   * @return returns <code>false</code> if any of the handlers return <code>false</code>
   * otherwise it returns <code>true</code>.
   * @see ext.mixin.Observable#addListener()
   * @see ext.Component#getBubbleTarget()
   * @see ext.mixin.Observable#enableBubble()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-fireEvent Original Ext JS documentation of 'fireEvent'
   */
  function fireEvent(eventName:String, ...args):Boolean;

  /**
   * Returns the child node at the specified index.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-getChildAt Original Ext JS documentation of 'getChildAt'
   */
  function getChildAt(index:Number):NodeInterface;

  /**
   * Returns depth of this node (the root node has a depth of 0)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-getDepth Original Ext JS documentation of 'getDepth'
   */
  function getDepth():Number;

  /**
   * Returns the tree this node is in.
   * @return The tree panel which owns this node.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-getOwnerTree Original Ext JS documentation of 'getOwnerTree'
   */
  function getOwnerTree():TreePanel;

  /**
   * Gets the hierarchical path from the root of the current node.
   * @param field The field to construct the path from. Defaults to the
   * model idProperty.
   * @param separator A separator to use.
   * @default '/'
   * @return The node path
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-getPath Original Ext JS documentation of 'getPath'
   */
  function getPath(field:String = null, separator:String = '/'):String;

  /**
   * Returns the →<code>ext.data.TreeStore</code> which owns this node.
   * @return The TreeStore which owns this node.
   * @see ext.data.TreeStore
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-getTreeStore Original Ext JS documentation of 'getTreeStore'
   */
  function getTreeStore():TreeStore;

  /**
   * Returns true if this node has one or more child nodes, else false.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-hasChildNodes Original Ext JS documentation of 'hasChildNodes'
   */
  function hasChildNodes():Boolean;

  /**
   * Returns the index of a child node
   * @return The index of the child node or -1 if it was not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-indexOf Original Ext JS documentation of 'indexOf'
   */
  function indexOf(child:NodeInterface):Number;

  /**
   * Returns the index of a child node that matches the id
   * @param id The id of the node to find
   * @return The index of the node or -1 if it was not found
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-indexOfId Original Ext JS documentation of 'indexOfId'
   */
  function indexOfId(id:String):Number;

  /**
   * Inserts the first node before the second node in this nodes childNodes
   * collection.
   * @param node The node
   * to insert
   * @param refNode The node to insert before (if null the
   * node is appended)
   * @return The inserted node
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-insertBefore Original Ext JS documentation of 'insertBefore'
   */
  function insertBefore(node:*, refNode:NodeInterface):NodeInterface;

  /**
   * Inserts a node into this node.
   * @param index The zero-based index to insert the node at
   * @param node The node to insert
   * @return The node you just inserted
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-insertChild Original Ext JS documentation of 'insertChild'
   */
  function insertChild(index:Number, node:*):NodeInterface;

  /**
   * Returns true if the passed node is an ancestor (at any point) of this node.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-isAncestor Original Ext JS documentation of 'isAncestor'
   */
  function isAncestor(node:NodeInterface):Boolean;

  /**
   * Returns true if this node is a branch node, and the entire branch is fully
   * loaded.
   * <p>Using this method, it is possible to ascertain whether an
   * <code>expandAll()</code> call (<i>classic toolkit TreePanel method</i>) will have
   * access to all descendant nodes without incurring a store load.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-isBranchLoaded Original Ext JS documentation of 'isBranchLoaded'
   */
  function isBranchLoaded():Boolean;

  /**
   * Returns true if this node has one or more child nodes, or if the <code>→expandable</code>
   * node attribute is explicitly specified as true, otherwise returns false.
   * @see #expandable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-isExpandable Original Ext JS documentation of 'isExpandable'
   */
  function isExpandable():Boolean;

  /**
   * Returns <code>true</code> if this node is expanded.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-isExpanded Original Ext JS documentation of 'isExpanded'
   */
  function isExpanded():Boolean;

  /**
   * Returns true if this node is the first child of its parent
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-isFirst Original Ext JS documentation of 'isFirst'
   */
  function isFirst():Boolean;

  /**
   * Returns true if this node is the last child of its parent
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-isLast Original Ext JS documentation of 'isLast'
   */
  function isLast():Boolean;

  /**
   * Returns true if this node is a leaf
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-isLeaf Original Ext JS documentation of 'isLeaf'
   */
  function isLeaf():Boolean;

  /**
   * Returns true if this node is loaded
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-isLoaded Original Ext JS documentation of 'isLoaded'
   */
  function isLoaded():Boolean;

  /**
   * Returns true if this node is loading
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-isLoading Original Ext JS documentation of 'isLoading'
   */
  function isLoading():Boolean;

  /**
   * Returns true if this node is the root node
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-isRoot Original Ext JS documentation of 'isRoot'
   */
  function isRoot():Boolean;

  /**
   * Returns true if this node is visible. Note that visibility refers to
   * the structure of the tree, the →<code>ext.tree.TreePanel.rootVisible</code>
   * configuration is not taken into account here. If this method is called
   * on the root node, it will always be visible.
   * @see ext.tree.TreePanel#rootVisible
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-isVisible Original Ext JS documentation of 'isVisible'
   */
  function isVisible():Boolean;

  /**
   * Implement this method in a tree record subclass if it needs to track whenever it is
   * registered with a →<code>ext.data.TreeStore</code>.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param treeStore The TreeStore to which the node is being registered.
   * @see ext.data.TreeStore
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-onRegisterTreeNode Original Ext JS documentation of 'onRegisterTreeNode'
   */
  function onRegisterTreeNode(treeStore:TreeStore):void;

  /**
   * Implement this method in a tree record subclass if it needs to track whenever it is
   * unregistered from a →<code>ext.data.TreeStore</code>.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param treeStore The TreeStore from which the node is being
   * unregistered.
   * @see ext.data.TreeStore
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-onUnregisterTreeNode Original Ext JS documentation of 'onUnregisterTreeNode'
   */
  function onUnregisterTreeNode(treeStore:TreeStore):void;

  /**
   * Removes this node from its parent.
   * <p><b>If</b> the node is not phantom (only added in the client side), then it may be
   * marked for removal.</p>
   * <p>If the owning <i>tree store</i> (→<code>ext.data.TreeStore</code>) is set to
   * <i>track removed</i> (→<code>ext.data.ProxyStore.trackRemoved</code>) then the node will be
   * added to the stack of nodes due to be removed the next time the store is
   * synced with the server.</p>
   * <p>If the owning <i>tree store</i> (→<code>ext.data.TreeStore</code>) is set to
   * <i>auto synchronize</i> (→<code>ext.data.ProxyStore.autoSync</code>) then the synchronize
   * request will be initiated immediately.</p>
   * @param erase True to erase the node using the configured
   * proxy. This is only needed when the owning <i>tree store</i> (→<code>ext.data.TreeStore</code>)
   * is not taking care of synchronization operations.
   * @default false
   * @return this
   * @see ext.data.TreeStore
   * @see ext.data.ProxyStore#trackRemoved
   * @see ext.data.ProxyStore#autoSync
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-remove Original Ext JS documentation of 'remove'
   */
  function remove(erase:Boolean = false):NodeInterface;

  /**
   * Removes all child nodes from this node.
   * @param erase True to erase the node using the configured
   * proxy.
   * @default false
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-removeAll Original Ext JS documentation of 'removeAll'
   */
  function removeAll(erase:Boolean = false):NodeInterface;

  /**
   * Removes a child node from this node.
   * @param node The node to remove
   * @param erase True to erase the record using the
   * configured proxy.
   * @default false
   * @return The removed node
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-removeChild Original Ext JS documentation of 'removeChild'
   */
  function removeChild(node:NodeInterface, erase:Boolean = false):NodeInterface;

  /**
   * Replaces one child node in this node with another.
   * @param newChild The replacement node
   * @param oldChild The node to replace
   * @return The replaced node
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-replaceChild Original Ext JS documentation of 'replaceChild'
   */
  function replaceChild(newChild:NodeInterface, oldChild:NodeInterface):NodeInterface;

  /**
   * Creates an object representation of this node including its children.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-serialize Original Ext JS documentation of 'serialize'
   */
  function serialize(writerParam:Object):void;

  /**
   * Sorts this nodes children using the supplied sort function.
   * @param sortFn A function which, when passed two Nodes, returns -1,
   * 0 or 1 depending upon required sort order.
   * <p>It omitted, the node is sorted according to the existing sorters in the owning
   * →<code>ext.data.TreeStore</code>.</p>
   * @param recursive True to apply this sort recursively
   * @default false
   * @param suppressEvent True to not fire a sort event.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-sort Original Ext JS documentation of 'sort'
   * @see ext.data.TreeStore
   */
  function sort(sortFn:Function = null, recursive:Boolean = false, suppressEvent:Boolean = false):void;

  [ArrayElementType("String")] /**
   * Updates general data of this node like isFirst, isLast, depth. This
   * method is internally called after a node is moved. This shouldn't
   * have to be called by the developer unless they are creating custom
   * Tree plugins.
   * @param commit
   * @param info The info to update. May contain any of the following
   * <ul>
   * <li><code>isFirst:Object</code> (optional)</li>
   * <li><code>isLast:Object</code> (optional)</li>
   * <li><code>index:Object</code> (optional)</li>
   * <li><code>depth:Object</code> (optional)</li>
   * <li><code>parentId:Object</code> (optional)</li>
   * </ul>
   * @return The names of any persistent fields that were modified.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.NodeInterface.html#method-updateInfo Original Ext JS documentation of 'updateInfo'
   */
  function updateInfo(commit:Boolean, info:Object):Array;
}
}