package ext.data {
import ext.data.proxy.DataProxy;
import ext.util.MixedCollection;

[Native("Ext.data.ProxyStore", require)]
/**
 * @see ext.data.events.ProxyStore_store_operationEvent.BEFORE_LOAD
 * @eventType ext.data.events.ProxyStore_store_operationEvent.BEFORE_LOAD
 */
[Event(name='onBeforeLoad', type='ext.data.events.ProxyStore_store_operationEvent')]
/**
 * @see ext.data.events.ProxyStore_optionsEvent.BEFORE_SYNC
 * @eventType ext.data.events.ProxyStore_optionsEvent.BEFORE_SYNC
 */
[Event(name='onBeforeSync', type='ext.data.events.ProxyStore_optionsEvent')]
/**
 * @see ext.data.events.ProxyStore_records_successful_operationEvent.LOAD
 * @eventType ext.data.events.ProxyStore_records_successful_operationEvent.LOAD
 */
[Event(name='onLoad', type='ext.data.events.ProxyStore_records_successful_operationEvent')]
/**
 * @see ext.data.events.ProxyStore_metaEvent.META_CHANGE
 * @eventType ext.data.events.ProxyStore_metaEvent.META_CHANGE
 */
[Event(name='onMetaChange', type='ext.data.events.ProxyStore_metaEvent')]
/**
 * @see ext.data.events.ProxyStore_store_operationEvent.WRITE
 * @eventType ext.data.events.ProxyStore_store_operationEvent.WRITE
 */
[Event(name='onWrite', type='ext.data.events.ProxyStore_store_operationEvent')]
/**
 * ProxyStore is a superclass of →<code>ext.data.Store</code> and →<code>ext.data.BufferedStore</code>.
 * It's never used directly, but offers a set of methods used by both of those subclasses.
 * <p>We've left it here in the docs for reference purposes, but unless you need to make a whole new
 * type of Store, what you're probably looking for is →<code>ext.data.Store</code>. If you're still
 * interested, here's a brief description of what ProxyStore is and is not.</p>
 * <p>ProxyStore provides the basic configuration for anything that can be considered a Store.
 * It expects to be given a →<code>ext.data.Model</code> that represents the type of data
 * in the Store. It also expects to be given a →<code>ext.data.proxy.DataProxy</code> that handles
 * the loading of data into the Store.</p>
 * <p>ProxyStore provides a few helpful methods such as →<code>load()</code> and →<code>sync()</code>,
 * which load and save data respectively, passing the requests through the configured
 * →<code>proxy</code>.</p>
 * <p>Built-in Store subclasses add extra behavior to each of these functions. Note also that each
 * ProxyStore subclass has its own way of storing data - in →<code>ext.data.Store</code> the data
 * is saved as a flat →<code>ext.util.Collection</code>, whereas in
 * →<code>ext.data.BufferedStore</code> we use a →<code>null</code> to maintain
 * a client side cache of pages of records.</p>
 * <p>The store provides filtering and sorting support. This sorting/filtering can happen on the
 * client side or can be completed on the server. This is controlled by the
 * →<code>ext.data.Store.remoteSort</code> and →<code>ext.data.Store.remoteFilter</code>
 * config options. For more information see the →<code>sort()</code> and
 * →<code>ext.data.Store.filter()</code> methods.</p>
 * @see ext.data.Store
 * @see ext.data.BufferedStore
 * @see ext.data.Model
 * @see ext.data.proxy.DataProxy
 * @see #load()
 * @see #sync()
 * @see #proxy
 * @see ext.util.Collection
 * @see null
 * @see ext.data.Store#remoteSort
 * @see ext.data.Store#remoteFilter
 * @see #sort()
 * @see ext.data.Store#filter()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html Original Ext JS documentation of 'Ext.data.ProxyStore'
 */
public class ProxyStore extends AbstractStore {
  /**
   * @param config @inheritDoc
   */
  public function ProxyStore(config:ProxyStore = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * This defaults to <code>true</code> when this store's →<code>proxy</code> is asynchronous,
   * such as an <i>Ajax proxy</i> (→<code>ext.data.proxy.AjaxProxy</code>).
   * <p>When the proxy is synchronous, such as a →<code>ext.data.proxy.MemoryProxy</code> memory
   * proxy, this defaults to <code>false</code>.</p>
   * <p><i>NOTE:</i> This does not cause synchronous Ajax requests if configured <code>false</code>
   * when an Ajax proxy is used. It causes immediate issuing of an Ajax request
   * when →<code>load()</code> is called rather than issuing the request at the end
   * of the current event handler run.</p>
   * <p>What this means is that when using an Ajax proxy, calls to
   * →<code>load()</code> do not fire the request to the remote resource
   * immediately, but schedule a request to be made. This is so that multiple
   * requests are not fired when mutating a store's remote filters and sorters (as
   * happens during state restoration). The request is made only once after all
   * relevant store state is fully set.</p>
   * @default undefined
   * @since 6.0.1
   * @see #proxy
   * @see ext.data.proxy.AjaxProxy
   * @see ext.data.proxy.MemoryProxy
   * @see #load()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#cfg-asynchronousLoad Original Ext JS documentation of 'asynchronousLoad'
   * @see #getAsynchronousLoad()
   * @see #setAsynchronousLoad()
   */
  public native function get asynchronousLoad():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set asynchronousLoad(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * If data is not specified, and if autoLoad is true or an Object, this store's
   * load method is automatically called after creation. If the value of autoLoad
   * is an Object, this Object will be passed to the store's load method.
   * <p>It's important to note that <i>Tree Stores</i> (→<code>ext.data.TreeStore</code>) will
   * load regardless of autoLoad's value if expand is set to true on the
   * <i>root node</i> (→<code>ext.data.TreeStore.root</code>).</p>
   * @since 2.3.0
   * @see ext.data.TreeStore
   * @see ext.data.TreeStore#root
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#cfg-autoLoad Original Ext JS documentation of 'autoLoad'
   * @see #getAutoLoad()
   * @see #setAutoLoad()
   */
  public native function get autoLoad():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set autoLoad(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * True to automatically sync the Store with its Proxy after every edit to one of
   * its Records. Defaults to false.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#cfg-autoSync Original Ext JS documentation of 'autoSync'
   * @see #getAutoSync()
   * @see #setAutoSync()
   */
  public native function get autoSync():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set autoSync(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Sets the updating behavior based on batch synchronization. 'operation' (the
   * default) will update the Store's internal representation of the data after
   * each operation of the batch has completed, 'complete' will wait until the
   * entire batch has been completed before updating the Store's data. 'complete'
   * is a good choice for local storage proxies, 'operation' is better for remote
   * proxies, where there is a comparatively high latency.
   * @default 'operation'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#cfg-batchUpdateMode Original Ext JS documentation of 'batchUpdateMode'
   * @see #getBatchUpdateMode()
   * @see #setBatchUpdateMode()
   */
  public native function get batchUpdateMode():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set batchUpdateMode(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * An Array of <code>→ext.data.field.DataField</code> config objects, simply the field
   * →<code>ext.data.field.DataField.name</code>, or a mix of config objects and strings.
   * If just a name is given, the field type defaults to <code>auto</code>.
   * <p>In a →<code>ext.data.field.DataField</code> config object you may pass the alias of
   * the <code>Ext.data.field.&#42;</code> type using the <code>type</code> config option.</p>
   * <pre>
   * // two fields are set:
   * // - an 'auto' field with a name of 'firstName'
   * // - and an Ext.data.field.Integer field with a name of 'age'
   * fields: ['firstName', {
   *     type: 'int',
   *     name: 'age'
   * }]
   * </pre>
   * <p>Fields will automatically be created at read time for any for any keys in the
   * data passed to the Model's <i>proxy's</i> (→<code>proxy</code>)
   * <i>reader</i> (→<code>ext.data.reader.DataReader</code>) whose name is not explicitly configured in
   * the <code>→fields</code> config.</p>
   * <p>Extending a Model class will inherit all the <code>→fields</code> from the superclass /
   * ancestor classes.
   * <b>Note:</b> In general, this configuration option should only be used
   * for simple stores like a two-field store of
   * →<code>ext.form.field.ComboBox</code>. For anything more complicated, such
   * as specifying a particular id property or associations, a
   * →<code>ext.data.Model</code> should be defined and specified for the
   * →<code>model</code> config.</p>
   * @default null
   * @since 2.3.0
   * @see ext.data.field.DataField
   * @see ext.data.field.DataField#name
   * @see #proxy
   * @see ext.data.reader.DataReader
   * @see #fields
   * @see ext.form.field.ComboBox
   * @see ext.data.Model
   * @see #model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#cfg-fields Original Ext JS documentation of 'fields'
   * @see #getFields()
   * @see #setFields()
   */
  public native function get fields():MixedCollection;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set fields(value:*):void;

  /**
   * Property to hold the last options from a →<code>load()</code> method call. This
   * object is used for the →<code>reload()</code> to reuse the same options. Please
   * see →<code>reload()</code> for a simple example on how to use the lastOptions
   * property.
   * @see #load()
   * @see #reload()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#property-lastOptions Original Ext JS documentation of 'lastOptions'
   */
  public native function get lastOptions():Object;

  /**
   * @private
   */
  public native function set lastOptions(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Name of the →<code>ext.data.Model</code> associated with this store. See
   * →<code>ext.data.Model.entityName</code>.
   * <p>May also be the actual Model subclass.</p>
   * <p>This config is required for the store to be able to read data unless you have
   * defined the →<code>fields</code> config which will create an anonymous
   * <code>→ext.data.Model</code>.</p>
   * @see ext.data.Model
   * @see ext.data.Model#entityName
   * @see #fields
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#cfg-model Original Ext JS documentation of 'model'
   * @see #getModel()
   * @see #setModel()
   */
  public native function get model():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set model(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The Proxy to use for this Store. This can be either a string, a config object
   * or a Proxy instance - see →<code>setProxy</code> for details.
   * @since 1.1.0
   * @see #setProxy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#cfg-proxy Original Ext JS documentation of 'proxy'
   * @see #getProxy()
   * @see #setProxy()
   */
  public native function get proxy():DataProxy;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set proxy(value:*):void;

  [ArrayElementType("ext.data.Model")]
  /**
   * Temporary cache in which removed model instances are kept until successfully
   * synchronised with a Proxy, at which point this is cleared.
   * <p>This cache is maintained unless you set <code>→trackRemoved</code> to <code>false</code>.</p>
   * @see #trackRemoved
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#property-removed Original Ext JS documentation of 'removed'
   */
  public native function get removed():Array;

  [ExtConfig]
  [Bindable]
  /**
   * If true, any sorters attached to this Store will be run after loading data,
   * before the datachanged event is fired. Defaults to true, ignored if
   * →<code>ext.data.Store.remoteSort</code> is true
   * @default true
   * @see ext.data.Store#remoteSort
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#cfg-sortOnLoad Original Ext JS documentation of 'sortOnLoad'
   * @see #getSortOnLoad()
   * @see #setSortOnLoad()
   */
  public native function get sortOnLoad():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set sortOnLoad(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * This config controls whether removed records are remembered by this store for
   * later saving to the server.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#cfg-trackRemoved Original Ext JS documentation of 'trackRemoved'
   * @see #getTrackRemoved()
   * @see #setTrackRemoved()
   */
  public native function get trackRemoved():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set trackRemoved(value:Boolean):void;

  /**
   * Called when the event handler which called the →<code>load()</code> method exits.
   * @see #load()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#method-flushLoad Original Ext JS documentation of 'flushLoad'
   */
  public native function flushLoad():void;

  /**
   * Returns the value of <code>asynchronousLoad</code>.
   * @see #asynchronousLoad
   */
  public native function getAsynchronousLoad():Boolean;

  /**
   * Returns the value of <code>autoLoad</code>.
   * @see #autoLoad
   */
  public native function getAutoLoad():*;

  /**
   * Returns the value of <code>autoSync</code>.
   * @see #autoSync
   */
  public native function getAutoSync():Boolean;

  /**
   * Returns the value of <code>batchUpdateMode</code>.
   * @see #batchUpdateMode
   */
  public native function getBatchUpdateMode():String;

  /**
   * Returns the value of <code>fields</code>.
   * @see #fields
   */
  public native function getFields():*;

  /**
   * Returns the value of <code>model</code>.
   * @see #model
   */
  public native function getModel():*;

  [ArrayElementType("ext.data.Model")]
  /**
   * Gets all <i>records</i> (→<code>ext.data.Model</code>) added or updated since the last commit. Note that
   * the order of records returned is not deterministic and does not indicate the order in which
   * records were modified. Note also that removed records are not included
   * (use →<code>getRemovedRecords()</code> for that).
   * @return The added and updated Model instances
   * @see ext.data.Model
   * @see #getRemovedRecords()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#method-getModifiedRecords Original Ext JS documentation of 'getModifiedRecords'
   */
  public native function getModifiedRecords():Array;

  [ArrayElementType("ext.data.Model")]
  /**
   * Returns all <code>→ext.data.Model.phantom</code> records in this store.
   * @return A possibly empty array of <code>phantom</code> records.
   * @see ext.data.Model#phantom
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#method-getNewRecords Original Ext JS documentation of 'getNewRecords'
   */
  public native function getNewRecords():Array;

  /**
   * Returns the value of <code>proxy</code>.
   * @see #proxy
   */
  public native function getProxy():*;

  [ArrayElementType("ext.data.Model")]
  /**
   * Returns any records that have been removed from the store but not yet destroyed on the proxy.
   * @return The removed Model instances. Note that this is a <i>copy</i> of the
   * store's array, so may be mutated.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#method-getRemovedRecords Original Ext JS documentation of 'getRemovedRecords'
   */
  public native function getRemovedRecords():Array;

  /**
   * Returns the value of <code>sortOnLoad</code>.
   * @see #sortOnLoad
   */
  public native function getSortOnLoad():Boolean;

  /**
   * Returns the total number of →<code>ext.data.Model</code> instances that the
   * →<code>ext.data.proxy.DataProxy</code> indicates exist. This will usually differ from
   * →<code>getCount()</code> when using paging - getCount returns the number of records loaded into
   * the Store at the moment, getTotalCount returns the number of records that could be loaded
   * into the Store if the Store contained all data
   * @return The total number of Model instances available via the Proxy. 0 returned if
   * no value has been set via the reader.
   * @see ext.data.Model
   * @see ext.data.proxy.DataProxy
   * @see #getCount()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#method-getTotalCount Original Ext JS documentation of 'getTotalCount'
   */
  public native function getTotalCount():Number;

  /**
   * Returns the value of <code>trackRemoved</code>.
   * @see #trackRemoved
   */
  public native function getTrackRemoved():Boolean;

  [ArrayElementType("ext.data.Model")]
  /**
   * Returns all valid, non-phantom Model instances that have been updated in the Store but
   * not yet synchronized with the Proxy.
   * @return The updated Model instances
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#method-getUpdatedRecords Original Ext JS documentation of 'getUpdatedRecords'
   */
  public native function getUpdatedRecords():Array;

  /**
   * Returns <code>true</code> if the Store has been loaded.
   * @return <code>true</code> if the Store has been loaded.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#method-isLoaded Original Ext JS documentation of 'isLoaded'
   */
  override public native function isLoaded():Boolean;

  /**
   * Returns true if the Store is currently performing a load operation
   * @return <code>true</code> if the Store is currently loading
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#method-isLoading Original Ext JS documentation of 'isLoading'
   */
  override public native function isLoading():Boolean;

  /**
   * Marks this store as needing a load. When the current executing event handler exits,
   * this store will send a request to load using its configured →<code>proxy</code>.
   * <p>Upon return of the data from whatever data source the proxy connected to, the retrieved
   * <i>records</i> (→<code>ext.data.Model</code>) will be loaded into this store, and the optional callback
   * will be called. Example usage:</p>
   * <pre>
   * store.load({
   *     scope: this,
   *     callback: function(records, operation, success) {
   *         // the operation object
   *         // contains all of the details of the load operation
   *         console.log(records);
   *     }
   * });
   * </pre>
   * <p>If the callback scope does not need to be set, a function can simply be passed:</p>
   * <pre>
   * store.load(function(records, operation, success) {
   *     console.log('loaded records');
   * });
   * </pre>
   * @since 1.1.0
   * @param options This is passed into the
   * →<code>ext.data.operation.Operation</code> object that is created and then sent to the
   * proxy's →<code>ext.data.proxy.DataProxy.read()</code> function. In addition to the options listed below,
   * this object may contain properties to configure the
   * →<code>ext.data.operation.Operation</code>.
   * <ul>
   * <li><code>callback:Function</code> (optional) —
   * A function which is called when the response arrives.
   * <ul>
   * <li><code>records:Array</code> (optional) —
   * Array of records.
   * </li>
   * <li><code>operation:ext.data.operation.Operation</code> (optional) —
   * The Operation itself.
   * </li>
   * <li><code>success:Boolean</code> (optional) —
   * <code>true</code> when operation completed successfully.
   * </li>
   * </ul>
   * </li>
   * <li><code>addRecords:Boolean</code> (default = <code>false</code>) —
   * Specify as <code>true</code> to <i>add</i> the incoming records
   * rather than the default which is to have the incoming records <i>replace</i> the existing store
   * contents.
   * </li>
   * </ul>
   * @return this
   * @see #proxy
   * @see ext.data.Model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#method-load Original Ext JS documentation of 'load'
   * @see ext.data.operation.Operation
   * @see ext.data.proxy.DataProxy#read()
   */
  public native function load(options:Object = null):Store;

  /**
   * Reloads the store using the last options passed to the →<code>load()</code> method.
   * You can use the reload method to reload the store using the parameters from the last load()
   * call. For example:
   * <pre>
   * store.load({
   *     params : {
   *         userid : 22216
   *     }
   * });
   *
   * //...
   *
   * store.reload();
   * </pre>
   * <p>The initial →<code>load()</code> execution will pass the <code>userid</code> parameter in the request.
   * The →<code>reload()</code> execution will also send the same <code>userid</code> parameter in its request
   * as it will reuse the <code>params</code> object from the last →<code>load()</code> call.</p>
   * <p>You can override a param by passing in the config object with the <code>params</code> object:</p>
   * <pre>
   * store.load({
   *     params : {
   *         userid : 22216,
   *         foo    : 'bar'
   *     }
   * });
   *
   * //...
   *
   * store.reload({
   *     params : {
   *         userid : 1234
   *     }
   * });
   * </pre>
   * <p>The initial →<code>load()</code> execution sends the <code>userid</code> and <code>foo</code> parameters but in the
   * →<code>reload()</code> it only sends the <code>userid</code> paramter because you are overriding the <code>params</code>
   * config not just overriding the one param. To only change a single param but keep other
   * params, you will have to get the last params from the →<code>lastOptions</code> property:</p>
   * <pre>
   * // make a copy of the last params so we don't affect future reload() calls
   * var lastOptions = store.lastOptions,
   *     lastParams = Ext.clone(lastOptions.params);
   *
   * lastParams.userid = 1234;
   *
   * store.reload({
   *     params : lastParams
   * });
   * </pre>
   * <p>This will now send the <code>userid</code> parameter as <code>1234</code> and the <code>foo</code> param as <code>'bar'</code>.</p>
   * @param options A config object which contains options which may override the
   * options passed to the previous load call. See the
   * →<code>load()</code> method for valid configs.
   * @see #load()
   * @see #reload()
   * @see #lastOptions
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#method-reload Original Ext JS documentation of 'reload'
   */
  public native function reload(options:Object = null):void;

  /**
   * Removes all records from the store. This method does a "fast remove",
   * individual remove events are not called. The →<code>event:onClear</code> event is
   * fired upon completion.
   * @since 1.1.0
   * @see #event:onClear
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#method-removeAll Original Ext JS documentation of 'removeAll'
   */
  public native function removeAll():void;

  /**
   * Resumes automatically syncing the Store with its Proxy. Only applicable if
   * →<code>autoSync</code> is <code>true</code>
   * @param syncNow Pass <code>true</code> to synchronize now. Only synchronizes with the Proxy
   * if the suspension count has gone to zero (We are not under a higher level of suspension)
   * @see #autoSync
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#method-resumeAutoSync Original Ext JS documentation of 'resumeAutoSync'
   */
  public native function resumeAutoSync(syncNow:Boolean):void;

  [Deprecated(message="Will be removed in the next major version\n", since="4.0.0")]
  /**
   * Saves all pending changes via the configured →<code>proxy</code>. Use →<code>sync()</code> instead.
   * @see #proxy
   * @see #sync()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#method-save Original Ext JS documentation of 'save'
   */
  public native function save():Number;

  /**
   * Sets the value of <code>asynchronousLoad</code>.
   * @param asynchronousLoad The new value.
   * @see #asynchronousLoad
   */
  public native function setAsynchronousLoad(asynchronousLoad:Boolean):void;

  /**
   * Sets the value of <code>autoLoad</code>.
   * @param autoLoad The new value.
   * @see #autoLoad
   */
  public native function setAutoLoad(autoLoad:*):void;

  /**
   * Sets the value of <code>autoSync</code>.
   * @param autoSync The new value.
   * @see #autoSync
   */
  public native function setAutoSync(autoSync:Boolean):void;

  /**
   * Sets the value of <code>batchUpdateMode</code>.
   * @param batchUpdateMode The new value.
   * @see #batchUpdateMode
   */
  public native function setBatchUpdateMode(batchUpdateMode:String):void;

  /**
   * Sets the value of <code>fields</code>.
   * @param fields The new value.
   * @see #fields
   */
  public native function setFields(fields:*):void;

  /**
   * Sets the value of <code>model</code>.
   * @param model The new value.
   * @see #model
   */
  public native function setModel(model:*):void;

  /**
   * Sets the value of <code>proxy</code>.
   * @param proxy The new value.
   * @see #proxy
   */
  public native function setProxy(proxy:*):void;

  /**
   * Sets the value of <code>sortOnLoad</code>.
   * @param sortOnLoad The new value.
   * @see #sortOnLoad
   */
  public native function setSortOnLoad(sortOnLoad:Boolean):void;

  /**
   * Sets the value of <code>trackRemoved</code>.
   * @param trackRemoved The new value.
   * @see #trackRemoved
   */
  public native function setTrackRemoved(trackRemoved:Boolean):void;

  /**
   * Suspends automatically syncing the Store with its Proxy. Only applicable if
   * →<code>autoSync</code> is <code>true</code>
   * @see #autoSync
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#method-suspendAutoSync Original Ext JS documentation of 'suspendAutoSync'
   */
  public native function suspendAutoSync():void;

  /**
   * Synchronizes the store with its →<code>proxy</code>. This asks the proxy to batch together any
   * new, updated and deleted records in the store, updating the store's internal representation
   * of the records as each operation completes.
   * @param options Object containing one or more properties supported by the sync
   * method (these get passed along to the underlying proxy's →<code>ext.data.proxy.DataProxy.batch()</code>
   * method):
   * <ul>
   * <li><code>batch</code> (optional) —
   * A →<code>ext.data.Batch</code> object (or batch
   * config to apply to the created batch). If unspecified a default batch will be auto-created
   * as needed.
   * </li>
   * <li><code>callback:Function</code> (optional) —
   * The function to be called upon completion of the sync.
   * The callback is called regardless of success or failure and is passed the following
   * parameters:
   * <ul>
   * <li><code>batch:ext.data.Batch</code> (optional) —
   * The <i>batch</i> (→<code>ext.data.Batch</code>) that was
   * processed, containing all operations in their current state after processing
   * </li>
   * <li><code>options:Object</code> (optional) —
   * The options argument that was originally passed
   * into sync
   * </li>
   * </ul>
   * </li>
   * <li><code>success:Function</code> (optional) —
   * The function to be called upon successful completion
   * of the sync. The success function is called only if no exceptions were reported in any
   * operations. If one or more exceptions occurred then the failure function will be called
   * instead. The success function is called with the following parameters:
   * <ul>
   * <li><code>batch:ext.data.Batch</code> (optional) —
   * The <i>batch</i> (→<code>ext.data.Batch</code>) that was
   * processed, containing all operations in their current state after processing
   * </li>
   * <li><code>options:Object</code> (optional) —
   * The options argument that was originally passed
   * into sync
   * </li>
   * </ul>
   * </li>
   * <li><code>failure:Function</code> (optional) —
   * The function to be called upon unsuccessful completion
   * of the sync. The failure function is called when one or more operations returns an exception
   * during processing (even if some operations were also successful). In this case you can check
   * the batch's →<code>ext.data.Batch.exceptions</code> array to see exactly which
   * operations had exceptions. The failure function is called with the following parameters:
   * <ul>
   * <li><code>batch:ext.data.Batch</code> (optional) —
   * The →<code>ext.data.Batch</code> that was processed,
   * containing all operations in their current state after processing
   * </li>
   * <li><code>options:Object</code> (optional) —
   * The options argument that was originally passed
   * into sync
   * </li>
   * </ul>
   * </li>
   * <li><code>params:Object</code> (optional) —
   * Additional params to send during the sync Operation(s).
   * </li>
   * <li><code>scope:Object</code> (optional) —
   * The scope in which to execute any callbacks (i.e. the <code>this</code>
   * object inside the callback, success and/or failure functions). Defaults to the store's proxy.
   * </li>
   * </ul>
   * @return this
   * @see #proxy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ProxyStore.html#method-sync Original Ext JS documentation of 'sync'
   * @see ext.data.proxy.DataProxy#batch()
   * @see ext.data.Batch
   * @see ext.data.Batch#exceptions
   */
  public native function sync(options:Object = null):Store;
}
}