package ext.data {
import ext.Base;
import ext.data.operation.Operation;
import ext.data.proxy.DataProxy;

[Native("Ext.data.Request", require)]
/**
 * Simple class that represents a Request that will be made by any →<code>ext.data.proxy.ServerProxy</code>
 * subclass. All this class does is standardize the representation of a Request as used by any
 * ServerProxy subclass, it does not contain any actual logic or perform the request itself.
 * @see ext.data.proxy.ServerProxy
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html Original Ext JS documentation of 'Ext.data.Request'
 */
public class Request extends Base {
  /**
   * Creates the Request object.
   * @param config Config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Request(config:Request = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The name of the action this Request represents. Usually one of 'create', 'read',
   * 'update' or 'destroy'.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#cfg-action Original Ext JS documentation of 'action'
   * @see #getAction()
   * @see #setAction()
   */
  public native function get action():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set action(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * True to request binary data from the server. This feature requires
   * the use of a binary reader such as <i>AMF Reader</i> (→<code>null</code>)
   * @default false
   * @see null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#cfg-binary Original Ext JS documentation of 'binary'
   * @see #getBinary()
   * @see #setBinary()
   */
  public native function get binary():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set binary(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Some requests (like JsonP) want to send an additional key that contains
   * the name of the callback function.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#cfg-callbackKey Original Ext JS documentation of 'callbackKey'
   * @see #getCallbackKey()
   * @see #setCallbackKey()
   */
  public native function get callbackKey():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set callbackKey(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Whether or not to disable caching for this request.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#cfg-disableCaching Original Ext JS documentation of 'disableCaching'
   * @see #getDisableCaching()
   * @see #setDisableCaching()
   */
  public native function get disableCaching():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set disableCaching(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Some requests (like XMLHttpRequests) want to send additional server headers.
   * This configuration can be set for those types of requests.
   * @default {}
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#cfg-headers Original Ext JS documentation of 'headers'
   * @see #getHeaders()
   * @see #setHeaders()
   */
  public native function get headers():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set headers(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * This is used by some write actions to attach data to the request without encoding it
   * as a parameter.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#cfg-jsonData Original Ext JS documentation of 'jsonData'
   * @see #getJsonData()
   * @see #setJsonData()
   */
  public native function get jsonData():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set jsonData(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The HTTP method to use on this Request. Should be one of 'GET', 'POST', 'PUT',
   * or 'DELETE'.
   * @default 'GET'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#cfg-method Original Ext JS documentation of 'method'
   * @see #getMethod()
   * @see #setMethod()
   */
  public native function get method():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set method(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The operation this request belongs to.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#cfg-operation Original Ext JS documentation of 'operation'
   * @see #getOperation()
   * @see #setOperation()
   */
  public native function get operation():Operation;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set operation(value:Operation):void;

  [ExtConfig]
  [Bindable]
  /**
   * HTTP request params. The Proxy and its Writer have access to and can modify this object.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#cfg-params Original Ext JS documentation of 'params'
   * @see #getParams()
   * @see #setParams()
   */
  public native function get params():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set params(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Most oData feeds require basic HTTP authentication. This configuration allows
   * you to specify the password.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#cfg-password Original Ext JS documentation of 'password'
   * @see #getPassword()
   * @see #setPassword()
   */
  public native function get password():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set password(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The proxy this request belongs to.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#cfg-proxy Original Ext JS documentation of 'proxy'
   * @see #getProxy()
   * @see #setProxy()
   */
  public native function get proxy():DataProxy;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set proxy(value:DataProxy):void;

  [ExtConfig]
  [Bindable]
  /**
   * The url to access on this Request.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#cfg-url Original Ext JS documentation of 'url'
   * @see #getUrl()
   * @see #setUrl()
   */
  public native function get url():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set url(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Most oData feeds require basic HTTP authentication. This configuration allows
   * you to specify the username.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#cfg-username Original Ext JS documentation of 'username'
   * @see #getUsername()
   * @see #setUsername()
   */
  public native function get username():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set username(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * This field is necessary when using cross-origin resource sharing.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#cfg-withCredentials Original Ext JS documentation of 'withCredentials'
   * @see #getWithCredentials()
   * @see #setWithCredentials()
   */
  public native function get withCredentials():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set withCredentials(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * This is used by some write actions to attach data to the request without encoding it
   * as a parameter, but instead sending it as XML.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#cfg-xmlData Original Ext JS documentation of 'xmlData'
   * @see #getXmlData()
   * @see #setXmlData()
   */
  public native function get xmlData():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set xmlData(value:Object):void;

  /**
   * Returns the value of <code>action</code>.
   * @see #action
   */
  public native function getAction():String;

  /**
   * Returns the value of <code>binary</code>.
   * @see #binary
   */
  public native function getBinary():Boolean;

  /**
   * Returns the value of <code>callbackKey</code>.
   * @see #callbackKey
   */
  public native function getCallbackKey():String;

  /**
   * Returns the value of <code>disableCaching</code>.
   * @see #disableCaching
   */
  public native function getDisableCaching():Boolean;

  /**
   * Returns the value of <code>headers</code>.
   * @see #headers
   */
  public native function getHeaders():Object;

  /**
   * Returns the value of <code>jsonData</code>.
   * @see #jsonData
   */
  public native function getJsonData():Object;

  /**
   * Returns the value of <code>method</code>.
   * @see #method
   */
  public native function getMethod():String;

  /**
   * Returns the value of <code>operation</code>.
   * @see #operation
   */
  public native function getOperation():Operation;

  /**
   * Gets a single param from the →<code>params</code>.
   * @param key The key for the param.
   * @return The value for the param. <code>undefined</code> if it does not exist.
   * @see #params
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#method-getParam Original Ext JS documentation of 'getParam'
   */
  public native function getParam(key:String):Object;

  /**
   * Returns the value of <code>params</code>.
   * @see #params
   */
  public native function getParams():Object;

  /**
   * Returns the value of <code>password</code>.
   * @see #password
   */
  public native function getPassword():String;

  /**
   * Returns the value of <code>proxy</code>.
   * @see #proxy
   */
  public native function getProxy():DataProxy;

  /**
   * Returns the value of <code>url</code>.
   * @see #url
   */
  public native function getUrl():String;

  /**
   * Returns the value of <code>username</code>.
   * @see #username
   */
  public native function getUsername():String;

  /**
   * Returns the value of <code>withCredentials</code>.
   * @see #withCredentials
   */
  public native function getWithCredentials():Boolean;

  /**
   * Returns the value of <code>xmlData</code>.
   * @see #xmlData
   */
  public native function getXmlData():Object;

  /**
   * Sets the value of <code>action</code>.
   * @param action The new value.
   * @see #action
   */
  public native function setAction(action:String):void;

  /**
   * Sets the value of <code>binary</code>.
   * @param binary The new value.
   * @see #binary
   */
  public native function setBinary(binary:Boolean):void;

  /**
   * Sets the value of <code>callbackKey</code>.
   * @param callbackKey The new value.
   * @see #callbackKey
   */
  public native function setCallbackKey(callbackKey:String):void;

  /**
   * Sets the value of <code>disableCaching</code>.
   * @param disableCaching The new value.
   * @see #disableCaching
   */
  public native function setDisableCaching(disableCaching:Boolean):void;

  /**
   * Sets the value of <code>headers</code>.
   * @param headers The new value.
   * @see #headers
   */
  public native function setHeaders(headers:Object):void;

  /**
   * Sets the value of <code>jsonData</code>.
   * @param jsonData The new value.
   * @see #jsonData
   */
  public native function setJsonData(jsonData:Object):void;

  /**
   * Sets the value of <code>method</code>.
   * @param method The new value.
   * @see #method
   */
  public native function setMethod(method:String):void;

  /**
   * Sets the value of <code>operation</code>.
   * @param operation The new value.
   * @see #operation
   */
  public native function setOperation(operation:Operation):void;

  /**
   * Sets a single param value in the →<code>params</code>.
   * @param key The key to set.
   * @param value The value to set.
   * @see #params
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.Request.html#method-setParam Original Ext JS documentation of 'setParam'
   */
  public native function setParam(key:String, value:Object):void;

  /**
   * Sets the value of <code>params</code>.
   * @param params The new value.
   * @see #params
   */
  public native function setParams(params:Object):void;

  /**
   * Sets the value of <code>password</code>.
   * @param password The new value.
   * @see #password
   */
  public native function setPassword(password:String):void;

  /**
   * Sets the value of <code>proxy</code>.
   * @param proxy The new value.
   * @see #proxy
   */
  public native function setProxy(proxy:DataProxy):void;

  /**
   * Sets the value of <code>url</code>.
   * @param url The new value.
   * @see #url
   */
  public native function setUrl(url:String):void;

  /**
   * Sets the value of <code>username</code>.
   * @param username The new value.
   * @see #username
   */
  public native function setUsername(username:String):void;

  /**
   * Sets the value of <code>withCredentials</code>.
   * @param withCredentials The new value.
   * @see #withCredentials
   */
  public native function setWithCredentials(withCredentials:Boolean):void;

  /**
   * Sets the value of <code>xmlData</code>.
   * @param xmlData The new value.
   * @see #xmlData
   */
  public native function setXmlData(xmlData:Object):void;
}
}