package ext.data {
import ext.Base;

[Native("Ext.data.ResultSet", require)]
/**
 * Simple wrapper class that represents a set of records returned by a Proxy.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ResultSet.html Original Ext JS documentation of 'Ext.data.ResultSet'
 */
public class ResultSet extends Base {
  /**
   * Creates the resultSet
   * @param config Config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ResultSet.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function ResultSet(config:ResultSet = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The number of records in this ResultSet. Note that total may differ from this number.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ResultSet.html#cfg-count Original Ext JS documentation of 'count'
   * @see #getCount()
   * @see #setCount()
   */
  public native function get count():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set count(value:Number):void;

  [ArrayElementType("ext.data.Model")]
  [ExtConfig]
  [Bindable]
  /**
   * The grouping data.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ResultSet.html#cfg-groupData Original Ext JS documentation of 'groupData'
   * @see #getGroupData()
   * @see #setGroupData()
   */
  public native function get groupData():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set groupData(value:Array):void;

  /**
   * Identifies this class as a result set.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ResultSet.html#property-isResultSet Original Ext JS documentation of 'isResultSet'
   */
  public native function get isResultSet():Boolean;

  /**
   * @private
   */
  public native function set isResultSet(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * True if the records have already been loaded. This is only meaningful when dealing with
   * SQL-backed proxies.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ResultSet.html#cfg-loaded Original Ext JS documentation of 'loaded'
   * @see #getLoaded()
   * @see #setLoaded()
   */
  public native function get loaded():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set loaded(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The message that was read in from the data
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ResultSet.html#cfg-message Original Ext JS documentation of 'message'
   * @see #getMessage()
   * @see #setMessage()
   */
  public native function get message():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set message(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The metadata object from a server sourced JSON data packet.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ResultSet.html#cfg-metadata Original Ext JS documentation of 'metadata'
   * @see #getMetadata()
   * @see #setMetadata()
   */
  public native function get metadata():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set metadata(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * <b>This is a required setting</b>. The array of record instances or record config objects.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ResultSet.html#cfg-records Original Ext JS documentation of 'records'
   * @see #getRecords()
   * @see #setRecords()
   */
  public native function get records():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set records(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The total number of records reported by the remote data source.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ResultSet.html#cfg-remoteTotal Original Ext JS documentation of 'remoteTotal'
   * @see #getRemoteTotal()
   * @see #setRemoteTotal()
   */
  public native function get remoteTotal():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set remoteTotal(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * True if the ResultSet loaded successfully, false if any errors were encountered.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ResultSet.html#cfg-success Original Ext JS documentation of 'success'
   * @see #getSuccess()
   * @see #setSuccess()
   */
  public native function get success():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set success(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The summary data.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ResultSet.html#cfg-summaryData Original Ext JS documentation of 'summaryData'
   * @see #getSummaryData()
   * @see #setSummaryData()
   */
  public native function get summaryData():Model;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set summaryData(value:Model):void;

  [ExtConfig]
  [Bindable]
  /**
   * The total number of records reported by the data source. This ResultSet may form
   * a subset of those records (see →<code>count</code>).
   * @default null
   * @see #count
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.ResultSet.html#cfg-total Original Ext JS documentation of 'total'
   * @see #getTotal()
   * @see #setTotal()
   */
  public native function get total():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set total(value:Number):void;

  /**
   * Returns the value of <code>count</code>.
   * @see #count
   */
  public native function getCount():Number;

  [ArrayElementType("ext.data.Model")]
  /**
   * Returns the value of <code>groupData</code>.
   * @see #groupData
   */
  public native function getGroupData():Array;

  /**
   * Returns the value of <code>loaded</code>.
   * @see #loaded
   */
  public native function getLoaded():Boolean;

  /**
   * Returns the value of <code>message</code>.
   * @see #message
   */
  public native function getMessage():String;

  /**
   * Returns the value of <code>metadata</code>.
   * @see #metadata
   */
  public native function getMetadata():Object;

  /**
   * Returns the value of <code>records</code>.
   * @see #records
   */
  public native function getRecords():*;

  /**
   * Returns the value of <code>remoteTotal</code>.
   * @see #remoteTotal
   */
  public native function getRemoteTotal():Number;

  /**
   * Returns the value of <code>success</code>.
   * @see #success
   */
  public native function getSuccess():Boolean;

  /**
   * Returns the value of <code>summaryData</code>.
   * @see #summaryData
   */
  public native function getSummaryData():Model;

  /**
   * Returns the value of <code>total</code>.
   * @see #total
   */
  public native function getTotal():Number;

  /**
   * Sets the value of <code>count</code>.
   * @param count The new value.
   * @see #count
   */
  public native function setCount(count:Number):void;

  /**
   * Sets the value of <code>groupData</code>.
   * @param groupData The new value.
   * @see #groupData
   */
  public native function setGroupData(groupData:Array):void;

  /**
   * Sets the value of <code>loaded</code>.
   * @param loaded The new value.
   * @see #loaded
   */
  public native function setLoaded(loaded:Boolean):void;

  /**
   * Sets the value of <code>message</code>.
   * @param message The new value.
   * @see #message
   */
  public native function setMessage(message:String):void;

  /**
   * Sets the value of <code>metadata</code>.
   * @param metadata The new value.
   * @see #metadata
   */
  public native function setMetadata(metadata:Object):void;

  /**
   * Sets the value of <code>records</code>.
   * @param records The new value.
   * @see #records
   */
  public native function setRecords(records:*):void;

  /**
   * Sets the value of <code>remoteTotal</code>.
   * @param remoteTotal The new value.
   * @see #remoteTotal
   */
  public native function setRemoteTotal(remoteTotal:Number):void;

  /**
   * Sets the value of <code>success</code>.
   * @param success The new value.
   * @see #success
   */
  public native function setSuccess(success:Boolean):void;

  /**
   * Sets the value of <code>summaryData</code>.
   * @param summaryData The new value.
   * @see #summaryData
   */
  public native function setSummaryData(summaryData:Model):void;

  /**
   * Sets the value of <code>total</code>.
   * @param total The new value.
   * @see #total
   */
  public native function setTotal(total:Number):void;
}
}