package ext.data {
import ext.Base;

[Native]
/**
 * This class is used to create JSONP requests. JSONP is a mechanism that allows for making
 * requests for data cross domain. JSONP is basically a <code>&lt;script&gt;</code> node with the source of the url
 * executing a function that was created by Ext.data.JsonP. Once the resource has loaded, the
 * <code>&lt;script&gt;</code> node will be destroyed.
 * <p>If you have a request such as:</p>
 * <pre>
 * Ext.data.JsonP.request({
 *     url : 'foo.php'
 * });
 * </pre>
 * <p>Ext.data.JsonP will create a <code>&lt;script&gt;</code> node in the <code>&lt;head&gt;</code> with the <code>src</code> attribute pointing
 * to <code>foo.php?callback=Ext.data.JsonP.callback1</code>. The <code>foo.php</code> script will have to detect the
 * <code>callback</code> URL parameter and return valid JavaScript:</p>
 * <pre>
 * Ext.data.JsonP.callback1({"foo":"bar"});
 * </pre>
 * <p>A simple PHP example would look like:</p>
 * <pre>
 * &lt;?php
 *
 * $data = array('foo' =&gt; 'bar');
 *
 * if (!empty($_REQUEST['callback'])) {
 *     header('Content-Type: application/javascript');
 *     echo $_REQUEST['callback'] . '(';
 * }
 *
 * echo json_encode($data);
 *
 * if (!empty($_REQUEST['callback']) {
 *     echo ');';
 * }
 *
 * ?&gt;
 * </pre>
 * <p>More information is available <a href="http://en.wikipedia.org/wiki/JSONP">here</a>. You can
 * also use <a href="http://www.jsonplint.com">JSONPLint</a> to test your JSONP.</p>
 * <p>Type of singleton JsonP.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.JsonP.html Original Ext JS documentation of 'Ext.data.JsonP'
 * @see ext.data.#JsonP ext.data.JsonP
 */
public class SJsonP extends Base {
  /**
   * Specifies the GET parameter that will be sent to the server containing the function name to
   * be executed when the request completes. Defaults to <tt>callback</tt>. Thus, a common
   * request will be in the form of url?callback=Ext.data.JsonP.callback1
   * @default 'callback'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.JsonP.html#property-callbackKey Original Ext JS documentation of 'callbackKey'
   */
  public native function get callbackKey():String;

  /**
   * @private
   */
  public native function set callbackKey(value:String):void;

  /**
   * True to add a unique cache-buster param to requests. Defaults to <tt>true</tt>.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.JsonP.html#property-disableCaching Original Ext JS documentation of 'disableCaching'
   */
  public native function get disableCaching():Boolean;

  /**
   * @private
   */
  public native function set disableCaching(value:Boolean):void;

  /**
   * Change the parameter which is sent went disabling caching through a cache buster. Defaults
   * to <tt>'_dc'</tt>.
   * @default '_dc'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.JsonP.html#property-disableCachingParam Original Ext JS documentation of 'disableCachingParam'
   */
  public native function get disableCachingParam():String;

  /**
   * @private
   */
  public native function set disableCachingParam(value:String):void;

  /**
   * A default timeout for any JsonP requests. If the request has not completed in this time the
   * failure callback will be fired. The timeout is in ms. Defaults to <tt>30000</tt>.
   * @default 30000
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.JsonP.html#property-timeout Original Ext JS documentation of 'timeout'
   */
  public native function get timeout():Number;

  /**
   * @private
   */
  public native function set timeout(value:Number):void;

  /**
   * Abort a request. If the request parameter is not specified all open requests will
   * be aborted.
   * @param request The request to abort
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.JsonP.html#method-abort Original Ext JS documentation of 'abort'
   */
  public native function abort(request:* = undefined):void;

  /**
   * Makes a JSONP request.
   * @param options An object which may contain the following properties. Note that
   * options will take priority over any defaults that are specified in the class.
   * <ul>
   * <li><code>url:String</code> (optional) —
   * The URL to request.
   * </li>
   * <li><code>params:Object</code> (optional) —
   * An object containing a series of key value pairs
   * that will be sent along with the request.
   * </li>
   * <li><code>timeout:Number</code> (optional) —
   * See →<code>timeout</code>
   * </li>
   * <li><code>callbackKey:String</code> (optional) —
   * See →<code>callbackKey</code>
   * </li>
   * <li><code>callbackName:String</code> (optional) —
   * The function name to use for this request. By
   * default this name will be auto-generated: Ext.data.JsonP.callback1, Ext.data.JsonP.callback2,
   * etc. Setting this option to "my_name" will force the function name to be
   * Ext.data.JsonP.my_name. Use this if you want deterministic behavior, but be careful - the
   * callbackName should be different in each JsonP request that you make.
   * </li>
   * <li><code>disableCaching:Boolean</code> (optional) —
   * See →<code>disableCaching</code>
   * </li>
   * <li><code>disableCachingParam:String</code> (optional) —
   * See →<code>disableCachingParam</code>
   * </li>
   * <li><code>success:Function</code> (optional) —
   * A function to execute if the request succeeds.
   * </li>
   * <li><code>failure:Function</code> (optional) —
   * A function to execute if the request fails.
   * </li>
   * <li><code>callback:Function</code> (optional) —
   * A function to execute when the request
   * completes, whether it is a success or failure.
   * </li>
   * <li><code>scope:Object</code> (optional) —
   * The scope in which to execute the callbacks:
   * The "this" object for the callback function. Defaults to the browser window.
   * </li>
   * </ul>
   * @return request An object containing the request details.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.JsonP.html#method-request Original Ext JS documentation of 'request'
   * @see SJsonP#timeout
   * @see SJsonP#callbackKey
   * @see SJsonP#disableCaching
   * @see SJsonP#disableCachingParam
   */
  public native function request(options:Object):Object;
}
}