package ext.data {
import ext.Base;

[Native]
/**
 * This class defines a series of static methods that are used on a
 * →<code>ext.data.field.DataField</code> for performing sorting. The methods cast the
 * underlying values into a data type that is appropriate for sorting on
 * that particular field. If a →<code>ext.data.field.DataField.type</code> is specified,
 * the sortType will be set to a sane default if the sortType is not
 * explicitly defined on the field. The sortType will make any necessary
 * modifications to the value and return it.
 * <ul>
 * <li><b><code>→asText()</code></b> - Removes any tags and converts the value to a string</li>
 * <li><b><code>→asUCText()</code></b> - Removes any tags and converts the value to an uppercase string</li>
 * <li><b><code>→asUCString()</code></b> - Converts the value to an uppercase string</li>
 * <li><b><code>→asDate()</code></b> - Converts the value into Unix epoch time</li>
 * <li><b><code>→asFloat()</code></b> - Converts the value to a floating point number</li>
 * <li><b><code>→asInt()</code></b> - Converts the value to an integer number</li>
 * </ul>
 * <p>It is also possible to create a custom sortType that can be used throughout
 * an application.</p>
 * <pre>
 *  Ext.apply(Ext.data.SortTypes, {
 *      asPerson: function(person){
 *          // expects an object with a first and last name property
 *          return person.lastName.toUpperCase() + person.firstName.toLowerCase();
 *      }
 *  });
 *
 *  Ext.define('Employee', {
 *      extend: 'Ext.data.Model',
 *      fields: [{
 *          name: 'person',
 *          sortType: 'asPerson'
 *      }, {
 *          name: 'salary',
 *          type: 'float' // sortType set to asFloat
 *      }]
 *  });
 * </pre>
 * <p>Type of singleton SortTypes.</p>
 * @see ext.data.field.DataField
 * @see ext.data.field.DataField#type
 * @see SSortTypes#asText()
 * @see SSortTypes#asUCText()
 * @see SSortTypes#asUCString()
 * @see SSortTypes#asDate()
 * @see SSortTypes#asFloat()
 * @see SSortTypes#asInt()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.SortTypes.html Original Ext JS documentation of 'Ext.data.SortTypes'
 * @see ext.data.#SortTypes ext.data.SortTypes
 */
public class SSortTypes extends Base {
  /**
   * Default sort that does nothing
   * @default Ext.identityFn
   * <ul>
   * <li><code>s:Object</code> —
   * The value being converted
   * </li>
   * <li><code>null:Object</code> —
   * The comparison value
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.SortTypes.html#property-none Original Ext JS documentation of 'none'
   */
  public native function get none():*;

  /**
   * @private
   */
  public native function set none(value:*):void;

  /**
   * The regular expression used to strip commas
   * @default /,/g
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.SortTypes.html#property-stripCommasRe Original Ext JS documentation of 'stripCommasRe'
   */
  public native function get stripCommasRe():RegExp;

  /**
   * @private
   */
  public native function set stripCommasRe(value:RegExp):void;

  /**
   * The regular expression used to strip tags
   * @default /<\/?[^>]+>/gi
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.SortTypes.html#property-stripTagsRE Original Ext JS documentation of 'stripTagsRE'
   */
  public native function get stripTagsRE():RegExp;

  /**
   * @private
   */
  public native function set stripTagsRE(value:RegExp):void;

  /**
   * Date sorting
   * @param s The value being converted
   * @return The comparison value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.SortTypes.html#method-asDate Original Ext JS documentation of 'asDate'
   */
  public native function asDate(s:Object):Number;

  /**
   * Float sorting
   * @param s The value being converted
   * @return The comparison value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.SortTypes.html#method-asFloat Original Ext JS documentation of 'asFloat'
   */
  public native function asFloat(s:Object):Number;

  /**
   * Integer sorting
   * @param s The value being converted
   * @return The comparison value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.SortTypes.html#method-asInt Original Ext JS documentation of 'asInt'
   */
  public native function asInt(s:Object):Number;

  /**
   * Strips all HTML tags to sort on text only
   * @param s The value being converted
   * @return The comparison value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.SortTypes.html#method-asText Original Ext JS documentation of 'asText'
   */
  public native function asText(s:Object):String;

  /**
   * Case insensitive string
   * @param s The value being converted
   * @return The comparison value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.SortTypes.html#method-asUCString Original Ext JS documentation of 'asUCString'
   */
  public native function asUCString(s:Object):String;

  /**
   * Strips all HTML tags to sort on text only - Case insensitive
   * @param s The value being converted
   * @return The comparison value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.SortTypes.html#method-asUCText Original Ext JS documentation of 'asUCText'
   */
  public native function asUCText(s:Object):String;
}
}