package ext.data {
import ext.util.MixedCollection;

[Native]
/**
 * Contains a collection of all stores that are created that have an identifier. An identifier
 * can be assigned by setting the →<code>ext.data.AbstractStore.storeId</code> property. When
 * a store is in the StoreManager, it can be referred to via it's identifier:
 * <pre>
 * Ext.create('Ext.data.Store', {
 *     model: 'SomeModel',
 *     storeId: 'myStore'
 * });
 *
 * var store = Ext.data.StoreManager.lookup('myStore');
 * </pre>
 * <p>Also note that the →<code>lookup()</code> method is aliased to →<code>ext.Ext.getStore()</code> for convenience.</p>
 * <p>If a store is registered with the StoreManager, you can also refer to the store by its
 * identifier when registering it with any Component that consumes data from a store:</p>
 * <pre>
 * Ext.create('Ext.data.Store', {
 *     model: 'SomeModel',
 *     storeId: 'myStore'
 * });
 *
 * Ext.create('Ext.view.View', {
 *     store: 'myStore',
 *     // other configuration here
 * });
 * </pre>
 * <p>Type of singleton StoreManager.</p>
 * @see ext.data.AbstractStore#storeId
 * @see SStoreManager#lookup()
 * @see ext.SExt#getStore() ext.Ext.getStore()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.StoreManager.html Original Ext JS documentation of 'Ext.data.StoreManager'
 * @see ext.data.#StoreManager ext.data.StoreManager
 */
public class SStoreManager extends MixedCollection {
  /**
   * @inheritDoc
   */
  public function SStoreManager(config:MixedCollection = null) {
    super();
  }

  /**
   * Gets a registered Store by id
   * @param store The id of the Store, or a Store instance, or a store
   * configuration
   * @param defaultType The store type to create when used with store configuration
   * and there is no type specified on the config.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.StoreManager.html#method-lookup Original Ext JS documentation of 'lookup'
   */
  public native function lookup(store:*, defaultType:String = null):Store;

  /**
   * Registers one or more Stores with the StoreManager. You do not normally need to register
   * stores manually. Any store initialized with a →<code>ext.data.Store.storeId</code> will be
   * auto-registered.
   * @param stores Any number of Store instances
   * @see ext.data.Store#storeId
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.StoreManager.html#method-register Original Ext JS documentation of 'register'
   */
  public native function register(...stores):void;

  /**
   * Unregisters one or more Stores with the StoreManager
   * @param stores Any number of Store instances or ID-s
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.data.StoreManager.html#method-unregister Original Ext JS documentation of 'unregister'
   */
  public native function unregister(...stores):void;
}
}